package com.bwt.blocks;

import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;

public class ScrewPumpBlock extends class_2248 implements MechPowerBlockBase {
    public static final MapCodec<ScrewPumpBlock> CODEC = method_54094(ScrewPumpBlock::new);
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 JAMMED = class_2746.method_11825("jammed");

    protected static final int tickRate = 20;

    public ScrewPumpBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(MECH_POWERED, false).method_11657(JAMMED, false));
    }

    @Override
    protected MapCodec<ScrewPumpBlock> method_53969() {
        return field_46280;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        MechPowerBlockBase.super.appendProperties(builder);
        builder.method_11667(FACING);
        builder.method_11667(JAMMED);
    }

    @Override
    public boolean isMechPowered(class_2680 blockState) {
        return MechPowerBlockBase.super.isMechPowered(blockState);
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> direction.equals(class_2350.field_11033);
    }

    @Override
    public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction ->
                direction.method_10166().method_10179()
                && !direction.equals(blockState.method_28500(FACING).orElse(null));
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        schedulePowerUpdate(state, world, pos);
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        if (isReceivingMechPower(world, state, pos) != isMechPowered(state)) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        schedulePowerUpdate(state, world, pos);
    }

}
