package com.bwt.blocks;

import com.bwt.blocks.mining_charge.ICaughtFireBlock;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2530;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4770;
import net.minecraft.class_4775;
import net.minecraft.class_5819;
import net.minecraft.class_6908;
import net.minecraft.world.*;

public class StokedFireBlock extends class_4770 {
    public static final class_2758 AGE = class_2741.field_12556;
    public static final class_2746 TWO_HIGH = class_2746.method_11825("two_high");
    public static final int tickRate = 42;

    public static final MapCodec<StokedFireBlock> field_46280 = class_4775.method_54094(StokedFireBlock::new);

    public MapCodec<StokedFireBlock> method_53969() {
        return field_46280;
    }

    public StokedFireBlock(class_2251 settings) {
        super(settings, 4.0f);
        method_9590(method_9564().method_11657(AGE, 0).method_11657(TWO_HIGH, true));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AGE, TWO_HIGH);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = super.method_9605(ctx);
        return getPlacementState(ctx.method_8045(), ctx.method_8037(), state);
    }

    public class_2680 getPlacementState(class_1937 world, class_2338 pos) {
        return getPlacementState(world, pos, method_9564());
    }

    public class_2680 getPlacementState(class_1937 world, class_2338 pos, class_2680 state) {
        if (state == null || !state.method_27852(this)) {
            return state;
        }
        return state.method_11657(TWO_HIGH, world.method_8320(pos.method_10084()).method_26215());
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        state = super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        if (!this.method_9558(state, world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (direction == class_2350.field_11036) {
            return state.method_11657(TWO_HIGH, neighborState.method_26215());
        }
        return state;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_27852(BwtBlocks.hibachiBlock);
    }

    @Override
    protected boolean method_10195(class_2680 state) {
        return FlammableBlockRegistry.getDefaultInstance().get(state.method_26204()).getBurnChance() > 0;
    }


    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.method_8450().method_8355(class_1928.field_19387)) {
            return;
        }
        if (!state.method_26184(world, pos)) {
            world.method_8650(pos, false);
        }
        class_2680 blockAboveState = world.method_8320(pos.method_10084());
        if (blockAboveState.method_27852(class_2246.field_10104)) {
            world.method_8501(pos.method_10084(), BwtBlocks.kilnBlock.method_9564());
        }

        int oldAge = state.method_11654(AGE);

        // If aging out, replace with regular fire
        if (oldAge >= 2) {
            world.method_8501(pos, class_2358.method_24416(world, pos));
            return;
        }

        int age = Math.min(2, oldAge + 1);
        world.method_8652(pos, state.method_11657(AGE, age), class_2248.field_31036);

        boolean extraBurn = world.method_23753(pos).method_40220(class_6908.field_41752);
        int k = extraBurn ? -50 : 0;
        this.trySpreadingFire(world, pos.method_10078(), 300 + k, random, age);
        this.trySpreadingFire(world, pos.method_10067(), 300 + k, random, age);
        this.trySpreadingFire(world, pos.method_10074(), 250 + k, random, age);
        this.trySpreadingFire(world, pos.method_10084(), 250 + k, random, age);
        this.trySpreadingFire(world, pos.method_10095(), 300 + k, random, age);
        this.trySpreadingFire(world, pos.method_10072(), 300 + k, random, age);

        world.method_39279(pos, this, tickRate + random.method_43048(10));
    }

    private int getSpreadChance(class_2680 state) {
        if (state.method_28498(class_2741.field_12508) && state.method_11654(class_2741.field_12508)) {
            return 0;
        }
        return FlammableBlockRegistry.getInstance(class_2246.field_10036).get(state.method_26204()).getSpreadChance();
    }

    private void trySpreadingFire(class_1937 world, class_2338 pos, int spreadFactor, class_5819 random, int currentAge) {
        int i = this.getSpreadChance(world.method_8320(pos));
        if (random.method_43048(spreadFactor) < i) {
            class_2680 blockState = world.method_8320(pos);
            if (random.method_43048(currentAge + 10) < 5 && !world.method_8520(pos)) {
                int j = Math.min(currentAge + random.method_43048(5) / 4, 15);
                world.method_8652(pos, this.getStateWithAge(j), class_2248.field_31036);
            } else {
                world.method_8650(pos, false);
            }
            class_2248 block = blockState.method_26204();
            if (block instanceof class_2530) {
                class_2530.method_10738(world, pos);
            }
            if (block instanceof ICaughtFireBlock caught) {
                caught.onCaughtFire(blockState, world, pos, null, null);
            }
        }
    }

    private class_2680 getStateWithAge(int age) {
        class_2680 blockState = method_9564();
        if (blockState.method_27852(BwtBlocks.stokedFireBlock)) {
            return blockState.method_11657(AGE, age);
        }
        return blockState;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        world.method_39279(pos, this, tickRate);
    }
}
