package com.bwt.blocks.abstract_cooking_pot;

import com.bwt.items.BwtItems;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipe;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipeType;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.cooking_pots.CookingPotRecipeInput;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.BlockPosAndState;
import com.bwt.utils.FireDataCluster;
import com.bwt.utils.OrderedRecipeMatcher;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractCookingPotBlockEntity extends class_2586 implements ExtendedScreenHandlerFactory<AbstractCookingPotData>, class_1263 {
    protected static final int INVENTORY_SIZE = 27;

    // "Time" is used loosely here, since the rate of change is affected by the amount of fire surrounding the pot
    public static final int timeToCompleteCook = 150 * ( FireDataCluster.primaryFireFactor + ( FireDataCluster.secondaryFireFactor * 8 ) );
    public static final int stackSizeToDrop = 8;
    public int slotsOccupied;

    protected int cookProgressTime;
    protected boolean isStoked;

    public final AbstractCookingPotBlockEntity.Inventory inventory = new AbstractCookingPotBlockEntity.Inventory(INVENTORY_SIZE);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of(inventory, null);


    public AbstractCookingPotRecipeType unstokedRecipeType;
    public AbstractCookingPotRecipeType stokedRecipeType;

    protected final class_3913 propertyDelegate = new class_3913() {
        @Override
        public int method_17390(int index) {
            if (index == 0) {
                return AbstractCookingPotBlockEntity.this.cookProgressTime;
            }
            return 0;
        }

        @Override
        public void method_17391(int index, int value) {
            if (index == 0) {
                AbstractCookingPotBlockEntity.this.cookProgressTime = value;
            }
        }

        @Override
        public int method_17389() {
            return 1;
        }
    };

    public AbstractCookingPotBlockEntity(
            class_2591<? extends AbstractCookingPotBlockEntity> blockEntityType,
            AbstractCookingPotRecipeType unstokedRecipeType,
            AbstractCookingPotRecipeType stokedRecipeType,
            class_2338 pos,
            class_2680 state
    ) {
        super(blockEntityType, pos, state);
        this.unstokedRecipeType = unstokedRecipeType;
        this.stokedRecipeType = stokedRecipeType;
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", class_2520.field_33260), registryLookup);
        this.cookProgressTime = nbt.method_10550("cookProgressTicks");
        this.isStoked = nbt.method_10577("isStoked");
        this.slotsOccupied = nbt.method_10550("slotsOccupied");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", this.inventory.method_7660(registryLookup));
        nbt.method_10569("cookProgressTicks", this.cookProgressTime);
        nbt.method_10556("isStoked", this.isStoked);
        nbt.method_10569("slotsOccupied", this.slotsOccupied);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = method_38244(registryLookup);
        nbtCompound.method_10569("slotsOccupied", slotsOccupied);
        return nbtCompound;
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471(method_11010().method_26204().method_9539());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AbstractCookingPotBlockEntity blockEntity) {
        FireDataCluster fireDataCluster = FireDataCluster.fromWorld(world, pos);
        boolean isStoked = fireDataCluster.isStoked();
        if (isStoked != blockEntity.isStoked) {
            blockEntity.isStoked = isStoked;
            blockEntity.method_5431();
        }
        if (state.method_11654(AbstractCookingPotBlock.TIP_DIRECTION) == class_2350.field_11036) {
            blockEntity.cookItems(world, pos, fireDataCluster);
        }
        else {
            blockEntity.dumpItems(world, pos, state);
        }
    }

    protected void cookItems(class_1937 world, class_2338 pos, FireDataCluster fireDataCluster) {
        if (!fireDataCluster.anyFirePresent()) {
            if (cookProgressTime != 0) {
                cookProgressTime = 0;
                method_5431();
            }
            return;
        }

        if (inventory.method_43256(itemStack -> itemStack.method_31574(BwtItems.dungItem))
                && inventory.method_43256(itemStack -> itemStack.method_57353().method_57829(class_9334.field_50075) != null)) {
            spoilFood();
        }

        if (fireDataCluster.getStokedFactor() > 0) {
            int stokedExplosivesCount = inventory.method_54454().stream()
                    .filter(itemStack -> itemStack.method_31573(BwtItemTags.STOKED_EXPLOSIVES))
                    .map(class_1799::method_7947)
                    .reduce(Integer::sum)
                    .orElse(0);
            if (stokedExplosivesCount > 0) {
                explode(world, pos, stokedExplosivesCount);
                return;
            }
        }

        class_1863 recipeManager = world.method_8433();
        AbstractCookingPotRecipeType recipeTypeToGet = fireDataCluster.isStoked() ? stokedRecipeType : unstokedRecipeType;

        CookingPotRecipeInput recipeInput = new CookingPotRecipeInput(inventory.method_54454());
        List<class_8786<AbstractCookingPotRecipe>> matches = recipeManager.method_17877(recipeTypeToGet, recipeInput, world);
        if (matches.isEmpty()) {
            if (cookProgressTime != 0) {
                cookProgressTime = 0;
                method_5431();
            }
            return;
        }

        cookProgressTime = cookProgressTime + fireDataCluster.getDominantFireTypeFactor();
        if (cookProgressTime >= timeToCompleteCook) {
            cookProgressTime = 0;
            method_5431();
        }
        else {
            return;
        }

        // Cook the first recipe we can
        OrderedRecipeMatcher.getFirstRecipe(matches, inventory.method_54454(), this::cookRecipe);
    }

    private void dumpItems(class_1937 world, class_2338 pos, class_2680 state) {
        Optional<class_1799> firstItemToDump = inventory.method_54454().stream()
                .filter(itemStack -> !itemStack.method_7960())
                .findFirst();
        if (firstItemToDump.isEmpty()) {
            return;
        }

        class_1799 itemStack = firstItemToDump.get();

        if (itemStack.method_7960()) {
            return;
        }

        class_2350 facing = state.method_11654(AbstractCookingPotBlock.TIP_DIRECTION);
        BlockPosAndState dumpPosAndState = BlockPosAndState.of(world, pos.method_10093(facing));
        if (!dumpPosAndState.state().method_45474() && !dumpPosAndState.state().method_26220(world, dumpPosAndState.pos()).method_1110()) {
            return;
        }
        ejectStack(world, itemStack, facing, dumpPosAndState);
    }

    private void ejectStack(class_1937 world, class_1799 itemStack, class_2350 facing, BlockPosAndState dumpPosAndState) {
        int stackSizeToDump = Math.min(itemStack.method_7947(), stackSizeToDrop);

        class_243 entityPos = dumpPosAndState.pos().method_46558().method_1023(0, 0.25f, 0);
        class_1542 itemEntity = new class_1542(world, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, itemStack.method_46651(stackSizeToDump));
        class_243 itemVelocity = class_243.method_24954(facing.method_10163()).method_1021(0.1);
        itemEntity.method_18799(itemVelocity);
        itemEntity.method_6982(10);

        itemStack.method_7934(stackSizeToDump);
        method_5431();
        world.method_8649(itemEntity);
    }

    private static void explode(class_1937 world, class_2338 pos, int stokedExplosivesCount) {
        world.method_22352(pos, true);
        float explosionStrength = Math.min(Math.max(stokedExplosivesCount / 6.4f, 2f), 10f);
        world.method_8537(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), explosionStrength, true, class_1937.class_7867.field_40889);
    }

    @Override
    public int method_5439() {
        return inventory.method_5439();
    }

    @Override
    public boolean method_5442() {
        return inventory.method_5442();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return inventory.method_5438(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return inventory.method_5434(slot, amount);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return inventory.method_5441(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        inventory.method_5447(slot, stack);
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return inventory.method_5443(player);
    }

    @Override
    public void method_5448() {
        inventory.method_5448();
    }

    public class Inventory extends class_1277 {
        public Inventory(int size) {
            super(size);
        }
        @Override
        public void method_5431() {
            AbstractCookingPotBlockEntity.this.method_5431();
        }
    }

    public boolean cookRecipe(AbstractCookingPotRecipe recipe) {
        try (Transaction transaction = Transaction.openOuter()) {
            List<class_1799> remaindersAndResults = new ArrayList<>(recipe.getResults());
            // Spend ingredients
            for (IngredientWithCount ingredientWithCount : recipe.getIngredientsWithCount()) {
                long countToSpend = ingredientWithCount.count();
                while (countToSpend > 0) {
                    ItemVariant itemVariant = StorageUtil.findStoredResource(inventoryWrapper, ingredientWithCount::test);
                    if (itemVariant == null) {
                        continue;
                    }
                    if (itemVariant.getItem().method_7857()) {
                        class_1792 remainder = itemVariant.getItem().method_7858();
                        if (remainder != null) {
                            remaindersAndResults.add(new class_1799(remainder, (int) countToSpend));
                        }
                    }
                    long taken = inventoryWrapper.extract(itemVariant, countToSpend, transaction);
                    countToSpend -= taken;
                    if (taken == 0) {
                        transaction.abort();
                        return false;
                    }
                }
            }
            // Add results
            for (class_1799 result : remaindersAndResults) {
                long inserted = StorageUtil.insertStacking(inventoryWrapper.getSlots(), ItemVariant.of(result), result.method_7947(), transaction);
                if (inserted < result.method_7947()) {
                    transaction.abort();
                    return false;
                }
            }
            transaction.commit();
            return true;
        }
    }

    public void spoilFood() {
        try (Transaction transaction = Transaction.openOuter()) {
            for (SingleSlotStorage<ItemVariant> slot : inventoryWrapper.getSlots()) {
                ItemVariant resource = slot.getResource();
                if (resource.toStack().method_57353().method_57829(class_9334.field_50075) == null) {
                    continue;
                }
                long count = slot.extract(resource, resource.getItem().method_7882(), transaction);
                slot.insert(ItemVariant.of(BwtItems.foulFoodItem), count, transaction);
            }
            transaction.commit();
        }
    }

    // Pick up items from above like a hopper
    public static void onEntityCollided(class_1297 entity, AbstractCookingPotBlockEntity blockEntity) {
        class_1799 itemStack;
        if (entity instanceof class_1542 itemEntity && !(itemStack = itemEntity.method_6983()).method_7960()) {
            int count = itemStack.method_7947();
            try (Transaction transaction = Transaction.openOuter()) {
                long inserted = StorageUtil.insertStacking(blockEntity.inventoryWrapper.getSlots(), ItemVariant.of(itemStack), count, transaction);
                itemEntity.method_6979(itemEntity.method_6983().method_46651((int) (count - inserted)));
                transaction.commit();
                blockEntity.inventory.method_5431();
            }
        }
    }

    // Update fill level texture
    @Override
    public void method_5431() {
        slotsOccupied = ((int) inventory.field_5828.stream().filter(stack -> !stack.method_7960()).count());
        if (field_11863 != null) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31036);
        }
        super.method_5431();
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public AbstractCookingPotData getScreenOpeningData(class_3222 player) {
        return new AbstractCookingPotData(this.isStoked);
    }
}
