package com.bwt.blocks.abstract_cooking_pot;

import com.bwt.BetterWithTime;
import com.bwt.blocks.cauldron.CauldronBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3917;

public abstract class AbstractCookingPotScreenHandler extends class_1703 {
    public static final int SIZE = 27;
    protected final class_1263 inventory;
    protected final class_3913 propertyDelegate;

    protected boolean isStoked;

    public AbstractCookingPotScreenHandler(
            class_3917<? extends AbstractCookingPotScreenHandler> screenHandlerType,
            int syncId,
            class_1661 playerInventory,
            class_1263 inventory,
            class_3913 propertyDelegate,
            AbstractCookingPotData cookingPotData
    ) {
        super(screenHandlerType, syncId);
        method_17359(inventory, SIZE);
        this.inventory = inventory;
        this.propertyDelegate = propertyDelegate;
        inventory.method_5435(playerInventory.field_7546);
        this.method_17360(propertyDelegate);
        this.isStoked = cookingPotData.isStoked();

        int m;
        int l;
        // Cooking pot inventory
        for (m = 0; m < 3; ++m) {
            for (l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(inventory, l + m * 9, 8 + l * 18, 43 + m * 18));
            }
        }
        // Player inventory
        for (m = 0; m < 3; ++m) {
            for (l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(playerInventory, l + m * 9 + 9, 8 + l * 18, 111 + m * 18));
            }
        }
        // Player hotbar
        for (m = 0; m < 9; ++m) {
            this.method_7621(new class_1735(playerInventory, m, 8 + m * 18, 169));
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = this.field_7761.get(slot);
        if (slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (slot < SIZE ? !this.method_7616(itemStack2, SIZE, 36 + SIZE, true) : !this.method_7616(itemStack2, 0, SIZE, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    public float getCookProgress() {
        int cookProgress = this.propertyDelegate.method_17390(0);
        int timeToCompleteCook = AbstractCookingPotBlockEntity.timeToCompleteCook;
        return class_3532.method_15363((float)cookProgress / (float)timeToCompleteCook, 0.0f, 1.0f);
    }

    public boolean isStoked() {
        return this.isStoked;
    }
}
