package com.bwt.blocks.block_dispenser;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.block_entities.ImplementedInventory;
import org.jetbrains.annotations.Nullable;

import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;

public class BlockDispenserBlockEntity extends class_2601 implements class_3908, ImplementedInventory, class_1278 {
    public static final int field_31340 = 16;
    private static final int[] AVAILABLE_SLOTS = IntStream.range(0, field_31340).toArray();
    private int selectedSlot;

    public BlockDispenserBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.blockDispenserBlockEntity, pos, state);
        method_11281(class_2371.method_10213(field_31340, class_1799.field_8037));
        selectedSlot = 0;
    }

    public int getSelectedSlot() {
        return selectedSlot;
    }

    public void setSelectedSlot(int slotToSelect) {
        this.selectedSlot = Math.max(slotToSelect, 0) % field_31340;
        this.method_5431();
    }

    private final class_3913 propertyDelegate = new class_3913() {
        @Override
        public int method_17390(int index) {
            return selectedSlot;
        }

        @Override
        public void method_17391(int index, int value) {
            selectedSlot = value;
        }

        @Override
        public int method_17389() {
            return 1;
        }
    };

    @Override
    public class_2371<class_1799> getItems() {
        return method_11282();
    }

    @Override
    public int method_5439() {
        return field_31340;
    }

    protected int findNextValidSlotIndex() {
        int invSize = method_11282().size();
        // Wrap around inventory, including a return to the selected slot
        for (int currentSlot = selectedSlot + 1; currentSlot <= invSize + selectedSlot; currentSlot++ )
        {
            if (!method_11282().get(currentSlot % invSize).method_7960())
            {
                return currentSlot % invSize;
            }
        }

        return 0;
    }

    public void advanceSelectedSlot() {
        setSelectedSlot(findNextValidSlotIndex());
    }

    public class_1799 getCurrentItemToDispense() {
        class_1799 itemStack = method_11282().get(selectedSlot);

        if (!itemStack.method_7960()) {
            return itemStack;
        }

        int newSlot = findNextValidSlotIndex();
        setSelectedSlot(newSlot);

        return method_11282().get(newSlot);
    }

    public boolean hasRoomFor(class_1799 stack) {
        int count = stack.method_7947();
        for (class_1799 invStack : method_11282()) {
            if (invStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577(invStack, stack)) {
                continue;
            }
            count -= (invStack.method_7914() - invStack.method_7947());
            if (count <= 0) {
                return true;
            }
        }
        return false;
    }

    public class_1799 insert(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }

        int invSize = method_11282().size();
        for (int currentSlot = 0; currentSlot < invSize; currentSlot++ )
        {
            class_1799 invStack = method_11282().get(currentSlot);
            if (class_1799.method_31577(invStack, stack)) {
                int space = invStack.method_7914() - invStack.method_7947();
                int inserted = Math.min(space, stack.method_7947());
                invStack.method_7933(inserted);
                method_5447(currentSlot, invStack);
                stack.method_7934(inserted);
            }
            if (stack.method_7947() <= 0) {
                return stack;
            }
        }
        if (stack.method_7947() <= 0) {
            return stack;
        }
        for (int currentSlot = 0; currentSlot < invSize; currentSlot++ ) {
            class_1799 invStack = method_11282().get(currentSlot);
            if (invStack.method_7960()) {
                invStack = stack.method_51164();
                method_5447(currentSlot, invStack);
            }
            if (stack.method_7947() <= 0) {
                return stack;
            }
        }
        return stack;
    }

    public class_1799 take(class_1792 item, int count) {
        if (item == class_1802.field_8162 || count == 0) {
            return class_1799.field_8037;
        }

        int invSize = method_11282().size();
        for (int currentSlot = selectedSlot; currentSlot < invSize + selectedSlot; currentSlot++ )
        {
            class_1799 invStack = method_11282().get(currentSlot % invSize);
            if (invStack.method_7960()) {
                continue;
            }
            else if (invStack.method_31574(item)) {
                int available = invStack.method_7947();
                int removed = Math.min(count, available);
                invStack.method_7934(removed);
                method_5447(currentSlot % invSize, invStack);
                count -= removed;
            }
            if (count <= 0) {
                return new class_1799(item, count);
            }
        }
        return new class_1799(item, count);
    }

    //These Methods are from the NamedScreenHandlerFactory Interface
    //createMenu creates the ScreenHandler itself
    //getDisplayName will Provide its name which is normally shown at the top

    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        //We provide *this* to the screenHandler as our class Implements Inventory
        //Only the Server has the Inventory at the start, this will be synced to the client in the ScreenHandler
        return new BlockDispenserScreenHandler(syncId, playerInventory, this, propertyDelegate);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471(method_11010().method_26204().method_9539());
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        class_1262.method_5429(nbt, this.method_11282(), lookup);
        this.selectedSlot = nbt.method_10550("nextSlotToDispense");
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        class_1262.method_5426(nbt, this.method_11282(), lookup);
        nbt.method_10569("nextSlotToDispense", selectedSlot);
    }

    // SidedInventory, to disable extraction

    @Override
    public int[] method_5494(class_2350 side) {
        return AVAILABLE_SLOTS;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }
}



