package com.bwt.blocks.block_dispenser.behavior.inhale;

import com.bwt.blocks.block_dispenser.BlockDispenserBlock;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;

public class DoubleTallBlockInhaleBehavior implements BlockInhaleBehavior {
    @Override
    public class_1799 getInhaledItems(class_2342 blockPointer) {
        class_3218 world = blockPointer.comp_1967();
        class_2338 pos = blockPointer.comp_1968();
        class_2680 state = blockPointer.comp_1969();
        class_2338 firstHalfPos = blockPointer.comp_1968().method_10093(state.method_11654(BlockDispenserBlock.field_10918));
        class_2680 firstHalfState = world.method_8320(firstHalfPos);
        class_2601 dispenserBlockEntity = blockPointer.comp_1970();

        if (!(firstHalfState.method_28498(class_2741.field_12533))) {
            return class_1799.field_8037;
        }
        ArrayList<class_1799> drops = new ArrayList<>(2);
        drops.add(BlockInhaleBehavior.DEFAULT.getInhaledItems(blockPointer));
        class_2350 otherHalfDirection = firstHalfState.method_11654(class_2741.field_12533).method_54779();
        class_2680 otherHalfState = world.method_8320(firstHalfPos.method_10093(otherHalfDirection));
        if (otherHalfState.method_27852(firstHalfState.method_26204())) {
            drops.add(BlockInhaleBehavior.DEFAULT.getInhaledItems(new class_2342(world, pos.method_10093(otherHalfDirection), state, dispenserBlockEntity)));
        }
        return drops.stream().filter(drop -> !drop.method_7960()).findFirst().orElse(class_1799.field_8037);
    }

    @Override
    public void inhale(class_2342 blockPointer) {
        class_3218 world = blockPointer.comp_1967();
        class_2338 firstHalfPos = blockPointer.comp_1968().method_10093(blockPointer.comp_1969().method_11654(BlockDispenserBlock.field_10918));
        class_2680 firstHalfState = world.method_8320(firstHalfPos);
        class_2350 otherHalfDirection = firstHalfState.method_11654(class_2741.field_12533).method_54779();
        class_2338 otherHalfPos = firstHalfPos.method_10093(otherHalfDirection);
        class_2680 otherHalfState = world.method_8320(otherHalfPos);

        ArrayList<class_2338> halfPositions = new ArrayList<>();
        halfPositions.add(firstHalfPos);
        if (otherHalfState.method_27852(firstHalfState.method_26204())) {
            halfPositions.add(otherHalfPos);
        }
        halfPositions.stream().sorted(Comparator.comparingInt(class_2382::method_10264)).forEach(pos -> breakBlockNoItems(world, pos));
    }
}
