package com.bwt.blocks.lens;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_5819;
import java.util.Map;
import java.util.stream.Stream;

public class LensBeamBlock extends class_2248 {
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 TERMINUS = class_2746.method_11825("terminus");
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = ImmutableMap.copyOf(class_156.method_654(Maps.newEnumMap(class_2350.class), directions -> {
        directions.put(class_2350.field_11043, NORTH);
        directions.put(class_2350.field_11034, EAST);
        directions.put(class_2350.field_11035, SOUTH);
        directions.put(class_2350.field_11039, WEST);
        directions.put(class_2350.field_11036, UP);
        directions.put(class_2350.field_11033, DOWN);
    }));

    public LensBeamBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564()
                .method_11657(UP, false)
                .method_11657(DOWN, false)
                .method_11657(NORTH, false)
                .method_11657(SOUTH, false)
                .method_11657(EAST, false)
                .method_11657(WEST, false)
                .method_11657(TERMINUS, false)
        );
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(UP, DOWN, NORTH, EAST, SOUTH, WEST, TERMINUS);
    }

    @Override
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        // Kill beams in all directions that were on before
        Stream<Map.Entry<class_2350, class_2746>> stream = LensBeamHelper.streamFacingDirections(state);

        if (newState.method_27852(this)) {
            stream = stream.filter(entry -> !newState.method_11654(entry.getValue()));
        }
        stream.forEachOrdered(entry -> LensBeamHelper.killBeam(world, pos, entry.getKey()));
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        // If any neighbor the beam is facing into is solid, it's a terminus
        return state.method_11657(TERMINUS, LensBeamHelper.anyNeighborNotPropagable(world, pos, state));
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        class_2382 vec = sourcePos.method_10059(pos);
        class_2350 direction = class_2350.method_50026(vec.method_10263(), vec.method_10264(), vec.method_10260());
        if (direction == null) {
            return;
        }
        if (!state.method_11654(FACING_PROPERTIES.get(direction))) {
            return;
        }
        int range = LensBeamHelper.getRemainingRange(world, pos, direction);
        if (range > 0 && !LensBeamHelper.anyEntitiesIntersecting(world, pos)) {
            LensBeamHelper.propagateBeam(world, pos, state, direction, range);
        }
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        class_2680 finalState = LensBeamHelper.setTerminus(world, pos, state, true);
        LensBeamHelper.streamFacingDirections(finalState)
                .forEach(entry -> LensBeamHelper.killBeam(world, pos, entry.getKey()));
        // Need to keep checking for the entity leaving
        world.method_39279(pos, this, 1);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean entityIntersect = LensBeamHelper.anyEntitiesIntersecting(world, pos);
        if (entityIntersect) {
            class_2680 finalState = LensBeamHelper.setTerminus(world, pos, state, true);
            LensBeamHelper.streamFacingDirections(finalState)
                    .forEach(entry -> LensBeamHelper.killBeam(world, pos, entry.getKey()));
            // Need to keep checking for the entity leaving
            world.method_39279(pos, this, 10);
        }
        else {
            class_2680 finalState = LensBeamHelper.setTerminus(world, pos, state, false);
            LensBeamHelper.streamFacingDirections(finalState)
                    .forEach(entry -> {
                        int range = LensBeamHelper.getRemainingRange(world, pos, entry.getKey());
                        LensBeamHelper.propagateBeam(world, pos, finalState, entry.getKey(), range);
                    });
        }
    }

    public class_2680 getStateLeftOverWhenEmpty(class_1936 world, class_2338 pos) {
        return world.method_8316(pos).method_15759();
    }
}
