package com.bwt.blocks.mech_hopper;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.MechPowerBlockBase;
import com.bwt.tags.BwtItemTags;
import com.google.common.collect.Maps;
import com.mojang.datafixers.types.templates.Tag;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MechHopperBlock extends class_2237 implements MechPowerBlockBase {
    public static final MapCodec<MechHopperBlock> field_46280 = MechHopperBlock.method_54094(MechHopperBlock::new);

    protected static final class_265 OUTLINE_SHAPE = class_259.method_1084(
//            Block.createCuboidShape(0, 4, 0, 16, 16, 2),
//            Block.createCuboidShape(0, 4, 0, 2, 16, 16),
//            Block.createCuboidShape(0, 4, 14, 16, 16, 16),
//            Block.createCuboidShape(14, 4, 0, 16, 16, 16),
            class_2248.method_9541(0, 4, 0, 16, 16, 16),
            class_2248.method_9541(5, 0, 5, 11, 4, 11)
    );

    public static final Map<class_1792, Predicate<class_1799>> filterMap = Maps.newLinkedHashMap();

    public MechHopperBlock(class_2251 settings) {
        super(settings);
    }

    public static void addFilter(class_1792 item, Predicate<class_1799> predicate) {
        filterMap.put(item, predicate);
    }

    public record TagFilter(class_6862<class_1792> tagKey) implements Predicate<class_1799> {

        @Override
        public boolean test(class_1799 itemStack) {
            return itemStack.method_31573(this.tagKey);
        }
    }

    public static void addDefaultFilters() {
        addFilter(class_1802.field_8121, new TagFilter(BwtItemTags.PASSES_LADDER_FILTER));
        addFilter(class_1802.field_8076, new TagFilter(BwtItemTags.PASSES_IRON_BARS_FILTER));
        for (class_1792 trapdoor : new class_1792[]{
                class_1802.field_8190,
                class_1802.field_40226,
                class_1802.field_8774,
                class_1802.field_42702,
                class_1802.field_46991,
                class_1802.field_22002,
                class_1802.field_8844,
                class_1802.field_46992,
                class_1802.field_8241,
                class_1802.field_8321,
                class_1802.field_37529,
                class_1802.field_8376,
                class_1802.field_46994,
                class_1802.field_8495,
                class_1802.field_22003,
                class_1802.field_46995,
                class_1802.field_46996,
                class_1802.field_46998,
                class_1802.field_46997,
                class_1802.field_46993,
        }) {
            addFilter(trapdoor, new TagFilter(BwtItemTags.PASSES_TRAPDOOR_FILTER));
        }

        addFilter(class_1802.field_8067, itemStack -> false);
        addFilter(BwtBlocks.grateBlock.method_8389(), new TagFilter(BwtItemTags.PASSES_GRATE_FILTER));
        addFilter(BwtBlocks.slatsBlock.method_8389(), new TagFilter(BwtItemTags.PASSES_SLATS_FILTER));
        addFilter(BwtBlocks.wickerPaneBlock.method_8389(), new TagFilter(BwtItemTags.PASSES_WICKER_FILTER));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        MechPowerBlockBase.super.appendProperties(builder);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(MECH_POWERED, false);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MechHopperBlockEntity(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPE;
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        boolean isMechPowered = isReceivingMechPower(world, state, pos);
        // If block just turned on
        if (isMechPowered && !isMechPowered(state)) {
            world.method_39279(pos, this, MechPowerBlockBase.getTurnOnTickRate());
        }
        // If block just turned off
        else if (!isMechPowered && isMechPowered(state)) {
            world.method_39279(pos, this, MechPowerBlockBase.getTurnOffTickRate());
        }
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        schedulePowerUpdate(state, world, pos);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291(state, newState, world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        schedulePowerUpdate(state, world, pos);
    }

    public class_2680 getPowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11657(MECH_POWERED, isReceivingMechPower(world, state, pos));
    }

    public void updatePowerTransfer(class_1937 world, class_2680 blockState, class_2338 pos) {
        class_2680 updatedState = getPowerStates(blockState, world, pos);
        world.method_8501(pos, updatedState);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MechHopperBlockEntity hopperBlockEntity) {
            hopperBlockEntity.mechPower = updatedState.method_11654(MechHopperBlock.MECH_POWERED) ? 1 : 0;
        }
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updatePowerTransfer(world, state, pos);
    }

    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (world.field_9236) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MechHopperBlockEntity hopperBlockEntity) {
            MechHopperBlockEntity.onEntityCollided(world, entity, hopperBlockEntity);
        }
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MechHopperBlockEntity hopperBlockEntity) {
            player.method_17355(hopperBlockEntity);
        }
        return class_1269.field_21466;
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> !direction.method_10166().method_10178();
    }

    @Nullable
    protected static <A extends class_2586> class_5558<A> validateTicker(class_1937 world, class_2591<A> givenType) {
        return world.field_9236 ? null : class_2237.method_31618(givenType, BwtBlockEntities.mechHopperBlockEntity, MechHopperBlockEntity::tick);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MechHopperBlock.validateTicker(world, type);
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608(world.method_8321(pos));
    }
}
