package com.bwt.blocks.mech_hopper;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.mixin.VanillaHopperInvoker;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.hopper_filter.HopperFilterRecipe;
import com.bwt.recipes.hopper_filter.HopperFilterRecipeInput;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipe;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.SimpleSingleStackInventory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1267;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;

public class MechHopperBlockEntity extends class_2586 implements class_3908, class_1263 {
    public static final int INVENTORY_SIZE = 19;
    protected static final int STACK_SIZE_TO_EJECT = 8;
    protected static final int SOUL_STORAGE_LIMIT = 8;
    protected static final int PICKUP_COOLDOWN = 3;
    protected static final int ITEM_DROP_COOLDOWN = 3;


    protected int mechPower;
    protected int soulCount;
    protected int xpCount;
    protected int itemPickupCooldown;
    protected int itemDropCooldown;
    protected int xpPickupCooldown;
    protected int xpDropCooldown;
    public int slotsOccupied;
    protected boolean outputBlocked;


    public final FilterInventory filterInventory = new FilterInventory();
    public final HopperInventory hopperInventory = new HopperInventory(INVENTORY_SIZE - 1);
    public final CombinedStorage<ItemVariant, InventoryStorage> inventoryWrapper = new CombinedStorage<>(
            List.of(
                    InventoryStorage.of(filterInventory, null),
                    InventoryStorage.of(hopperInventory, null)
            )
    );

    protected final class_3913 propertyDelegate = new class_3913() {
        @Override
        public int method_17390(int index) {
            return switch (index) {
                case 0 -> MechHopperBlockEntity.this.mechPower;
                default -> 0;
            };
        }

        @Override
        public void method_17391(int index, int value) {
            switch (index) {
                case 0 -> MechHopperBlockEntity.this.mechPower = value > 0 ? 1 : 0;
                default -> {}
            }
        }

        @Override
        public int method_17389() {
            return 1;
        }
    };

    public MechHopperBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.mechHopperBlockEntity, pos, state);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.filterInventory.readNbt(nbt.method_10562("Filter"), registryLookup);
        this.hopperInventory.method_7659(nbt.method_10554("Inventory", class_2520.field_33260), registryLookup);
        this.mechPower = nbt.method_10550("mechPower");
        this.soulCount = nbt.method_10550("soulCount");
        this.xpCount = nbt.method_10550("xpCount");
        this.itemPickupCooldown = nbt.method_10550("itemPickupCooldown");
        this.itemDropCooldown = nbt.method_10550("itemDropCooldown");
        this.xpPickupCooldown = nbt.method_10550("xpPickupCooldown");
        this.xpDropCooldown = nbt.method_10550("xpDropCooldown");
        this.slotsOccupied = nbt.method_10550("slotsOccupied");
        this.outputBlocked = nbt.method_10577("outputBlocked");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Filter", this.filterInventory.toNbt(registryLookup));
        nbt.method_10566("Inventory", this.hopperInventory.method_7660(registryLookup));
        nbt.method_10569("mechPower", this.mechPower);
        nbt.method_10569("soulCount", this.soulCount);
        nbt.method_10569("xpCount", this.xpCount);
        nbt.method_10569("itemPickupCooldown", this.itemPickupCooldown);
        nbt.method_10569("itemDropCooldown", this.itemDropCooldown);
        nbt.method_10569("xpPickupCooldown", this.xpPickupCooldown);
        nbt.method_10569("xpDropCooldown", this.xpDropCooldown);
        nbt.method_10569("slotsOccupied", this.slotsOccupied);
        nbt.method_10556("outputBlocked", this.outputBlocked);
    }

    @Override
    public void method_5431() {
        int oldSlotsOccupied = slotsOccupied;
        slotsOccupied = ((int) hopperInventory.field_5828.stream().filter(stack -> !stack.method_7960()).count());
        int size = hopperInventory.method_5439();
        if (field_11863 != null) {
            field_11863.method_8413(field_11867, method_11010(), method_11010(), class_2248.field_31036);
            if ((oldSlotsOccupied == size && slotsOccupied != size) || (slotsOccupied == size && oldSlotsOccupied != size)) {
                field_11863.method_8408(field_11867, method_11010().method_26204());
            }
        }
        super.method_5431();
    }

    public class_1792 getFilterItem() {
        return filterInventory.method_54079().method_7909();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, MechHopperBlockEntity blockEntity) {
        if (world.field_9236 || !state.method_27852(BwtBlocks.hopperBlock)) {
            return;
        }

        if (blockEntity.itemPickupCooldown > 0) {
            blockEntity.itemPickupCooldown = (blockEntity.itemPickupCooldown + 1) % PICKUP_COOLDOWN;
        }

        if (blockEntity.mechPower > 0)
        {
//            attemptToEjectXP();

            if (!blockEntity.outputBlocked) {
                // the hopper is powered, eject items
                blockEntity.itemDropCooldown += 1;

                if (blockEntity.itemDropCooldown >= MechHopperBlockEntity.ITEM_DROP_COOLDOWN) {
                    blockEntity.attemptToEjectStack(world, pos);
                    blockEntity.itemDropCooldown = 0;
                }
            }
            else {
                blockEntity.itemDropCooldown = 0;
            }
        }
        else {
            blockEntity.itemDropCooldown = 0;
            blockEntity.xpDropCooldown = 0;
        }

        if (blockEntity.soulCount > 0) {
            // souls can only be trapped if there's a soul sand filter on the hopper
            if (blockEntity.getFilterItem().equals(class_1802.field_8067)) {
                bottleSouls(world, blockEntity);
            }
            else {
                blockEntity.soulCount = 0;
            }
        }
    }

    protected static void bottleSouls(class_1937 world, MechHopperBlockEntity blockEntity) {
        class_2680 blockBelowState = world.method_8320(blockEntity.method_11016().method_10074());

        SoulBottlingRecipeInput recipeInput = new SoulBottlingRecipeInput(blockBelowState.method_26204());
        Optional<SoulBottlingRecipe> optionalRecipe = world.method_8433().method_8132(
                BwtRecipes.SOUL_BOTTLING_RECIPE_TYPE,
                recipeInput,
                world
        ).map(class_8786::comp_1933);

        // If unpowered, we just need to check for explosions
        // Otherwise, nothing happens while unpowered
        if (blockEntity.mechPower <= 0) {
            if (blockEntity.soulCount >= SOUL_STORAGE_LIMIT) {
                soulOverloadExplode(world, blockEntity);
            }
            return;
        }

        // If no bottle is found, souls dissipate
        if (optionalRecipe.isEmpty()) {
            blockEntity.soulCount = 0;
            return;
        }

        SoulBottlingRecipe recipe = optionalRecipe.get();

        // Not enough souls to fill bottle yet
        if (blockEntity.soulCount < recipe.soulCount()) {
            return;
        }

        // Powered + enough souls + bottle found? Convert
        world.method_8650(blockEntity.method_11016().method_10074(), false);
        class_1264.method_5449(world, blockEntity.method_11016().method_10263(), blockEntity.method_11016().method_10264() - 1, blockEntity.method_11016().method_10260(), recipe.getResult());

        // the rest of the souls escape (if any remain)
        blockEntity.soulCount = 0;
    }

    protected static void soulOverloadExplode(class_1937 world, MechHopperBlockEntity blockEntity) {
        world.method_22352(blockEntity.method_11016(), false);
        class_1264.method_5451(world, blockEntity.method_11016(), blockEntity.hopperInventory);
        world.method_45447(null, blockEntity.method_11016(), class_3417.field_15152.comp_349(), class_3419.field_15245);
        if (!world.method_8407().equals(class_1267.field_5801)) {
            class_1571 ghastEntity = new class_1571(class_1299.field_6107, world);
            ghastEntity.method_33574(blockEntity.method_11016().method_46558());
            world.method_8649(ghastEntity);
        }
    }

    public void attemptToEjectStack(class_1937 world, class_2338 pos) {
        List<Integer> occupiedIndices = IntStream.range(0, hopperInventory.method_5439())
                .filter(i -> !method_5438(i).method_7960())
                .boxed().toList();

        if (occupiedIndices.isEmpty()) {
            return;
        }

        int stackIndex = occupiedIndices.get(world.field_9229.method_39332(0, occupiedIndices.size() - 1));

        class_1799 invStack = method_5438(stackIndex);

        int stackCountToDrop = Math.min(MechHopperBlockEntity.STACK_SIZE_TO_EJECT, invStack.method_7947());

        class_2338 belowPos = pos.method_10074();
        class_2680 blockBelowState = world.method_8320(belowPos);

        if (blockBelowState.method_26164(class_3481.field_51989) || blockBelowState.method_45474()) {
            class_1799 ejectStack = invStack.method_46651(stackCountToDrop);
            ejectStack(world, method_11016(), ejectStack);
            method_5434(stackIndex, stackCountToDrop);
        }

        class_1263 inventoryBelow = class_2614.method_11250(world, belowPos);
        if (inventoryBelow == null) {
            return;
        }
        if (VanillaHopperInvoker.isInventoryFull(inventoryBelow, class_2350.field_11036)) {
            return;
        }
        stackCountToDrop = Math.min(stackCountToDrop, inventoryBelow.method_5444());
        for (int i = 0; i < hopperInventory.method_5439(); ++i) {
            if (method_5438(i).method_7960()) continue;
            class_1799 itemStack = method_5438(i);
            class_1799 itemStack2 = class_2614.method_11260(this, inventoryBelow, method_5434(i, stackCountToDrop), class_2350.field_11036);
            if (itemStack2.method_7960()) {
                inventoryBelow.method_5431();
                return;
            }

            itemStack.method_7939(itemStack.method_7947() + itemStack2.method_7947());
            if (itemStack.method_7947() == 0) {
                method_5447(i, class_1799.field_8037);
            }
        }
    }

    protected void ejectStack(class_1937 world, class_2338 pos, class_1799 stack) {
        float xOffset = world.field_9229.method_43057() * 0.1F + 0.45F;
        float yOffset = -0.35F;
        float zOffset = world.field_9229.method_43057() * 0.1F + 0.45F;

        class_1542 itemEntity = new class_1542(world, pos.method_10263() + xOffset, pos.method_10264() + yOffset, pos.method_10260() + zOffset, stack);
        itemEntity.method_18800(0.0f, -0.01f, 0.0f);

        itemEntity.method_6982(10);
        world.method_8649(itemEntity);
    }

    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MechHopperScreenHandler(syncId, playerInventory, filterInventory, hopperInventory, propertyDelegate);
    }

    // Pick up items from above
    public static void onEntityCollided(class_1937 world, class_1297 entity, MechHopperBlockEntity blockEntity) {
        if (blockEntity.itemPickupCooldown > 0) {
            return;
        }
        if (entity instanceof class_1542 itemEntity) {
            pickupItemEntity(world, itemEntity, blockEntity);
        }
    }

    protected static void pickupItemEntity(class_1937 world, class_1542 itemEntity, MechHopperBlockEntity blockEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (itemStack.method_7960()) {
            return;
        }
        class_1792 filterItem = blockEntity.getFilterItem();

        HopperFilterRecipeInput recipeInput = new HopperFilterRecipeInput(filterItem, itemStack);
        Optional<HopperFilterRecipe> optionalRecipe = world.method_8433().method_8132(
                BwtRecipes.HOPPER_FILTER_RECIPE_TYPE,
                recipeInput,
                world
        ).map(class_8786::comp_1933);

        if (optionalRecipe.isPresent()) {
            processRecipe(world, itemEntity, blockEntity, optionalRecipe.get(), itemStack);
            return;
        }

        if (!MechHopperBlock.filterMap.getOrDefault(filterItem, s -> true).test(itemStack)) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter()) {
            int count = itemStack.method_7947();
            long inserted = StorageUtil.insertStacking(
                    blockEntity.inventoryWrapper.parts.get(1).getSlots(),
                    ItemVariant.of(itemStack),
                    count,
                    transaction
            );
            itemEntity.method_6979(itemEntity.method_6983().method_46651((int) (count - inserted)));
            blockEntity.itemPickupCooldown++;
            transaction.commit();
            blockEntity.hopperInventory.method_5431();
        }
    }

    private static void processRecipe(class_1937 world, class_1542 itemEntity, MechHopperBlockEntity blockEntity, HopperFilterRecipe recipe, class_1799 itemStack) {
        int inputCount = itemStack.method_7947();

        // Results get inserted into the hopper
        class_1799 resultStack = recipe.result();
        // Byproducts get spawned on top of the hopper
        class_1799 byproductStack = recipe.byproduct();

        // Operations may be limited by space in the hopper's inventory
        int operationsSucceeded;
        if (!resultStack.method_7960()) {
            try (Transaction transaction = Transaction.openOuter()) {
                // If 1 input item converts to multiple output items,
                // operationsSucceeded only counts up the number of input items accepted
                operationsSucceeded = (int) StorageUtil.insertStacking(
                        blockEntity.inventoryWrapper.parts.get(1).getSlots(),
                        ItemVariant.of(resultStack),
                        (long) inputCount * resultStack.method_7947(),
                        transaction
                ) / resultStack.method_7947();
                blockEntity.itemPickupCooldown++;
                transaction.commit();
                blockEntity.hopperInventory.method_5431();
            }
        }
        else {
            // If inventory doesn't need to accept items, we can always process the whole stack
            operationsSucceeded = itemStack.method_7947();
        }
        itemEntity.method_6979(itemStack.method_46651(inputCount - operationsSucceeded));
        if (!byproductStack.method_7960()) {
            int itemCount = operationsSucceeded * byproductStack.method_7947();
            while (itemCount > 0) {
                int spawnCount = Math.min(itemCount, byproductStack.method_7909().method_7882());
                blockEntity.spawnNewItemOnTop(world, itemEntity.method_19538(), new class_1799(byproductStack.method_7909(), spawnCount));
                itemCount -= spawnCount;
            }
        }

        int soulsInserted = operationsSucceeded * recipe.soulCount();
        if (soulsInserted > 0) {
            int newSoulCount = blockEntity.soulCount + soulsInserted;
            if (newSoulCount > SOUL_STORAGE_LIMIT && blockEntity.mechPower <= 0) {
                soulOverloadExplode(world, blockEntity);
                return;
            }
            blockEntity.soulCount = Math.min(newSoulCount, SOUL_STORAGE_LIMIT);
            blockEntity.method_5431();
            // Play ghast noise
            world.method_8396(null, blockEntity.field_11867, BwtSoundEvents.SOUL_CONVERSION, class_3419.field_15245, 1f, 1.5f);
        }
    }

    protected void spawnNewItemOnTop(class_1937 world, class_243 inputPos, class_1799 newItem) {
        class_1264.method_5449(world, inputPos.method_10216(), inputPos.method_10214(), inputPos.method_10215(), newItem);
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = method_38244(registryLookup);
        nbtCompound.method_10569("slotsOccupied", slotsOccupied);
        nbtCompound.method_10566("Filter", this.filterInventory.toNbt(registryLookup));
        return nbtCompound;
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471(method_11010().method_26204().method_9539());
    }

    @Override
    public int method_5439() {
        return INVENTORY_SIZE;
    }

    @Override
    public boolean method_5442() {
        return hopperInventory.method_5442();
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot < INVENTORY_SIZE - 1) {
            return hopperInventory.method_5438(slot);
        }
        if (slot == INVENTORY_SIZE - 1) {
            return filterInventory.method_54079();
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return hopperInventory.method_5434(slot, amount);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return hopperInventory.method_5441(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        hopperInventory.method_5447(slot, stack);
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return hopperInventory.method_5443(player);
    }

    @Override
    public void method_5448() {
        hopperInventory.method_5448();
    }

    public class FilterInventory extends SimpleSingleStackInventory {
        public FilterInventory() {
            super(1);
        }

        @Override
        public void method_5431() {
            MechHopperBlockEntity.this.method_5431();
        }

        @Override
        public class_2586 method_54080() {
            return MechHopperBlockEntity.this;
        }
    }

    public class HopperInventory extends class_1277 {
        public HopperInventory(int size) {
            super(size);
        }
        @Override
        public void method_5431() {
            MechHopperBlockEntity.this.method_5431();
        }


    }
}
