package com.bwt.blocks.mill_stone;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.mill_stone.MillStoneRecipe;
import com.bwt.recipes.mill_stone.MillStoneRecipeInput;
import com.bwt.utils.OrderedRecipeMatcher;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import java.util.List;

public class MillStoneBlockEntity extends class_2586 implements class_3908, class_1263 {
    protected int grindProgressTime;
    public static final int timeToGrind = 200;
    protected static final int INVENTORY_SIZE = 3;

    public final MillStoneBlockEntity.Inventory inventory = new com.bwt.blocks.mill_stone.MillStoneBlockEntity.Inventory(INVENTORY_SIZE);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of(inventory, null);

    protected final class_3913 propertyDelegate = new class_3913() {
        @Override
        public int method_17390(int index) {
            return switch (index) {
                case 0 -> MillStoneBlockEntity.this.grindProgressTime;
                default -> 0;
            };
        }

        @Override
        public void method_17391(int index, int value) {
            switch (index) {
                case 0 -> MillStoneBlockEntity.this.grindProgressTime = value;
                default -> {}
            }
        }

        @Override
        public int method_17389() {
            return 1;
        }
    };

    public MillStoneBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.millStoneBlockEntity, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, MillStoneBlockEntity blockEntity) {
        if (!state.method_27852(BwtBlocks.millStoneBlock) || !state.method_11654(MillStoneBlock.MECH_POWERED)) {
            return;
        }
        MillStoneRecipeInput recipeInput = new MillStoneRecipeInput(blockEntity.inventory.method_54454());
        List<class_8786<MillStoneRecipe>> matches = world.method_8433().method_17877(BwtRecipes.MILL_STONE_RECIPE_TYPE, recipeInput, world);
        if (matches.isEmpty()) {
            if (blockEntity.grindProgressTime != 0) {
                blockEntity.grindProgressTime = 0;
                blockEntity.method_5431();
            }
            return;
        }

        blockEntity.grindProgressTime += 1;
        if (blockEntity.grindProgressTime >= timeToGrind) {
            blockEntity.grindProgressTime = 0;
            blockEntity.method_5431();
        }
        else {
            return;
        }

        // Get the first recipe and grind it
        OrderedRecipeMatcher.getFirstRecipe(matches, blockEntity.inventory.method_54454(), match -> blockEntity.completeRecipe(match, world, pos));
    }

    public boolean completeRecipe(MillStoneRecipe recipe, class_1937 world, class_2338 pos) {
        try (Transaction transaction = Transaction.openOuter()) {
            // Spend ingredients
            for (IngredientWithCount ingredientWithCount : recipe.getIngredientsWithCount()) {
                long countToSpend = ingredientWithCount.count();
                while (countToSpend > 0) {
                    ItemVariant itemVariant = StorageUtil.findStoredResource(inventoryWrapper, ingredientWithCount::test);
                    if (itemVariant == null) {
                        continue;
                    }
                    long taken = inventoryWrapper.extract(itemVariant, countToSpend, transaction);
                    countToSpend -= taken;
                    if (taken == 0) {
                        transaction.abort();
                        return false;
                    }
                }
            }
            // Eject results
            for (class_1799 result : recipe.getResults()) {
                ejectItem(world, result, pos);
            }
            transaction.commit();
            return true;
        }
    }

    public static void ejectItem(class_1937 world, class_1799 stack, class_2338 pos) {
        // Start at the center of the block
        class_243 centerPos = pos.method_46558();
        class_243 horizontalUnitVector = new class_243(1, 0, 1);

        // Pick a random direction
        double angle = Math.toRadians(world.field_9229.method_39332(0, 359));
        // Get distance from the center to the edge of a square, using the angle
        double distToEdge = Math.min(0.5 / Math.abs(Math.cos(angle)), 0.5 / Math.abs(Math.sin(angle)));
        // Apply that distance to get our item spawn position
        class_243 itemPos = horizontalUnitVector
                .method_1024((float) angle)
                .method_1021(distToEdge + 0.01)
                .method_1019(centerPos);
        // Velocity is in the same X/Z direction as position, but with random strength and y offset
        class_243 itemVelocity = horizontalUnitVector
                .method_1024((float) angle)
                .method_1021(world.field_9229.method_43057() * 0.0125D + 0.1F)
                .method_1031(0, world.field_9229.method_43059() * 0.0125D + 0.05F, 0);

        class_1542 itemEntity = new class_1542(world, itemPos.method_10216(), itemPos.method_10214(), itemPos.method_10215(), stack);
        itemEntity.method_18799(itemVelocity);
        world.method_8649(itemEntity);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", class_2520.field_33260), registryLookup);
        this.grindProgressTime = nbt.method_10550("grindProgressTime");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", this.inventory.method_7660(registryLookup));
        nbt.method_10569("grindProgressTime", this.grindProgressTime);
    }

    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        //We provide *this* to the screenHandler as our class Implements Inventory
        //Only the Server has the Inventory at the start, this will be synced to the client in the ScreenHandler
        return new MillStoneScreenHandler(syncId, playerInventory, inventory, propertyDelegate);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471(method_11010().method_26204().method_9539());
    }

    @Override
    public int method_5439() {
        return inventory.method_5439();
    }

    @Override
    public boolean method_5442() {
        return inventory.method_5442();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return inventory.method_5438(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return inventory.method_5434(slot, amount);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return inventory.method_5441(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        inventory.method_5447(slot, stack);
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return inventory.method_5443(player);
    }

    @Override
    public void method_5448() {
        inventory.method_5448();
    }

    public class Inventory extends class_1277 {
        public Inventory(int size) {
            super(size);
        }
        @Override
        public void method_5431() {
            MillStoneBlockEntity.this.method_5431();
        }
    }
}
