package com.bwt.blocks.mining_charge;

import com.bwt.blocks.SidingBlock;
import com.bwt.entities.MiningChargeEntity;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.BlockUtils;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;

public class MiningChargeBlock extends class_2341 implements ICaughtFireBlock {
    protected static final class_238 BOTTOM_SHAPE = new class_238(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);

    protected static final List<class_265> COLLISION_SHAPES = Arrays.stream(class_2350.values())
            .map(direction -> BlockUtils.rotateCuboidFromUp(direction, BOTTOM_SHAPE))
            .toList();
    public static final MapCodec<MiningChargeBlock> field_46280 = SidingBlock.method_54094(MiningChargeBlock::new);

    public MiningChargeBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(field_11177, class_2350.field_11043).method_11657(field_11007, class_2738.field_12471));
        FlammableBlockRegistry.getDefaultInstance().add(
                this, 15, 100
        );
    }

    public MapCodec<? extends MiningChargeBlock> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(field_11177, field_11007);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES.get(getSurfaceOrientation(state).method_10146());
    }

    public class_2680 getDispenserPlacmentState(class_1750 ctx) {
        for (class_2350 direction : ctx.method_7718()) {
            class_2680 blockState;
            if (direction.method_10166() == class_2350.class_2351.field_11052) {
                blockState = this.method_9564()
                        .method_11657(field_11007, direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475)
                        .method_11657(field_11177, ctx.method_8042());
            } else {
                blockState = this.method_9564().method_11657(field_11007, class_2738.field_12471).method_11657(field_11177, direction.method_10153());
            }
            return blockState;
        }

        return null;
    }

    public static boolean isHorizontal(class_2680 state) {
        return state.method_11654(field_11007) == class_2738.field_12471;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (world.method_49803(pos)) {
            world.method_39279(pos, this, 1);
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return state;
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.method_49803(pos)) {
            world.method_39279(pos, this, 1);
        }
        if (world.field_9236 || !world.method_8320(pos).method_27852(this)) {
            return;
        }
        if (method_9558(state, world, pos)) {
            return;
        }
        method_9497(state, world, pos);
        world.method_8650(pos, notify);
    }

    @Override
    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        prime(world, pos, state, null);
        world.method_8650(pos, false);
    }

    @Deprecated
    public void method_55124(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion, BiConsumer<class_1799, class_2338> stackMerger) {
        if (state.method_26164(class_3481.field_51989) || explosion.method_55111() == class_1927.class_4179.field_47331) {
            return;
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), class_2248.field_31036);
        if (world.field_9236) {
            return;
        }
        MiningChargeEntity miningChargeEntity = new MiningChargeEntity(world, pos.method_46558().method_1023(0, 0.5, 0), state, explosion.method_8347());
        miningChargeEntity.setFuse(1);
        world.method_8649(miningChargeEntity);
    }

    private static void prime(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 igniter) {
        if (world.field_9236) {
            return;
        }
        MiningChargeEntity miningChargeEntity = new MiningChargeEntity(world, pos.method_46558().method_1023(0, 0.5, 0), state, igniter);
        world.method_8649(miningChargeEntity);
        world.method_43128(null, miningChargeEntity.method_23317(), miningChargeEntity.method_23318(), miningChargeEntity.method_23321(), BwtSoundEvents.MINING_CHARGE_PRIME, class_3419.field_15245, 1.0f, 1.0f);
        world.method_33596(igniter, class_5712.field_28727, pos);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 itemStack = player.method_5998(player.method_6058());
        if (!itemStack.method_31574(class_1802.field_8884) && !itemStack.method_31574(class_1802.field_8814)) {
            return super.method_55766(state, world, pos, player, hit);
        }
        prime(world, pos, state, player);
        world.method_8652(pos, class_2246.field_10124.method_9564(), class_2248.field_31022);
        class_1792 item = itemStack.method_7909();
        if (!player.method_7337()) {
            if (itemStack.method_31574(class_1802.field_8884)) {
                itemStack.method_7970(1, player, class_1657.method_56079(player.method_6058()));
            } else {
                itemStack.method_7934(1);
            }
        }
        player.method_7259(class_3468.field_15372.method_14956(item));
        return class_1269.method_29236(world.field_9236);
    }

    @Override
    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (!world.field_9236) {
            class_2338 blockPos = hit.method_17777();
            class_1297 entity = projectile.method_24921();
            if (projectile.method_5809() && projectile.method_36971(world, blockPos)) {
                prime(world, blockPos, state, entity instanceof class_1309 ? (class_1309)entity : null);
                world.method_8650(blockPos, false);
            }
        }
    }

    @Override
    public boolean method_9533(class_1927 explosion) {
        return false;
    }

    public static class_2350 getSurfaceOrientation(class_2680 state) {
        return switch (state.method_11654(field_11007)) {
            case field_12471 -> state.method_11654(field_11177);
            case field_12475 -> class_2350.field_11036;
            case field_12473 -> class_2350.field_11033;
        };
    }

    public static class_2680 withSurfaceOrientation(class_2680 state, class_2350 direction) {
        return switch (direction) {
            case field_11036 -> state.method_11657(field_11007, class_2738.field_12475);
            case field_11033 -> state.method_11657(field_11007, class_2738.field_12473);
            case field_11043 -> state.method_11657(field_11007, class_2738.field_12471).method_11657(field_11177, class_2350.field_11035);
            case field_11034 -> state.method_11657(field_11007, class_2738.field_12471).method_11657(field_11177, class_2350.field_11039);
            case field_11035 -> state.method_11657(field_11007, class_2738.field_12471).method_11657(field_11177, class_2350.field_11043);
            case field_11039 -> state.method_11657(field_11007, class_2738.field_12471).method_11657(field_11177, class_2350.field_11034);
        };
    }
    @Override
    public boolean onCaughtFire(class_2680 state, class_1937 world, class_2338 pos, @Nullable class_2350 direction, @Nullable class_1309 igniter) {
        prime(world, pos, state, igniter);
        return true;
    }
}
