package com.bwt.blocks.pulley;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.AnchorBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.RopeBlock;
import com.bwt.entities.MovingRopeEntity;
import com.bwt.items.BwtItems;
import com.bwt.utils.BlockPosAndState;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.block.*;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import java.util.*;
import java.util.function.Predicate;

public class PulleyBlockEntity extends class_2586 implements class_3908, class_1263 {
    protected static final int INVENTORY_SIZE = 4;

    public final PulleyBlockEntity.Inventory inventory = new com.bwt.blocks.pulley.PulleyBlockEntity.Inventory(INVENTORY_SIZE);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of(inventory, null);
    protected int mechPower;

    private MovingRopeEntity rope;
    private UUID ropeId;


    protected final class_3913 propertyDelegate = new class_3913() {
        @Override
        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PulleyBlockEntity.this.mechPower;
                default -> 0;
            };
        }

        @Override
        public void method_17391(int index, int value) {
            switch (index) {
                case 0 -> PulleyBlockEntity.this.mechPower = value > 0 ? 1 : 0;
                default -> {}
            }
        }

        @Override
        public int method_17389() {
            return 1;
        }
    };

    public PulleyBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.pulleyBlockEntity, pos, state);
    }

    public static boolean isMechPowered(class_2680 state) {
        return state.method_11654(PulleyBlock.MECH_POWERED);
    }

    public static boolean isRedstonePowered(class_2680 state) {
        return state.method_11654(PulleyBlock.POWERED);
    }

    public boolean isRaising(class_2680 state) {
        return isMechPowered(state) && !isRedstonePowered(state);
    }

    public boolean isLowering(class_2680 state) {
        return !isMechPowered(state) && !isRedstonePowered(state)
                && inventory.field_5828.stream()
                    .anyMatch(itemStack -> itemStack.method_31574(BwtItems.ropeItem) && itemStack.method_7947() > 0);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PulleyBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        blockEntity.tryNextOperation(world, pos, state);
    }

    private void tryNextOperation(class_1937 world, class_2338 pos, class_2680 state) {
        if (doesRopeEntityExist(world)) {
            return;
        }

        if (canGoDown(world, pos, state, false)) {
            goDown(world, pos);
            return;
        }
        if (canGoUp(world, pos, state)) {
            goUp(world, pos);
        }
    }

    private boolean doesRopeEntityExist(class_1937 world) {
        // Rope is fully present and loaded
        if (rope != null && !rope.method_31481()) {
            return true;
        }
        // Rope needs to be loaded from nbt but hasn't gotten to yet
        if (ropeId == null) {
            return false;
        }
        if (!(world instanceof class_3218 serverWorld)) {
            return true;
        }
        // Try to load the rope
        class_1297 entity = serverWorld.method_14190(ropeId);
        // Rope hasn't gotten to load yet
        if (entity == null) {
            return true;
        }
        if (entity instanceof MovingRopeEntity movingRopeEntity) {
            this.rope = movingRopeEntity;
            ropeId = null;
            return true;
        }
        return false;
    }

    private boolean validRopeConnector(class_2680 state) {
        return (state.method_27852(BwtBlocks.anchorBlock) && state.method_11654(AnchorBlock.field_10927) == class_2350.field_11036) || state.method_27852(BwtBlocks.ropeBlock);
    }

    private boolean canGoUp(class_1937 world, class_2338 pos, class_2680 state) {
        if (!isRaising(state)) {
            return false;
        }
        if (!putRope(true)) {
            return false;
        }
        class_2338 lowest = RopeBlock.getBottomRopePos(world, pos);
        return !lowest.equals(pos);
    }

    private boolean canGoDown(class_1937 world, class_2338 pos, class_2680 state, boolean isMoving) {
        if (!isLowering(state)) {
            return false;
        }
        if (!hasRope()) {
            return false;
        }
        class_2338 newPos = RopeBlock.getBottomRopePos(world, pos).method_10074();
        class_2680 newState = world.method_8320(newPos);
        boolean flag = !isMoving && validRopeConnector(newState);
        return newPos.method_10264() > world.method_31607() && (newState.method_45474() || flag) && newPos.method_10084().method_10264() > world.method_31607();
    }

    private void goUp(class_1937 world, class_2338 pos) {
        class_2338 lowest = RopeBlock.getBottomRopePos(world, pos);
        class_2680 belowState = world.method_8320(lowest.method_10074());
        rope = new MovingRopeEntity(world, pos, lowest, lowest.method_10084().method_10264());
        ropeId = null;
        if (validRopeConnector(belowState) && !movePlatform(world, lowest.method_10074(), true)) {
            rope = null;
            return;
        }
        world.method_8396(null, pos.method_10074(), BwtBlocks.ropeBlock.method_9564().method_26231().method_10595(), class_3419.field_15245,
                0.4F + (world.field_9229.method_43057() * 0.1F), 1.0F);
        world.method_8649(rope);
        world.method_8650(lowest, false);
        putRope(false);
    }

    private void goDown(class_1937 world, class_2338 pos) {
        class_2338 newPos = RopeBlock.getBottomRopePos(world, pos).method_10074();
        class_2680 bottomState = world.method_8320(newPos);
        rope = new MovingRopeEntity(world, pos, newPos.method_10084(), newPos.method_10264());
        ropeId = null;
        if (validRopeConnector(bottomState) && !movePlatform(world, newPos, false)) {
            rope = null;
            return;
        }
        world.method_8649(rope);
    }

    private boolean movePlatform(class_1937 world, class_2338 anchor, boolean up) {
        class_2680 state = world.method_8320(anchor);
        if (!(validRopeConnector(state))) {
            return false;
        }

        HashSet<class_2338> platformBlocks = new HashSet<>();
        platformBlocks.add(anchor);
        class_2338 below = anchor.method_10074();
        class_2680 belowState = world.method_8320(below);
        if (isPlatform(belowState)) {
            if (!addToList(world, below, below, platformBlocks, up)) {
                return false;
            }
        }
        else if (!(up || isIgnoreable(belowState))) {
            return false;
        }


        if (!world.field_9236) {
            for (class_2338 blockPos : platformBlocks) {
                class_2382 offset = blockPos.method_10059(anchor.method_10084());
                rope.addBlock(offset, world, blockPos, world.method_8320(blockPos));
                class_2680 upState = world.method_8320(blockPos.method_10084());
                if (isMoveableBlock(upState)) {
                    if (upState.method_26204() instanceof class_2241) {
                        upState = flattenRail(upState);
                    }
                    if (upState.method_26204() instanceof class_2457) {
                        upState = upState.method_11657(class_2457.field_11432, 0);
                    }
                    rope.addBlock(new class_2382(offset.method_10263(), offset.method_10264() + 1, offset.method_10260()), world, blockPos.method_10084(), upState);
                }
            }
            rope.getBlockMap().entrySet().stream()
                    .sorted((a, b) -> b.getKey().method_10264() - a.getKey().method_10264())
                    .forEach(entry -> {
                        class_2338 blockPos = anchor.method_10084().method_10081(entry.getKey());
                        world.method_8650(blockPos, false);
                    });
        }

        return true;
    }

    public boolean isIgnoreable(class_2680 state) {
        return state.method_45474();
    }

    public boolean isMoveableBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10091) || state.method_26204() instanceof class_2241;
    }

    public boolean isPlatform(class_2680 state) {
        return state.method_27852(BwtBlocks.platformBlock);
    }

    private class_2680 flattenRail(class_2680 state) {
        class_2754<class_2768> property = state.method_28498(class_2741.field_12507) ? class_2741.field_12507 : state.method_28498(class_2741.field_12542) ? class_2741.field_12542 : null;
        class_2768 currentShape = state.method_11654(property);
        return state.method_11657(property, switch (currentShape) {
            case field_12667, field_12666 -> class_2768.field_12674;
            case field_12670, field_12668 -> class_2768.field_12665;
            default -> currentShape;
        });
    }

    private boolean addToList(class_1937 world, class_2338 pos, class_2338 sourcePos, HashSet<class_2338> set, boolean up) {
        class_2382 distance = pos.method_10059(sourcePos);
        if (Math.abs(distance.method_10263()) > 2 || Math.abs(distance.method_10260()) > 2 || Math.abs(distance.method_10264()) > 5) {
            return false;
        }
        if (!isPlatform(world.method_8320(pos))) {
            return true;
        }

        class_2338 blockCheck = up ? pos.method_10084() : pos.method_10074();
        class_2680 otherState = world.method_8320(blockCheck);
        if (!(isIgnoreable(otherState) || isMoveableBlock(otherState) || isPlatform(otherState)) && !set.contains(blockCheck))
            return false;

        set.add(pos);

        List<class_2338> fails = new ArrayList<>();

        Arrays.stream(class_2350.values()).map(pos::method_10093).forEach(offsetPos -> {
            class_2382 distance2 = offsetPos.method_10059(sourcePos);
            if (Math.abs(distance2.method_10263()) > 2 || Math.abs(distance2.method_10260()) > 2 || Math.abs(distance2.method_10264()) > 5) {
                return;
            }
            if (fails.isEmpty() && !set.contains(offsetPos)) {
                if (!addToList(world, offsetPos, sourcePos, set, up))
                    fails.add(offsetPos);
            }
        });

        return fails.isEmpty();
    }

    public boolean onJobCompleted(class_1937 world, class_2338 pulleyPos, class_2680 pulleyState, boolean up, int targetY) {
        class_2338 ropePos = new class_2338(pulleyPos.method_10263(), targetY - (up ? 1 : 0), pulleyPos.method_10260());
        class_2680 state = world.method_8320(ropePos);
        class_2680 defaultRopeState = BwtBlocks.ropeBlock.method_9564();
        if (!up) {
            if (state.method_45474() && defaultRopeState.method_26184(world, ropePos) && hasRope()) {
                world.method_8396(null, pulleyPos.method_10074(), defaultRopeState.method_26231().method_10598(), class_3419.field_15245, 0.4F, 1.0F);
                world.method_8501(ropePos, defaultRopeState);
                takeRope(false);
            } else {
                tryNextOperation(world, pulleyPos, pulleyState);
                rope.method_31472();
                ropeId = null;
                return false;
            }
        }
        if ((rope.isMovingUp() ? canGoUp(world, pulleyPos, pulleyState) : canGoDown(world, pulleyPos, pulleyState, true)) && !rope.isPathBlocked()) {
            rope.setTargetY(targetY + (rope.isMovingUp() ? 1 : -1));
            if (up) {
                if (!world.method_8320(ropePos.method_10084()).method_26164(class_3481.field_51989)) {
                    world.method_8396(null, pulleyPos.method_10074(), defaultRopeState.method_26231().method_10595(), class_3419.field_15245,
                            0.4F + (world.field_9229.method_43057() * 0.1F), 1.0F);
                    world.method_8650(ropePos.method_10084(), false);
                    putRope(false);
                }
            }
            return true;
        } else {
            tryNextOperation(world, pulleyPos, pulleyState);
            rope.method_31472();
            ropeId = null;
            return false;
        }
    }

    protected boolean takeRope(int count, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter()) {
            long numExtracted = inventoryWrapper.extract(ItemVariant.of(BwtItems.ropeItem.method_7854()), count, transaction);
            if (simulate) {
                transaction.abort();
            }
            else {
                transaction.commit();
            }
            return numExtracted >= count;
        }
    }

    protected boolean takeRope(boolean simulate) {
        return takeRope(1, simulate);
    }

    protected boolean putRope(int count, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter()) {
            long numExtracted = inventoryWrapper.insert(ItemVariant.of(BwtItems.ropeItem.method_7854()), count, transaction);
            if (simulate) {
                transaction.abort();
            }
            else {
                transaction.commit();
            }
            return numExtracted >= count;
        }
    }

    protected boolean putRope(boolean simulate) {
        return putRope(1, simulate);
    }

    public boolean hasRope(int count) {
        return takeRope(count, true);
    }

    public boolean hasRope() {
        return hasRope(1);
    }


    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", class_2520.field_33260), registryLookup);
        this.mechPower = nbt.method_10550("mechPower");
        if (nbt.method_10545("ropeId")) {
            this.ropeId = nbt.method_25926("ropeId");
        }
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", this.inventory.method_7660(registryLookup));
        nbt.method_10569("mechPower", this.mechPower);
        if (this.rope != null && !rope.method_31481()) {
            nbt.method_25927("ropeId", this.rope.method_5667());
        }
    }

    @Override
    public void method_31662(class_1937 world) {
        super.method_31662(world);
    }

    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new PulleyScreenHandler(syncId, playerInventory, inventory, propertyDelegate);
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471(method_11010().method_26204().method_9539());
    }

    @Override
    public int method_5439() {
        return inventory.method_5439();
    }

    @Override
    public boolean method_5442() {
        return inventory.method_5442();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return inventory.method_5438(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return inventory.method_5434(slot, amount);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return inventory.method_5441(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        inventory.method_5447(slot, stack);
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return inventory.method_5443(player);
    }

    @Override
    public void method_5448() {
        inventory.method_5448();
    }

    public class Inventory extends class_1277 {
        public Inventory(int size) {
            super(size);
        }
        @Override
        public void method_5431() {
            PulleyBlockEntity.this.method_5431();
        }
    }
}
