package com.bwt.blocks.turntable;

import net.minecraft.block.*;
import net.minecraft.class_1937;
import net.minecraft.class_2222;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2458;
import net.minecraft.class_2541;
import net.minecraft.class_2546;
import net.minecraft.class_2551;
import net.minecraft.class_2555;
import net.minecraft.class_2665;
import net.minecraft.class_2667;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2745;
import net.minecraft.class_3709;
import net.minecraft.class_3867;
import net.minecraft.class_5542;
import net.minecraft.class_7715;
import java.util.HashMap;
import java.util.Map;

public interface CanRotateHelper {
    interface CanRotatePredicate {
        CanRotatePredicate FALSE = (world, pos, state) -> false;
        CanRotatePredicate TRUE = (world, pos, state) -> true;

        boolean test(class_1937 world, class_2338 pos, class_2680 state);
    }

    HashMap<Class<? extends class_2248>, CanRotatePredicate> canRotatePredicates = new HashMap<>();

    static void register(Class<? extends class_2248> blockClass, CanRotatePredicate canRotatePredicate) {
        canRotatePredicates.put(blockClass, canRotatePredicate);
    }

    static boolean canRotate(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        return canRotatePredicates.entrySet().stream()
                .filter(entry -> entry.getKey().isInstance(block))
                .findAny()
                .map(Map.Entry::getValue)
                .orElse(CanRotatePredicate.TRUE)
                .test(world, pos, state);
    }

    static void registerDefaults() {
        register(class_2665.class, (world, pos, state) -> !state.method_11654(class_2665.field_12191));
        register(class_2671.class, CanRotatePredicate.FALSE);
        register(class_2667.class, CanRotatePredicate.FALSE);
        register(class_2555.class, CanRotatePredicate.FALSE);
        register(class_2458.class, CanRotatePredicate.FALSE);
        register(class_2551.class, CanRotatePredicate.FALSE);
        register(class_2222.class, CanRotatePredicate.FALSE);
        register(class_2546.class, CanRotatePredicate.FALSE);
        register(class_2541.class, CanRotatePredicate.FALSE);
        register(class_5542.class, CanRotatePredicate.FALSE);
        register(class_7715.class, CanRotatePredicate.FALSE);
        register(class_2341.class, (world, pos, state) -> state.method_11654(class_2341.field_11007).equals(class_2738.field_12475));
        register(class_3709.class, (world, pos, state) -> state.method_11654(class_3709.field_16326).equals(class_3867.field_17098));
        register(class_2244.class, CanRotatePredicate.FALSE);
        register(class_2281.class, (world, pos, state) -> state.method_11654(class_2281.field_10770).equals(class_2745.field_12569));
    }
}
