package com.bwt.blocks.turntable;

import com.bwt.blocks.BwtBlocks;
import net.minecraft.block.*;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2443;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import java.util.HashMap;
import java.util.Map;

public interface RotationProcessHelper {
    interface RotationProcessor {
        RotationProcessor DEFAULT = RotationProcessHelper::defaultRotationProcessor;

        void accept(class_1937 world, class_2338 pos, class_2680 originalState, class_2680 rotatedState, class_2586 rotatingBlockEntity);
    }

    HashMap<Class<? extends class_2248>, RotationProcessor> processors = new HashMap<>();

    static void register(Class<? extends class_2248> blockClass, RotationProcessor statePostProcessor) {
        processors.put(blockClass, statePostProcessor);
    }

    static void processRotation(class_1937 world, class_2338 pos, class_2680 originalState, class_2680 rotatedState, class_2586 rotatingBlockEntity) {
        class_2248 block = rotatedState.method_26204();
        processors.entrySet().stream()
                .filter(entry -> entry.getKey().isInstance(block))
                .findAny()
                .map(Map.Entry::getValue)
                .orElse(RotationProcessor.DEFAULT)
                .accept(world, pos, originalState, rotatedState, rotatingBlockEntity);
    }

    static void registerDefaults() {
        register(class_2443.class, (world, pos, originalState, rotatedState, rotatingBlockEntity) -> world.method_8501(pos, rotatedState));
        register(class_2312.class, (world, pos, originalState, rotatedState, rotatingBlockEntity) -> {
            rotatedState = class_2248.method_9510(rotatedState, world, pos);
            world.method_8652(pos, class_2246.field_10124.method_9564(), class_2248.field_31028);
            world.method_8501(pos, rotatedState);
            rotatedState.method_26181(world, pos, BwtBlocks.turntableBlock, pos.method_10074(), true);
        });
        register(class_2323.class, (world, pos, originalState, rotatedState, rotatingBlockEntity) -> {
            world.method_8501(pos, rotatedState);
            rotatedState.method_26181(world, pos, BwtBlocks.turntableBlock, pos.method_10074(), true);
        });
    }

    static void defaultRotationProcessor(class_1937 world, class_2338 pos, class_2680 originalState, class_2680 rotatedState, class_2586 rotatingBlockEntity) {
        rotatedState = class_2248.method_9510(rotatedState, world, pos);
        if (rotatedState.method_26164(class_3481.field_51989)) {
            class_2248.method_9511(originalState, world, pos, rotatingBlockEntity, null, class_1799.field_8037);
            return;
        }
        world.method_8652(pos, rotatedState, class_2248.field_31036);
        rotatedState.method_26204().method_9567(world, pos, rotatedState, null, rotatedState.method_26204().method_9574(world, pos, rotatedState));
        if (rotatingBlockEntity != null) {
            world.method_8438(rotatingBlockEntity);
        }
        rotatedState.method_26181(world, pos, BwtBlocks.turntableBlock, pos.method_10074(), true);
    }
}
