package com.bwt.blocks.turntable;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.mixin.MovableBlockEntityMixin;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.turntable.TurntableRecipe;
import com.bwt.recipes.turntable.TurntableRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.BlockPosAndState;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1264;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_6088;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class TurntableBlockEntity extends class_2586 {
    protected static final int blocksAboveToRotate = 2;
    protected static final int[] ticksToRotate = new int[] {10, 20, 40, 80};
    protected static final int turnsToCraft = 8;

    public int rotationTickCounter;
    public int craftingTurnCounter;


    public TurntableBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.turntableBlockEntity, pos, state);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.rotationTickCounter = nbt.method_10550("rotationTickCounter");
        this.craftingTurnCounter = nbt.method_10550("craftingTurnCounter");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("rotationTickCounter", rotationTickCounter);
        nbt.method_10569("craftingTurnCounter", craftingTurnCounter);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TurntableBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (!state.method_27852(BwtBlocks.turntableBlock) || !state.method_11654(TurntableBlock.MECH_POWERED)) {
            blockEntity.rotationTickCounter = 0;
            return;
        }
        int tickSetting = state.method_11654(TurntableBlock.TICK_SETTING);

        blockEntity.rotationTickCounter++;
        if (blockEntity.rotationTickCounter >= ticksToRotate[tickSetting]) {
            world.method_8396(null, pos, BwtSoundEvents.TURNTABLE_TURNING_CLICK, class_3419.field_15245, 0.05f, 1f);
            blockEntity.rotationTickCounter = 0;
            rotateTurnTable(world, pos, state, blockEntity);
        }
    }

    protected static void rotateTurnTable(class_1937 world, class_2338 pos, class_2680 state, TurntableBlockEntity blockEntity) {
        class_2470 rotation = state.method_11654(TurntableBlock.POWERED) ? class_2470.field_11463 : class_2470.field_11465;
        List<BlockPosAndState> blocksToRotate = getBlocksToRotate(world, pos);
        List<BlockPosAndState> attachedBlocksBeingRotated = getAttachedBlocksBeingRotated(world, blocksToRotate);
        List<BlockPosAndState> attachedBlockDestinations = getAttachedBlockDestinations(world, pos, attachedBlocksBeingRotated, rotation);
        pickUpAttachedBlocks(world, attachedBlocksBeingRotated, attachedBlockDestinations);
        rotateCentralColumnBlocks(world, blocksToRotate, blockEntity, rotation);
        placeRotatedAttachedBlocks(world, attachedBlocksBeingRotated, attachedBlockDestinations, rotation);
        // Notify neighbors of the rotation
        state.method_30101(world, pos, class_2248.field_31027);
    }

    protected static List<BlockPosAndState> getBlocksToRotate(class_1937 world, class_2338 turntablePos) {
        class_1863 recipeManager = world.method_8433();

        List<BlockPosAndState> blocksToRotate = new ArrayList<>();
        for (int j = 1; j <= blocksAboveToRotate; j++) {
            class_2338 blockAbovePos = turntablePos.method_10086(j);
            class_2680 blockAboveState = world.method_8320(blockAbovePos);
            if (blockAboveState.method_26164(class_3481.field_51989)) {
                break;
            }
            if (!CanRotateHelper.canRotate(world, blockAbovePos, blockAboveState)) {
                break;
            }

            class_2586 blockAboveEntity = world.method_8321(blockAbovePos);
            blocksToRotate.add(new BlockPosAndState(blockAbovePos, blockAboveState, blockAboveEntity));

            // Crafting
            TurntableRecipeInput recipeInput = new TurntableRecipeInput(blockAboveState.method_26204());
            boolean recipeExistsForBlock = recipeManager.method_8132(
                    BwtRecipes.TURNTABLE_RECIPE_TYPE,
                    recipeInput,
                    world
            ).isPresent();

            if (recipeExistsForBlock) {
                // Don't propagate rotation upward for craftables
                break;
            }
            // The < check here is just a minor optimization, so we don't need to check propagation unnecessarily
            if (!VerticalBlockAttachmentHelper.canPropagateRotationUpwards(world, blockAbovePos, blockAboveState)) {
                break;
            }
        }
        return blocksToRotate;
    }

    protected static List<BlockPosAndState> getAttachedBlocksBeingRotated(class_1937 world, List<BlockPosAndState> blocksToRotate) {
        ArrayList<BlockPosAndState> attachedBlocks = new ArrayList<>();
        for (BlockPosAndState centralColumnPosAndState : blocksToRotate) {
            class_2338 centralColumnPos = centralColumnPosAndState.pos();
            class_2680 centralColumnState = centralColumnPosAndState.state();

            attachedBlocks.addAll(Arrays.stream(class_2350.values())
                    .filter(direction -> direction.method_10166().method_10179())
                    .map(centralColumnPos::method_10093)
                    .map(attachedPos -> BlockPosAndState.of(world, attachedPos))
                    .filter(attachedPosAndState -> HorizontalBlockAttachmentHelper.isAttached(centralColumnPos, centralColumnState, attachedPosAndState.pos(), attachedPosAndState.state()))
                    .toList());
        }
        return attachedBlocks;
    }

    protected static List<BlockPosAndState> getAttachedBlockDestinations(class_1937 world, class_2338 turntablePos, List<BlockPosAndState> attachedBlocksBeingRotated, class_2470 rotation) {
        return attachedBlocksBeingRotated.stream().map(attachedPosAndState -> {
            class_2338 attachedPos = attachedPosAndState.pos();
            class_2338 centralColumnPos = new class_2338(turntablePos.method_10263(), attachedPos.method_10264(), turntablePos.method_10260());

            class_2382 directionVector = attachedPos.method_10059(centralColumnPos);
            class_2350 direction = class_2350.method_50026(directionVector.method_10263(), 0, directionVector.method_10260());
            class_2338 attachedDestinationPos = centralColumnPos.method_10093(rotation.equals(class_2470.field_11463) ? Objects.requireNonNull(direction).method_10170() : Objects.requireNonNull(direction).method_10160());
            return BlockPosAndState.of(world, attachedDestinationPos);
        }).toList();
    }

    protected static void pickUpAttachedBlocks(class_1937 world, List<BlockPosAndState> attachedBlocksBeingRotated, List<BlockPosAndState> destinations) {
        HashSet<class_2338> attachedPositions = attachedBlocksBeingRotated.stream().map(BlockPosAndState::pos).collect(Collectors.toCollection(HashSet::new));

        for (int idx = 0; idx < attachedBlocksBeingRotated.size(); idx++) {
            BlockPosAndState attachedPosAndState = attachedBlocksBeingRotated.get(idx);
            BlockPosAndState destination = destinations.get(idx);

            class_2338 attachedPos = attachedPosAndState.pos();
            class_2680 attachedState = attachedPosAndState.state();
            class_2586 attachedBlockEntity = attachedPosAndState.blockEntity();

            if (attachedPositions.contains(destination.pos()) || destination.state().method_45474()) {
                // Pick up block cleanly
                if (attachedBlockEntity != null) {
                    world.method_8544(attachedPos);
                }
                world.method_8650(attachedPos, false);
                world.method_8455(attachedPos, attachedState.method_26204());
            }
            else {
                // Break block with drops
                world.method_22352(attachedPos, true);
            }
        }
    }

    protected static void rotateCentralColumnBlocks(class_1937 world, List<BlockPosAndState> blocksToRotate, TurntableBlockEntity blockEntity, class_2470 rotation) {
        class_1863 recipeManager = world.method_8433();
        boolean recipeFound = false;

        for (BlockPosAndState blockToRotate : blocksToRotate) {
            class_2338 blockToRotatePos = blockToRotate.pos();
            class_2680 blockToRotateState = blockToRotate.state();
            class_2586 blockToRotateEntity = blockToRotate.blockEntity();

            class_2680 rotatedState = blockToRotateState.method_26186(rotation);
            RotationProcessHelper.processRotation(world, blockToRotatePos, blockToRotateState, rotatedState, blockToRotateEntity);

            // Crafting
            TurntableRecipeInput recipeInput = new TurntableRecipeInput(blockToRotateState.method_26204());
            Optional<TurntableRecipe> recipe = recipeManager.method_8132(
                    BwtRecipes.TURNTABLE_RECIPE_TYPE,
                    recipeInput,
                    world
            ).map(class_8786::comp_1933);

            if (recipe.isPresent()) {
                recipeFound = true;
                blockEntity.craftingTurnCounter += 1;
                world.method_20290(class_6088.field_31144, blockToRotatePos, class_2248.method_9507(blockToRotateState));
                if (blockEntity.craftingTurnCounter >= TurntableBlockEntity.turnsToCraft) {
                    blockEntity.craftingTurnCounter = 0;
                    world.method_8501(blockToRotatePos, recipe.get().getOutput().method_9564());
                    class_1264.method_17349(world, blockToRotatePos, recipe.get().getDrops());
                }
            }
        }

        if (!recipeFound) {
            blockEntity.craftingTurnCounter = 0;
        }
    }

    protected static void placeRotatedAttachedBlocks(class_1937 world, List<BlockPosAndState> attachedBlocksBeingRotated, List<BlockPosAndState> destinations, class_2470 rotation) {
        HashSet<class_2338> attachedPositions = attachedBlocksBeingRotated.stream().map(BlockPosAndState::pos).collect(Collectors.toCollection(HashSet::new));

        for (int idx = 0; idx < attachedBlocksBeingRotated.size(); idx++) {
            BlockPosAndState attachedPosAndState = attachedBlocksBeingRotated.get(idx);
            BlockPosAndState destination = destinations.get(idx);

            class_2338 attachedPos = attachedPosAndState.pos();
            class_2680 attachedState = attachedPosAndState.state();
            class_2586 attachedBlockEntity = attachedPosAndState.blockEntity();

            if (attachedPositions.contains(destination.pos()) || destination.state().method_45474()) {
                class_2680 attachedStateRotated = attachedState.method_26186(rotation);
                world.method_8501(destination.pos(), attachedStateRotated);
                attachedStateRotated.method_26204().method_9567(world, destination.pos(), attachedStateRotated, null, attachedStateRotated.method_26204().method_9574(world, destination.pos(), attachedStateRotated));
                if (attachedBlockEntity != null) {
                    ((MovableBlockEntityMixin) attachedBlockEntity).setPos(destination.pos());
                    attachedBlockEntity.method_31664(attachedStateRotated);
                    attachedBlockEntity.method_5431();
                    world.method_8438(attachedBlockEntity);
                }
            }
            else {
                // Break block with drops
                world.method_22352(attachedPos, true);
            }
        }
    }
}
