package com.bwt.blocks.turntable;

import com.bwt.blocks.*;
import com.bwt.blocks.mining_charge.MiningChargeBlock;
import com.bwt.tags.BwtBlockTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public interface VerticalBlockAttachmentHelper {
    interface CanPropagatePredicate {
        CanPropagatePredicate FALSE = (world, pos, state) -> false;
        CanPropagatePredicate TRUE = (world, pos, state) -> true;
        CanPropagatePredicate DEFAULT = (world, pos, state) -> state.method_26234(world, pos) || state.method_26164(BwtBlockTags.TRANSFERS_ROTATION_UPWARD_OVERRIDE);

        boolean test(class_1937 world, class_2338 pos, class_2680 state);
    }

    HashMap<Class<? extends class_2248>, CanPropagatePredicate> canPropagatePredicates = new HashMap<>();

    static void register(Class<? extends class_2248> blockClass, CanPropagatePredicate canPropagatePredicate) {
        canPropagatePredicates.put(blockClass, canPropagatePredicate);
    }

    static boolean canPropagateRotationUpwards(class_1937 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        return canPropagatePredicates.entrySet().stream()
                .filter(entry -> entry.getKey().isInstance(block))
                .findAny()
                .map(Map.Entry::getValue)
                .orElse(CanPropagatePredicate.DEFAULT)
                .test(world, pos, state);
    }

    static void registerDefaults() {
        register(class_2189.class, CanPropagatePredicate.FALSE);
        register(SidingBlock.class, (world, pos, state) -> SidingBlock.isHorizontal(state));
        register(MouldingBlock.class, (world, pos, state) -> MouldingBlock.isVertical(state));
        register(AnchorBlock.class, (world, pos, state) -> AnchorBlock.isHorizontal(state));
        register(SawBlock.class, (world, pos, state) -> SawBlock.isHorizontal(state));
        register(MiningChargeBlock.class, (world, pos, state) -> MiningChargeBlock.isHorizontal(state));
        register(HandCrankBlock.class, CanPropagatePredicate.FALSE);
    }
}
