package com.bwt.blocks.unfired_pottery;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_8526;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class UnfiredDecoratedPotBlockEntity extends class_2586 {
    public static final String SHERDS_NBT_KEY = "sherds";
    private class_8526 sherds;

    public UnfiredDecoratedPotBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.unfiredDecoratedPotBlockEntity, pos, state);
        this.sherds = class_8526.field_44707;
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.sherds.method_51513(nbt);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.sherds = class_8526.method_51516(nbt);
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = method_38244(registryLookup);
        sherds.method_51513(nbtCompound);
        return nbtCompound;
    }

    private void updateListeners() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), class_2248.field_31036);
        }
    }

    public class_2350 getHorizontalFacing() {
        return this.method_11010().method_11654(UnfiredDecoratedPotBlockWithSherds.FACING);
    }

    public HashMap<class_2350, Optional<class_1792>> getDirectionalSherds() {
        class_2350 relativeDirection = getHorizontalFacing();
        ArrayList<Optional<class_1792>> directionalSherds = new ArrayList<>(getRotationalSherds());
        while (!relativeDirection.equals(class_2350.field_11043)) {
            relativeDirection = relativeDirection.method_10170();
            directionalSherds.add(directionalSherds.remove(0));
        }
        List<class_2350> directions = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);
        return IntStream.range(0, directions.size())
                .boxed()
                .collect(
                        Collectors.toMap(
                                directions::get,
                                directionalSherds::get,
                                (a, b) -> b,
                                HashMap::new
                        )
                );
    }

    public HashMap<class_2350, class_1792> getPresentDirectionSherds() {
        return getDirectionalSherds().entrySet().stream()
                .filter(entry -> entry.getValue().isPresent())
                .map(entry -> Map.entry(entry.getKey(), entry.getValue().get()))
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        Map.Entry::getValue,
                        (a, b) -> b,
                        HashMap::new
                ));
    }

    public List<Optional<class_1792>> getRotationalSherds() {
        return List.of(sherds.comp_1490(), sherds.comp_1489(), sherds.comp_1487(), sherds.comp_1488());
    }

    public void setRotationalSherds(List<Optional<class_1792>> rotationalSherds) {
        setSherds(new class_8526(rotationalSherds.get(2), rotationalSherds.get(3), rotationalSherds.get(1), rotationalSherds.get(0)));
    }

    public boolean hasSherds() {
        return streamSherds().findAny().isPresent();
    }

    public boolean tryAddSherd(class_2350 side, class_1792 sherd) {
        class_2350 relativeDirection = getHorizontalFacing();
        if (side.method_10166().method_10178()) {
            return false;
        }
        int rotations = 0;
        while (!relativeDirection.equals(side)) {
            relativeDirection = relativeDirection.method_10170();
            rotations++;
        }
        ArrayList<Optional<class_1792>> rotationalSherds = new ArrayList<>(getRotationalSherds());
        Optional<class_1792> directionalSherd = rotationalSherds.get(rotations);
        if (directionalSherd.isPresent()) {
            return false;
        }
        rotationalSherds.set(rotations, Optional.of(sherd));
        setRotationalSherds(rotationalSherds);
        return true;
    }

    public Optional<class_1792> tryRemoveSherd(class_2350 side) {
        class_2350 relativeDirection = getHorizontalFacing();
        if (side.method_10166().method_10178()) {
            return Optional.empty();
        }
        int rotations = 0;
        while (!relativeDirection.equals(side)) {
            relativeDirection = relativeDirection.method_10170();
            rotations++;
        }
        ArrayList<Optional<class_1792>> rotationalSherds = new ArrayList<>(getRotationalSherds());
        Optional<class_1792> directionalSherd = rotationalSherds.get(rotations);
        rotationalSherds.set(rotations, Optional.empty());
        setRotationalSherds(rotationalSherds);
        return directionalSherd;
    }

    public void setSherds(class_8526 sherds) {
        this.sherds = sherds;
        updateListeners();
    }

    public Stream<class_1792> streamSherds() {
        return Stream.of(sherds.comp_1490(), sherds.comp_1487(), sherds.comp_1488(), sherds.comp_1489())
                .filter(Optional::isPresent)
                .map(Optional::get);
    }

    public void readFrom(class_1799 stack) {
        this.method_58683(stack);
    }

    public class_1799 asStack() {
        class_1799 itemStack = BwtBlocks.unfiredDecoratedPotBlockWithSherds.method_8389().method_7854();
        itemStack.method_57365(this.method_57590());
        return itemStack;
    }

    @Override
    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(class_9334.field_49621, this.sherds);
    }

    @Override
    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        this.sherds = components.method_58695(class_9334.field_49621, class_8526.field_44707);
    }

    @Override
    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551(SHERDS_NBT_KEY);
    }
}
