package com.bwt.emi.recipehandlers;

import com.bwt.blocks.soul_forge.SoulForgeScreenHandler;
import com.bwt.emi.BwtEmiPlugin;
import com.bwt.emi.recipes.EmiSoulForgeRecipe;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;

public class EmiSoulForgeRecipeHandler {

    public static List<EmiRecipeCategory> CATEGORIES = List.of(BwtEmiPlugin.SOUL_FORGE, VanillaEmiRecipeCategories.CRAFTING);

    public static class FourByFour implements StandardRecipeHandler<SoulForgeScreenHandler> {
        @Override
        public @Nullable class_1735 getOutputSlot(SoulForgeScreenHandler handler) {
            return handler.field_7761.get(0);
        }

        @Override
        public List<class_1735> getInputSources(SoulForgeScreenHandler handler) {
            return handler.field_7761.subList(1, handler.field_7761.size());
        }

        @Override
        public List<class_1735> getCraftingSlots(SoulForgeScreenHandler handler) {
            return handler.field_7761.subList(1, 17);
        }

        @Override
        public boolean supportsRecipe(EmiRecipe recipe) {
            if (!CATEGORIES.contains(recipe.getCategory())) {
                return false;
            }
            if (recipe instanceof EmiSoulForgeRecipe soulForgeRecipe) {
                return soulForgeRecipe.canFit(4, 4) && !soulForgeRecipe.canFit(3, 3);
            }
            if (recipe instanceof EmiCraftingRecipe craftingRecipe) {
                return craftingRecipe.canFit(4, 4) && !craftingRecipe.canFit(3, 3);
            }
            return recipe.getInputs().size() > 9;
        }
    }

    public static class ThreeByThree  implements StandardRecipeHandler<SoulForgeScreenHandler> {
        @Override
        public @Nullable class_1735 getOutputSlot(SoulForgeScreenHandler handler) {
            return handler.field_7761.get(0);
        }

        @Override
        public List<class_1735> getInputSources(SoulForgeScreenHandler handler) {
            List<class_1735> slots = new ArrayList<>();
            slots.addAll(handler.field_7761.subList(1, 4));
            slots.addAll(handler.field_7761.subList(5, 8));
            slots.addAll(handler.field_7761.subList(9, 12));
            slots.addAll(handler.field_7761.subList(17, handler.field_7761.size()));
            return slots;
        }

        @Override
        public List<class_1735> getCraftingSlots(SoulForgeScreenHandler handler) {
            List<class_1735> slots = new ArrayList<>();
            slots.addAll(handler.field_7761.subList(1, 4));
            slots.addAll(handler.field_7761.subList(5, 8));
            slots.addAll(handler.field_7761.subList(9, 12));
            return slots;
        }
        @Override
        public boolean supportsRecipe(EmiRecipe recipe) {
            if (!CATEGORIES.contains(recipe.getCategory())) {
                return false;
            }
            if (recipe instanceof EmiSoulForgeRecipe soulForgeRecipe) {
                return soulForgeRecipe.canFit(3, 3);
            }
            if (recipe instanceof EmiCraftingRecipe craftingRecipe) {
                return craftingRecipe.canFit(3, 3);
            }
            return recipe.getInputs().size() <= 9;
        }
    }


}
