package com.bwt.entities;

import com.bwt.damage_types.BwtDamageTypes;
import com.bwt.items.BwtItems;
import com.bwt.sounds.BwtSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1264;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3856;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import net.minecraft.entity.*;
import java.util.Arrays;

public class DynamiteEntity extends class_1676 implements class_3856 {

    public static final int TICKS_TO_DETONATE = 100;

    private static final class_2940<class_1799> ITEM = class_2945.method_12791(DynamiteEntity.class, class_2943.field_13322);
    public static class_2940<Integer> FUSE = class_2945.method_12791(DynamiteEntity.class, class_2943.field_13327);

    protected DynamiteEntity(class_1299<DynamiteEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public DynamiteEntity(double x, double y, double z, class_1937 world) {
        this(BwtEntities.dynamiteEntity, world);
        this.method_5814(x, y, z);
    }

    public DynamiteEntity(class_1937 world, class_1309 owner) {
        this(owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321(), world);
        this.method_7432(owner);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ITEM, class_1799.field_8037);
        builder.method_56912(FUSE, -1);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("fuse", getFuse());
        class_1799 itemStack = getItem();
        if (!itemStack.method_7960()) {
            nbt.method_10566("Item", itemStack.method_57358(method_56673()));
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        setFuse(nbt.method_10550("fuse"));
        if (nbt.method_10573("Item", class_2520.field_33260)) {
            setItem(class_1799.method_57360(method_56673(), nbt.method_10562("Item")).orElseGet(() -> new class_1799(getDefaultItem())));
        } else {
            setItem(new class_1799(getDefaultItem()));
        }
    }

    @Override
    public class_1799 method_7495() {
        class_1799 itemStack = this.getItem();
        return itemStack.method_7960() ? new class_1799(this.getDefaultItem()) : itemStack;
    }

    protected class_1792 getDefaultItem() {
        return BwtItems.dynamiteItem;
    }

    public int getFuse() {
        return field_6011.method_12789(FUSE);
    }

    public void setFuse(int value) {
        field_6011.method_12778(FUSE, value);
    }

    protected class_1799 getItem() {
        return this.method_5841().method_12789(ITEM);
    }

    public void setItem(class_1799 item) {
        this.method_5841().method_12778(ITEM, item.method_46651(1));
    }

    public void ignite() {
        field_6011.method_12778(FUSE, TICKS_TO_DETONATE);
        method_5783(BwtSoundEvents.DYNAMITE_IGNITE, 0.5f, 1.0f);
    }

    public boolean method_5753() {
        return true;
    }

    @Override
    public boolean method_5640(double distance) {
        double d = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d)) {
            d = 4.0;
        }
        return distance < (d *= 64.0) * d;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_5740()) {
            this.method_5762(0.0, -0.04, 0.0);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
        }

        int fuse = getFuse();
        if (fuse > 0) {
            setFuse(fuse - 1);
            fuse--;
            if (method_37908().field_9236) {
                method_37908().method_8406(class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), method_18798().method_10216() * 0.1, method_18798().method_10214() * 0.1, method_18798().method_10215() * 0.1);
            }
        }

        if (fuse == 0) {
            method_31472();
            if (!method_37908().field_9236) {
                explode();
            }
            return;
        }

        if (fuse < 0) {
            if (this.method_5771()) {
                ignite();
                method_31472();
                if (!method_37908().field_9236) {
                    explode();
                }
                return;
            }
            if (method_24828()) {
                if (method_18798().method_1033() < 0.01) {
                    // The dynamite has come to a stop. Convert it to an item.
                    if (!method_37908().field_9236) {
                        convertToItem();
                        return;
                    }
                }
            }
        }
    }

    public void explode() {
        this.method_37908().method_8437(this, this.method_23317(), this.method_23323(0.0625), this.method_23321(), 1.5f, class_1937.class_7867.field_40891);
        if (method_5869()) {
            redneckFish();
        }
    }

    private void redneckFish() {
        for (int i = method_31477() - 2; i <= method_31477() + 2; i++) {
            // favor deep water
            for (int j = method_31478() - 2; j <= method_31478() + 4; j++) {
                for (int k = method_31479() - 2; k <= method_31479() + 2; k++) {
                    class_2338 offsetPos = new class_2338(i, j, k);
                    if (!isValidBlockForRedneckFishing(offsetPos)) {
                        continue;
                    }
                    // averages one per j layer
                    if (field_5974.method_43048( 25 ) == 0 ) {
                        spawnRedneckFish(offsetPos);
                    }
                }
            }
        }
    }

    private boolean isValidBlockForRedneckFishing(class_2338 pos) {
        // block must be totally surrounded by water (except positive j) to be valid
        return Arrays.stream(class_2350.values())
                .filter(direction -> direction != class_2350.field_11036)
                .map(pos::method_10093)
                .map(offsetPos -> method_37908().method_8316(offsetPos))
                .allMatch(fluidState -> fluidState.method_15767(class_3486.field_15517));
    }

    private void spawnRedneckFish(class_2338 pos) {
        if (!(method_37908() instanceof class_3218 serverWorld)) {
            return;
        }
        class_8567 lootContextParameterSet = new class_8567.class_8568(serverWorld)
                .method_51874(class_181.field_24424, this.method_19538())
                .method_51874(class_181.field_1226, this)
                .method_51874(class_181.field_1231, BwtDamageTypes.of(serverWorld, class_8111.field_42331))
                .method_51875(class_173.field_1173);
        class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(class_39.field_795);
        ObjectArrayList<class_1799> list = lootTable.method_51878(lootContextParameterSet);
        if (list.isEmpty()) {
            return;
        }
        class_1799 itemStack = list.get(field_5974.method_43048(list.size()));
        if (!itemStack.method_31573(class_3489.field_15527)) return;
        class_1542 itemEntity = new class_1542(serverWorld, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, itemStack);
        this.method_37908().method_8649(itemEntity);
    }

    private void convertToItem() {
        class_1264.method_5449(method_37908(), method_23317(), method_23318(), method_23321(), method_7495());
        method_31472();
    }
}
