package com.bwt.entities;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.pulley.PulleyBlockEntity;
import com.bwt.mixin.MovableBlockEntityMixin;
import com.bwt.utils.TrackedDataHandlers;
import com.bwt.utils.VoxelShapedEntity;
import com.bwt.utils.rectangular_entity.EntityRectDimensions;
import com.bwt.utils.rectangular_entity.RectangularEntity;
import com.google.common.collect.Maps;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1530;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2626;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_7924;
import net.minecraft.entity.*;
import java.util.*;

public class MovingRopeEntity extends RectangularEntity implements VoxelShapedEntity {
    protected static final class_2940<class_2338> pulleyPos = class_2945.method_12791(MovingRopeEntity.class, class_2943.field_13324);
    private static final class_2940<Integer> targetY = class_2945.method_12791(MovingRopeEntity.class, class_2943.field_13327);
    private static final class_2940<Boolean> up = class_2945.method_12791(MovingRopeEntity.class, class_2943.field_13323);
    private static final class_2940<Map<class_2382, class_2680>> blockMap = class_2945.method_12791(MovingRopeEntity.class, TrackedDataHandlers.blockStateMapHandler);
    private static final class_2940<Map<class_2382, class_2487>> blockEntityNbtMap = class_2945.method_12791(MovingRopeEntity.class, TrackedDataHandlers.blockEntityMapHandler);
    private class_265 voxelShape = class_259.method_1077();
    private final float field_28627 = 1f / 20f;

    public MovingRopeEntity(class_1299<? extends MovingRopeEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_23807 = true;
    }


    public MovingRopeEntity(class_1937 world, class_2338 pulley, class_2338 source, int targetY) {
        this(BwtEntities.movingRopeEntity, world);
        setTargetY(targetY);
        if (source != null) {
            setIsMovingUp(source.method_10264() < targetY);
            method_5814(source.method_10263() + 0.5, source.method_10264(), source.method_10260() + 0.5);
        }
        this.field_5985 = true;
        setPulleyPos(pulley);
    }


    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(pulleyPos, class_2338.field_10980);
        builder.method_56912(up, false);
        builder.method_56912(targetY, 0);
        builder.method_56912(blockMap, Maps.newHashMap());
        builder.method_56912(blockEntityNbtMap, Maps.newHashMap());
    }

    public void setPulleyPos(class_2338 pos) {
        this.field_6011.method_12778(pulleyPos, pos);
    }

    public class_2338 getPulleyPos() {
        return this.field_6011.method_12789(pulleyPos);
    }

    public boolean isMovingUp() {
        return this.field_6011.method_12789(up);
    }

    public void setIsMovingUp(boolean value) {
        this.field_6011.method_12778(up, value);
    }

    public int getTargetY() {
        return this.field_6011.method_12789(targetY);
    }

    public void setTargetY(int value) {
        this.field_6011.method_12778(targetY, value);
    }

    public void setBlockMap(Map<class_2382, class_2680> map) {
        this.field_6011.method_12778(blockMap, map);
    }

    public HashMap<class_2382, class_2680> getBlockMap() {
        Map<class_2382, class_2680> blockMap = this.field_6011.method_12789(MovingRopeEntity.blockMap);
        return new HashMap<>(blockMap);
    }

    public void setBlockEntityNbtMap(Map<class_2382, class_2487> map) {
        this.field_6011.method_12778(blockEntityNbtMap, map);
    }

    public HashMap<class_2382, class_2487> getBlockEntityNbtMap() {
        Map<class_2382, class_2487> nbtMap = this.field_6011.method_12789(blockEntityNbtMap);
        return new HashMap<>(nbtMap);
    }

    @Override
    public boolean method_5740() {
        return true;
    }

    @Override
    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
    }

    @Override
    public class_265 getVoxelShape() {
        return voxelShape;
    }

    public void setVoxelShape(class_265 voxelShape) {
        this.voxelShape = voxelShape;
        method_5857(voxelShape.method_1107());
        method_18382();
        method_33332();
    }

    @Override
    public EntityRectDimensions getRectDimensions() {
        class_238 boundingBox = method_5829();
        return EntityRectDimensions.fixed((float) boundingBox.method_17939(), (float) boundingBox.method_17940(), (float) boundingBox.method_17941());
    }

    @Override
    protected class_238 method_33332() {
        return class_238.method_54784(
                new class_2338(
                    getBlockMap().keySet().stream().mapToInt(class_2382::method_10263).min().orElse(0),
                    getBlockMap().keySet().stream().mapToInt(class_2382::method_10264).min().orElse(0),
                    getBlockMap().keySet().stream().mapToInt(class_2382::method_10260).min().orElse(0)
                ),
                new class_2338(
                    getBlockMap().keySet().stream().mapToInt(class_2382::method_10263).max().orElse(0),
                    getBlockMap().keySet().stream().mapToInt(class_2382::method_10264).max().orElse(0),
                    getBlockMap().keySet().stream().mapToInt(class_2382::method_10260).max().orElse(0)
                )
        ).method_997(method_19538()).method_989(-0.5, 0, -0.5);
    }


    @Override
    public double method_23320() {
        return -1;
    }

    @Override
    protected void method_5749(class_2487 compound) {
        setPulleyPos(new class_2338(compound.method_10550("PulleyX"), compound.method_10550("PulleyY"), compound.method_10550("PulleyZ")));
        setTargetY(compound.method_10550("TargetY"));
        setIsMovingUp(compound.method_10577("Up"));
        if (compound.method_10573("blocks", class_2520.field_33259)) {
            Map<class_2382, class_2680> blocks = deserializeBlockMap(compound.method_10554("blocks", class_2520.field_33260));
            setBlockMap(blocks);
            rebuildBlockBoundingBox();
        }
        if (compound.method_10573("blockEntities", class_2520.field_33259)) {
            setBlockEntityNbtMap(deserializeBlockEntities(compound.method_10554("blockEntities", class_2520.field_33260)));
        }
    }

    @Override
    protected void method_5652(class_2487 compound) {
        compound.method_10569("PulleyX", getPulleyPos().method_10263());
        compound.method_10569("PulleyY", getPulleyPos().method_10264());
        compound.method_10569("PulleyZ", getPulleyPos().method_10260());
        compound.method_10569("TargetY", getTargetY());
        compound.method_10556("Up", isMovingUp());
        compound.method_10566("blocks", serializeBlockMap());
        compound.method_10566("blockEntities", serializeBlockEntities());
    }

    private class_2499 serializeBlockEntities() {
        class_2499 entries = new class_2499();
        getBlockEntityNbtMap().forEach((offset, blockEntity) -> {
            class_2487 entry = new class_2487();
            entry.method_10544("offset", new class_2338(offset).method_10063());
            entry.method_10566("blockEntity", blockEntity);
            entries.add(entry);
        });
        return entries;
    }

    private Map<class_2382, class_2487> deserializeBlockEntities(class_2499 blockEntities) {
        Map<class_2382, class_2487> map = new HashMap<>();
        for (class_2520 entry : blockEntities) {
            class_2487 compound = (class_2487) entry;
            map.put(
                    class_2338.method_10092(compound.method_10537("offset")),
                    compound.method_10562("blockEntity")
            );
        }
        return map;
    }

    private class_2499 serializeBlockMap() {
        class_2499 entries = new class_2499();
        for (Map.Entry<class_2382, class_2680> entry : getBlockMap().entrySet()) {
            if (entry.getValue() == null) {
                continue;
            }
            class_2487 listEntry = new class_2487();
            listEntry.method_10544("pos", new class_2338(entry.getKey()).method_10063());
            listEntry.method_10566("state", class_2512.method_10686(entry.getValue()));
            entries.add(listEntry);
        }
        return entries;
    }

    private Map<class_2382, class_2680> deserializeBlockMap(class_2499 blocks) {
        Map<class_2382, class_2680> map = new HashMap<>();
        for (class_2520 entry : blocks) {
            class_2487 entryCompound = ((class_2487) entry);
            class_2382 pos = class_2338.method_10092(entryCompound.method_10537("pos"));
            class_2680 state = class_2512.method_10681(this.method_37908().method_45448(class_7924.field_41254), entryCompound.method_10562("state"));
            map.put(pos, state);
        }
        return map;
    }

    public boolean method_30632(class_2338 pos, class_2680 state) {
        class_265 voxelShape2 = state.method_26194(this.method_37908(), pos, class_3726.method_16195(this)).method_1096(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return class_259.method_1074(voxelShape2, class_259.method_1078(this.method_5829()), class_247.field_16896);
    }

    public void rebuildBlockBoundingBox() {
        HashMap<class_2382, class_2680> blocks = getBlockMap();
        if (blocks == null || blocks.isEmpty()) {
            setVoxelShape(class_259.method_1077());
            return;
        }
        class_265 newShape = class_259.method_1073();
        for (Map.Entry<class_2382, class_2680> entry : blocks.entrySet()) {
            newShape = class_259.method_1084(newShape, entry.getValue().method_26220(method_37908(), method_24515().method_10081(entry.getKey())).method_1096(entry.getKey().method_10263(), entry.getKey().method_10264(), entry.getKey().method_10260()));
        }
        setVoxelShape(newShape);
    }

    private double getSpeed() {
        return isMovingUp() ? field_28627 : -field_28627;
    }

    @Override
    public boolean method_30949(class_1297 other) {
        return other instanceof MovingRopeEntity;
    }

    @Override
    public void method_5773() {
        if (getPulleyPos() == null) {
            return;
        }
        rebuildBlockBoundingBox();
        if (isMovingUp()) {
            if (method_23318() > getTargetY()) {
                if (done())
                    return;
            }
        } else {
            if (method_23318() < getTargetY()) {
                if (done())
                    return;
            }
        }

        HashMap<class_1297, class_238> riders = getRiders();
        moveRiders(riders);
        method_5814(
                getPulleyPos().method_10263() + 0.5,
                this.method_23318() + getSpeed(),
                getPulleyPos().method_10260() + 0.5
        );
        riders = getRiders();
        moveRiders(riders);
    }

    public HashMap<class_1297, class_238> getRiders() {
        HashMap<class_1297, class_238> entities = new HashMap<>();
        for (class_238 box : this.getVoxelShape().method_1096(method_23317() - 0.5, method_23318(), method_23321() - 0.5).method_1090()) {
            for (class_1297 entity1 : method_37908().method_8333(this, box.method_1009(1.0E-7, 0.15, 1.0E-7), class_1301.field_6155.and(entity -> !(entity instanceof class_1530)))) {
                entities.put(entity1, box);
            }
        }
        return entities;
    }

    public void moveRiders(HashMap<class_1297, class_238> riders) {
        riders.forEach((entity, box) -> {
            if (entity.method_23318() < box.field_1322) {
                return;
            }
            double thisFrameIntersectingY = entity.method_23318() - box.field_1325;
            if (thisFrameIntersectingY < 0) {
                entity.method_5814(entity.method_23317(), box.field_1325 + 1.0e-7, entity.method_23321());
            }
            // If entity is moving downwards, next frame it will intersect the platform by this much
            double nextFrameIntersectingY = entity.method_18798().field_1351;
            if (nextFrameIntersectingY < 0) {
                entity.method_5762(0, -nextFrameIntersectingY, 0);
            }
            entity.method_5762(0, getSpeed() - entity.method_18798().field_1351, 0);
            entity.method_24830(true);
        });
    }


    @Override
    public boolean method_5862() {
        return false;
    }

    private void reconstruct() {
        class_2338 pos = getPulleyPos().method_10087(getPulleyPos().method_10264() - getTargetY());

        int retries = 0;
        Map<class_2382, class_2680> blocks = getBlockMap();
        Map<class_2382, class_2487> blockEntities = getBlockEntityNbtMap();
        while (!blocks.isEmpty() && retries < 10) {
            retries++;
            int skipped = 0;
            for (Map.Entry<class_2382, class_2680> entry : blocks.entrySet()) {
                class_2338 blockPos = pos.method_10081(entry.getKey());
                class_2680 state = entry.getValue();
                if (state.method_26184(method_37908(), blockPos)) {
                    if (method_37908().method_8652(blockPos, state, class_2248.field_31036)) {
                        ((class_3218) this.method_37908()).method_14178().method_18754(this, new class_2626(blockPos, this.method_37908().method_8320(blockPos)));
                    }
                    if (blockEntities.containsKey(entry.getKey())) {
                        class_2586 blockEntity = method_37908().method_8321(blockPos);
                        if (blockEntity != null) {
                            class_2487 tag = blockEntities.get(entry.getKey());
                            blockEntity.method_58690(tag, method_56673());
                            ((MovableBlockEntityMixin) blockEntity).setPos(blockPos);
                        }
                    }
                    blocks.remove(entry.getKey());
                    blockEntities.remove(entry.getKey());
                    skipped = 0;
                    break;
                }
                skipped++;
            }
            if (skipped == 0) {
                retries = 0;
            }
        }

        if (retries > 0) {
            blocks.forEach((blockPos, state) -> this.method_5706(state.method_26204()));
        }
        setBlockMap(blocks);
    }

    private boolean done() {
        if (method_37908().field_9236) {
            return false;
        }
        class_2586 blockEntity = method_37908().method_8321(getPulleyPos());
        if (blockEntity instanceof PulleyBlockEntity pulleyBlockEntity) {
            if (!pulleyBlockEntity.onJobCompleted(method_37908(), getPulleyPos(), method_37908().method_8320(getPulleyPos()), isMovingUp(), getTargetY())) {
                reconstruct();
                return true;
            }
            return false;
        }
        // The block entity has been lost, abort
        reconstruct();
        this.method_31472();
        return true;
    }

    public Map<class_2382, class_2680> addBlock(class_2382 offset, class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = world.method_8321(pos);
        Map<class_2382, class_2680> blocks = getBlockMap();
        Map<class_2382, class_2487> blockEntities = getBlockEntityNbtMap();
        blocks.put(offset, state);
        if (blockEntity != null) {
            class_2487 tag = blockEntity.method_38242(method_56673());
            blockEntities.put(offset, tag);
            world.method_8544(pos);
            setBlockEntityNbtMap(blockEntities);
        }
        if (!world.field_9236) {
            setBlockMap(blocks);
        }
        return blocks;
    }

    @Override
    protected boolean method_5818(class_1297 passenger) {
        return false;
    }

    public boolean isPathBlocked() {
        HashSet<class_2338> blocked = new HashSet<>();
        getBlockMap().forEach((offset, state) -> {
            if (state.method_27852(BwtBlocks.anchorBlock) && (!blocked.isEmpty() || isMovingUp())) {
                return;
            }
            class_2338 pos = this.getPulleyPos().method_10087(this.getPulleyPos().method_10264() - getTargetY()).method_10081(offset);
            pos = isMovingUp() ? pos.method_10084() : pos.method_10074();

            class_2680 placementState = method_5770().method_8320(pos);

            if (!(placementState.method_26164(class_3481.field_51989) || placementState.method_45474())) {
                blocked.add(pos);
            }
        });
        return !blocked.isEmpty();
    }
}
