package com.bwt.entities;

import com.bwt.items.BwtItems;
import com.bwt.utils.rectangular_entity.EntityRectDimensions;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.util.math.*;
import java.util.function.Predicate;

public class WaterWheelEntity extends HorizontalMechPowerSourceEntity {
    public static final float height = 4.8f;
    public static final float width = 4.8f;
    public static final float length = 0.8f;

    public WaterWheelEntity(class_1299<? extends WaterWheelEntity> entityType, class_1937 world) {
        super(entityType, world);

    }

    public WaterWheelEntity(class_1937 world, class_243 pos, class_2350 facing) {
        super(BwtEntities.waterWheelEntity, world, pos, facing);
    }

    @Override
    public EntityRectDimensions getRectDimensions() {
        return EntityRectDimensions.fixed(WaterWheelEntity.width, WaterWheelEntity.height, WaterWheelEntity.length);
    }

    @Override
    public boolean tryToSpawn(class_1657 player) {
        return super.tryToSpawn(
                player,
                class_2561.method_30163("Not enough room to place Water Wheel"),
                class_2561.method_30163("Water Wheel placement is obstructed by something, or by you")
        );
    }

    @Override
    public boolean method_5640(double distance) {
        double d = 128.0 * method_5824();
        return distance < d * d;
    }

    @Override
    public Predicate<class_2338> getBlockInterferencePredicate() {
        return blockPos -> !method_37908().method_8320(blockPos).method_26164(class_3481.field_51989) && !method_37908().method_8316(blockPos).method_15767(class_3486.field_15517);
    }

    @Override
    float getSpeedToPowerThreshold() {
        return 0.75f;
    }

    @Override
    public float computeRotation() {
//        return Math.min(1, Math.max(getClockwiseRotationForce(), -1));
        return getCounterClockwiseRotationVelocity();
    }

    protected float getCounterClockwiseRotationVelocity() {
        class_1937 world = method_37908();
        class_2382 facingVector = method_5735().method_10163();
        float velocity = class_2338.method_29715(method_5829())
            .map(blockPos -> {
               class_3610 fluidState = world.method_8316(blockPos);
               if (!fluidState.method_15767(class_3486.field_15517)) {
                   return 0f;
               }
               class_243 fluidVelocity = fluidState.method_15758(world, blockPos);
               if (fluidState.method_28498(class_3609.field_15902) && fluidState.method_11654(class_3609.field_15902)) {
                   fluidVelocity = new class_243(fluidVelocity.method_10216(), -1, fluidVelocity.method_10215());
               }
               class_241 fluidVelocity2d = new class_241(
                       (float) (fluidVelocity.method_10216() * Math.abs(facingVector.method_10260()) + fluidVelocity.method_10215() * Math.abs(facingVector.method_10263())),
                       (float) fluidVelocity.method_10214()
               );
               class_243 centerToPointVector = blockPos.method_46558().method_1020(method_19538());
               // This vector isn't to the edge of the whole water wheel, but to the application of force
               // The addition of X and Z here is possible since only one will be non-zero
               class_241 centerToPointVector2d = new class_241((float) (centerToPointVector.method_10216() + centerToPointVector.method_10215()), (float) centerToPointVector.method_10214());
               // Tangent vector, clockwise along the circle, normalized to 1 magnitude
               class_241 tangentUnitVector = new class_241(centerToPointVector2d.field_1342, -centerToPointVector2d.field_1343).method_35581();
               // Component of fluid velocity along clockwise tangent unit vector
               return fluidVelocity2d.method_35583(tangentUnitVector);
            })
            .reduce(Float::sum)
            .orElse(0f);
        // Correct for facing directions
        velocity *= (facingVector.method_10263() - facingVector.method_10260());
        // Clamp
        return class_3532.method_15363(velocity, -1, 1);
    }


    @Override
    public class_1799 method_31480() {
        return new class_1799(BwtItems.waterWheelItem);
    }
}
