package com.bwt.entities;

import com.bwt.blocks.AxleBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.GearBoxBlock;
import com.bwt.items.BwtItems;
import com.bwt.tags.BwtBlockTags;
import com.bwt.utils.rectangular_entity.EntityRectDimensions;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;

public class WindmillEntity extends HorizontalMechPowerSourceEntity {
    public static final int NUM_SAILS = 4;

    public static final float height = 12.8f;
    public static final float width = 12.8f;
    public static final float length = 0.8f;

    private static final float rotationPerTick = -0.12F;
    private static final float rotationPerTickInStorm = -2.0F;
    private static final float rotationPerTickInNether = -0.07F;
    private static final int secondsInStormBeforeOverpower = 30;

    protected static final class_2940<Integer> dyeIndex = class_2945.method_12791(WindmillEntity.class, class_2943.field_13327);
    protected static final List<class_2940<Integer>> sailColors = IntStream.range(0, NUM_SAILS).mapToObj(i ->
            class_2945.method_12791(WindmillEntity.class, class_2943.field_13327)).collect(Collectors.toList());
    protected int overpowerTimer = 0;

    public WindmillEntity(class_1299<? extends WindmillEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public WindmillEntity(class_1937 world, class_243 pos, class_2350 facing) {
        super(BwtEntities.windmillEntity, world, pos, facing);
    }

    @Override
    public EntityRectDimensions getRectDimensions() {
        return EntityRectDimensions.fixed(WindmillEntity.width, WindmillEntity.height, WindmillEntity.length);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(dyeIndex, 0);
        sailColors.forEach(bladeColor -> builder.method_56912(bladeColor, class_1767.field_7952.method_7789()));
    }

    public class_1767 getSailColor(int index) {
        return class_1767.method_7791(field_6011.method_12789(sailColors.get(index)));
    }

    public void setSailColor(int index, class_1767 dyeColor) {
        field_6011.method_12778(sailColors.get(index), dyeColor.method_7789());
    }

    @Override
    public boolean tryToSpawn(class_1657 player) {
        return super.tryToSpawn(
                player,
                class_2561.method_30163("Not enough room to place Wind Mill (They are friggin HUGE!)"),
                class_2561.method_30163("Wind Mill placement is obstructed by something, or by you")
        );
    }

    @Override
    public boolean method_5640(double distance) {
        double d = 128.0 * method_5824();
        return distance < d * d;
    }

    @Override
    public Predicate<class_2338> getBlockInterferencePredicate() {
        return blockPos -> !method_37908().method_8320(blockPos).method_26164(class_3481.field_51989);
    }

    @Override
    float getSpeedToPowerThreshold() {
        return 0.01f;
    }

    @Override
    public float computeRotation() {
        class_1937 world = method_37908();
        // Nether
        if (world.method_8597().comp_644()) {
            return rotationPerTickInNether;
        }
        // End dimension or modded
        else if (!world.method_8597().comp_645()) {
            return 0.0f;
        }
        // Overworld, sky blocked
        else if (!world.method_8311(method_24515())) {
            return 0.0f;
        }
        // Overworld, storming
        else if (world.method_8419() && world.method_8546()) {
            return rotationPerTickInStorm;
        }
        // Overworld, not raining
        return rotationPerTick;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (!(stackInHand.method_7909() instanceof class_1769 dyeItem)) {
            return super.method_5688(player, hand);
        }

        class_1767 dyeColor = dyeItem.method_7802();
        int dyeIdx = method_5841().method_12789(dyeIndex);
        if (dyeColor.equals(getSailColor(dyeIdx))) {
            method_5841().method_12778(dyeIndex, (dyeIdx + 1) % NUM_SAILS);
            return class_1269.field_5812;
        }
        this.setSailColor(dyeIdx, dyeColor);
        method_5841().method_12778(dyeIndex, (dyeIdx + 1) % NUM_SAILS);
        if (!player.method_31549().field_7477) {
            stackInHand.method_7934(1);
        }
        return class_1269.field_5812;
    }

    @Override
    protected void fullUpdate() {
        super.fullUpdate();
        if (Math.abs(getRotationSpeed()) < Math.abs(rotationPerTickInStorm)) {
            overpowerTimer = 0;
            return;
        }
        overpowerTimer++;
        if (overpowerTimer >= secondsInStormBeforeOverpower) {
            breakConnectedGearBoxes();
        }
    }

    protected void breakConnectedGearBoxes() {
        class_2338 hostAxlePos = method_24515();
        class_2680 hostAxleState = method_37908().method_8320(hostAxlePos);

        // Bad block type
        if (!hostAxleState.method_27852(BwtBlocks.axleBlock) && !hostAxleState.method_27852(BwtBlocks.axlePowerSourceBlock)) {
            return;
        }
        class_2350.class_2351 hostAxleAxis = hostAxleState.method_11654(AxleBlock.field_11459);
        for (class_2350.class_2352 axisDirection : class_2350.class_2352.values()) {
            for (int i = 1; i <= 4; i++) {
                class_2350 direction = class_2350.method_10169(hostAxleAxis, axisDirection);
                class_2338 connectedPos = hostAxlePos.method_10079(direction, i);
                class_2680 connectedState = method_37908().method_8320(connectedPos);
                if (
                        connectedState.method_26204() instanceof GearBoxBlock gearBoxBlock
                        // Receiving power from this axle
                        && connectedState.method_11654(GearBoxBlock.field_10927).equals(direction.method_10153())
                        // Not switched off
                        && gearBoxBlock.isMechPowered(connectedState)
                ) {
                    GearBoxBlock.breakGearBox(method_37908(), connectedPos);
                    break;
                }
                if (!connectedState.method_27852(BwtBlocks.axleBlock) && !connectedState.method_27852(BwtBlocks.axlePowerSourceBlock)) {
                    break;
                }
                if (!connectedState.method_11654(AxleBlock.field_11459).equals(hostAxleAxis)) {
                    break;
                }
            }
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("dyeIndex", field_6011.method_12789(dyeIndex));
        for (int i = 0; i < NUM_SAILS; i++) {
            nbt.method_10569("sail" + i + "Color", field_6011.method_12789(sailColors.get(i)));
        }
        nbt.method_10569("overpowerTimer", overpowerTimer);
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        field_6011.method_12778(dyeIndex, nbt.method_10550("dyeIndex"));
        for (int i = 0; i < NUM_SAILS; i++) {
            if (nbt.method_10573("sail" + i + "Color", class_2487.field_33253)) {
                field_6011.method_12778(sailColors.get(i), nbt.method_10550("sail" + i + "Color"));
            }
        }
        overpowerTimer = nbt.method_10550("overpowerTimer");
    }

    @Override
    public class_1799 method_31480() {
        return new class_1799(BwtItems.windmillItem);
    }
}
