package com.bwt.generation;

import com.bwt.blocks.BwtBlocks;
import com.bwt.entities.BwtEntities;
import com.bwt.items.BwtItems;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.Id;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.advancement.*;
import net.minecraft.block.*;
import net.minecraft.class_161;
import net.minecraft.class_175;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_205;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_212;
import net.minecraft.class_2128;
import net.minecraft.class_2135;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4711;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import net.minecraft.predicate.item.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AdvancementsGenerator extends FabricAdvancementProvider {
    public static final class_2960 background = Id.mc("textures/gui/advancements/backgrounds/adventure.png");

    public AdvancementsGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    @Override
    public void generateAdvancement(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer) {
        class_8779 rootAdvancement = class_161.class_162.method_707()
                .method_697(
                        BwtBlocks.companionCubeBlock,
                        class_2561.method_43470("Better With Time"),
                        class_2561.method_43470("Made with love, and souls"),
                        background,
                        class_189.field_1254,
                        false,
                        false,
                        false
                )
                .method_705("active_immediately", class_2135.class_2137.method_49195())
                .method_694(consumer, Id.MOD_ID + "/root");
        class_8779 hempSeedsAdvancement = itemAdvancement(
                BwtItems.hempSeedsItem,
                "The Beginning",
                "Till grass to find hemp seeds"
        ).method_701(rootAdvancement).method_694(consumer, Id.MOD_ID + "/got_hemp_seeds");
        class_8779 hempFiberAdvancement = itemAdvancement(
                BwtItems.hempFiberItem,
                "Manual Labor",
                "Grind your first hemp by hand in a mill stone with a hand crank"
        ).method_701(hempSeedsAdvancement).method_694(consumer, Id.MOD_ID + "/got_hemp_fiber");
        class_8779 windmillAdvancement = class_161.class_162.method_707().method_701(hempFiberAdvancement)
                .method_697(
                        BwtItems.windmillItem,
                        class_2561.method_43470("Mechanical Age"),
                        class_2561.method_43470("Make space for your first windmill and place it on an axle"),
                        background,
                        class_189.field_1254,
                        true,
                        true,
                        false
                )
                .method_705("placed_windmill", class_2128.class_2130.method_9129(class_2048.class_2049.method_8916().method_8921(BwtEntities.windmillEntity)))
                .method_694(consumer, Id.MOD_ID + "/placed_windmill");

        class_8779 cauldronAdvancement = blockPlacedAdvancement(
                BwtBlocks.cauldronBlock,
                "Perpetual Stew",
                "Place a cauldron over some fire. Baby, you got a stew going!"
        ).method_701(rootAdvancement).method_694(consumer, Id.MOD_ID + "/placed_cauldron");
        class_8779 lightBlockAdvancement = itemAdvancement(
                BwtBlocks.lightBlockBlock,
                "Underground Grow Operation",
                "Create a light block. To hemp, it might as well be the sun"
        ).method_701(cauldronAdvancement).method_694(consumer, Id.MOD_ID + "/got_light_block");
        class_8779 dungAdvancement = itemAdvancement(
                BwtItems.dungItem,
                "The Stench of Progress",
                "Feed your pet wolf, and let nature take its course"
        ).method_701(cauldronAdvancement).method_694(consumer, Id.MOD_ID + "/got_dung");
        class_8779 tannedLeatherAdvancement = itemAdvancement(
                BwtItems.tannedLeatherItem,
                "Dung-Tanned",
                "Tan leather in the cauldron using dung"
        ).method_701(dungAdvancement).method_694(consumer, Id.MOD_ID + "/got_tanned_leather");
        class_8779 sawAdvancement = blockPlacedAdvancement(
                BwtBlocks.sawBlock,
                "DIY Carpentry",
                "Build and power a saw in pursuit of finer wood pieces"
        ).method_701(tannedLeatherAdvancement).method_694(consumer, Id.MOD_ID + "/placed_saw");
        class_8779 cornerAdvancement = itemTagAdvancement(
                BwtBlocks.cornerBlocks.stream().filter(cornerBlock -> cornerBlock.fullBlock == class_2246.field_10161).findFirst().orElseThrow(),
                BwtItemTags.WOODEN_CORNER_BLOCKS,
                "Cut my Block Into Pieces",
                "Use the saw to chop a plank down into corners. Maybe these smaller pieces can be used more efficiently!"
        ).method_701(sawAdvancement).method_694(consumer, Id.MOD_ID + "/got_wooden_corner");
        class_8779 hopperAdvancement = blockPlacedAdvancement(
                BwtBlocks.hopperBlock,
                "The Original Hopper",
                "Place your first mechanical hopper. It has a filter slot; what could that be for?"
        ).method_701(cornerAdvancement).method_694(consumer, Id.MOD_ID + "/placed_hopper");
        class_8779 hellfireDustAdvancement = itemAdvancement(
                BwtItems.hellfireDustItem,
                "Soul Extraction",
                "Extract the souls out of ground netherrack using a soul sand filtered hopper. Be sure to power the hopper to let them escape!"
        ).method_701(hopperAdvancement).method_694(consumer, Id.MOD_ID + "/got_hellfire_dust");
        class_8779 hibachiAdvancement = blockPlacedAdvancement(
                BwtBlocks.hibachiBlock,
                "Fire on Demand",
                "Concentrate hellfire dust in a cauldron, and make a hibachi grill for redstone-toggled fire"
        ).method_701(hellfireDustAdvancement).method_694(consumer, Id.MOD_ID + "/placed_hibachi");
        class_8779 bellowsAdvancement = blockPlacedAdvancement(
                BwtBlocks.bellowsBlock,
                "Inhale, Exhale, Repeat",
                "Build and power the bellows, to stoke the hibachi's fire even further. There's something about the timing..."
        ).method_701(sawAdvancement).method_694(consumer, Id.MOD_ID + "/placed_bellows");
        class_8779 turntableAdvancement = blockPlacedAdvancement(
                BwtBlocks.turntableBlock,
                "The Tables Have Turned",
                "Build and power the Turntable. Throw some clay on it to make pottery!"
        ).method_701(sawAdvancement).method_694(consumer, Id.MOD_ID + "/placed_turntable");
        class_8779 potteryAdvancement = itemAdvancement(
                BwtBlocks.unfiredCrucibleBlock,
                "Potter's Guild",
                "Spin your first piece of pottern on the Turntable. Next, into the Kiln!",
                BwtBlocks.unfiredDecoratedPotBlockWithSherds, BwtBlocks.unfiredDecoratedPotBlock, BwtBlocks.unfiredCrucibleBlock, BwtBlocks.unfiredPlanterBlock, BwtBlocks.unfiredVaseBlock, BwtBlocks.unfiredUrnBlock, BwtBlocks.unfiredFlowerPotBlock
        ).method_701(turntableAdvancement).method_694(consumer, Id.MOD_ID + "/got_pottery");
        class_8779 glueAdvancement = itemAdvancement(
                BwtItems.glueItem,
                "Animal Byproducts",
                "Render animal products into glue and tallow in a Cauldron above stoked fire",
                BwtItems.glueItem, BwtItems.tallowItem
        ).method_701(bellowsAdvancement).method_694(consumer, Id.MOD_ID + "/got_glue_or_tallow");
        class_8779 waterWheelAdvancement = class_161.class_162.method_707().method_701(glueAdvancement)
                .method_697(
                        BwtItems.waterWheelItem,
                        class_2561.method_43470("Mechanical Age 2"),
                        class_2561.method_43470("Harness more reliable mechanical power from a Water Wheel"),
                        background,
                        class_189.field_1254,
                        true,
                        true,
                        false
                )
                .method_705("placed_water_wheel", class_2128.class_2130.method_9129(class_2048.class_2049.method_8916().method_8921(BwtEntities.waterWheelEntity)))
                .method_694(consumer, Id.MOD_ID + "/placed_water_wheel");
        class_8779 kilnAdvancement = itemAdvancement(
                class_2246.field_10104,
                "Fired and Glazed",
                "Surround your pottery with enough brick blocks above a stoked fire, and it will harden into its final form! The kiln can cook other things, too.",
                class_2246.field_42752, BwtBlocks.crucibleBlock, BwtBlocks.planterBlock, BwtBlocks.vaseBlocks.get(class_1767.field_7952), BwtBlocks.urnBlock
        ).method_701(potteryAdvancement).method_694(consumer, Id.MOD_ID + "/kiln_fired");
        class_8779 soulUrnAdvancement = itemAdvancement(
                BwtItems.soulUrnItem,
                "Soul Containment",
                "Capture 8 souls released from a hopper in an urn placed below"
        ).method_701(hellfireDustAdvancement).method_694(consumer, Id.MOD_ID + "/got_soul_urn");
        class_8779 crucibleAdvancement = blockPlacedAdvancement(
                BwtBlocks.crucibleBlock,
                "Melt and Smelt",
                "Place a Crucible over stoked fire. It heats up hot enough to melt most metals"
        ).method_701(kilnAdvancement).method_694(consumer, Id.MOD_ID + "/placed_crucible");
        class_8779 netheriteAdvancement = itemAdvancement(
                class_1802.field_22020,
                "Soul-Forged Steel",
                "Smelt a netherite ingot in the crucible with iron, coal dust, gold, and a soul urn. Or find one in a loot chest, I guess"
        ).method_701(crucibleAdvancement).method_694(consumer, Id.MOD_ID + "/got_netherite_ingot");
        class_8779 soulForgeAdvancement = blockPlacedAdvancement(
                BwtBlocks.soulForgeBlock,
                "A New Age",
                "Place your first Soul Forge. It's better than an anvil!"
        ).method_701(netheriteAdvancement).method_694(consumer, Id.MOD_ID + "/placed_soul_forge");
    }

    public class_161.class_162 itemAdvancement(class_1935 displayItem, String title, String description, class_1935... items) {
        class_161.class_162 builder = class_161.class_162.method_707()
                .method_697(
                        displayItem, // The display icon
                        class_2561.method_43470(title), // The title
                        class_2561.method_43470(description), // The description
                        background, // Background image used
                        class_189.field_1254, // Options: TASK, CHALLENGE, GOAL
                        true, // Show toast top right
                        true, // Announce to chat
                        false // Hidden in the advancement tab
                )
                .method_704(class_8782.class_8797.field_1257);
        for (class_1935 item : items) {
            builder = builder.method_705("got_" + class_7923.field_41178.method_10221(item.method_8389()).method_12832(), class_2066.class_2068.method_8959(item));
        }
        return builder;
    }

    public class_161.class_162 itemAdvancement(class_1935 item, String title, String description) {
        return itemAdvancement(item, title, description, item);
    }

    public class_161.class_162 itemTagAdvancement(class_1935 displayItem, class_6862<class_1792> itemTag, String title, String description) {
        return class_161.class_162.method_707()
                .method_697(
                        displayItem, // The display icon
                        class_2561.method_43470(title), // The title
                        class_2561.method_43470(description), // The description
                        background, // Background image used
                        class_189.field_1254, // Options: TASK, CHALLENGE, GOAL
                        true, // Show toast top right
                        true, // Announce to chat
                        false // Hidden in the advancement tab
                )
                .method_705("got_" + itemTag.comp_327().method_12832(), class_2066.class_2068.method_53160(class_2073.class_2074.method_8973().method_8975(BwtItemTags.WOODEN_CORNER_BLOCKS)));
    }

    public class_161.class_162 blockPlacedAdvancement(class_2248 block, String title, String description, class_175<?> criterion) {
        return class_161.class_162.method_707()
                .method_697(
                        block.method_8389(), // The display icon
                        class_2561.method_43470(title), // The title
                        class_2561.method_43470(description), // The description
                        background, // Background image used
                        class_189.field_1254, // Options: TASK, CHALLENGE, GOAL
                        true, // Show toast top right
                        true, // Announce to chat
                        false // Hidden in the advancement tab
                )
                .method_705("place_" + class_7923.field_41175.method_10221(block).method_12832(), criterion);
    }

    public class_161.class_162 blockPlacedAdvancement(class_2248 block, String title, String description) {
        return blockPlacedAdvancement(block, title, description, class_4711.class_4712.method_51710(block));
    }

    public class_161.class_162 neighborStateAdvancement(
            class_2248 block,
            String title,
            String description,
            class_2350 direction,
            class_2090.class_2091 neighborStatePredicate
    ) {
        class_5341.class_210 thisCondition = class_212.method_900(block);
        class_5341.class_210 neighborCondition = class_205.method_30151(neighborStatePredicate, new class_2338(direction.method_10163()));
        class_175<class_4711.class_4712> criterion = class_4711.class_4712.method_51712(thisCondition, neighborCondition);
        return blockPlacedAdvancement(block, title, description, criterion);
    }
}
