package com.bwt.generation;

import com.bwt.blocks.*;
import com.bwt.tags.BwtBlockTags;
import com.bwt.tags.CompatibilityTags;
import com.bwt.utils.DyeUtils;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_3495;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class BlockTagGenerator extends FabricTagProvider.BlockTagProvider {
    public BlockTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, completableFuture);
    }

    public class_3495 method_27169(class_6862<class_2248> tag) {
        return super.method_27169(tag);
    }

    @Override
    protected void method_10514(class_7225.class_7874 arg) {
        method_10512(class_3481.field_51989).add(
                BwtBlocks.detectorLogicBlock,
                BwtBlocks.lensBeamBlock
        );
        method_10512(class_3481.field_44471).add(
                BwtBlocks.detectorLogicBlock,
                BwtBlocks.lensBeamBlock
        );
        method_10512(class_3481.field_15490).add(BwtBlocks.lensBeamGlassBlock);
        method_10512(ConventionalBlockTags.GLASS_BLOCKS).add(BwtBlocks.lensBeamGlassBlock);
        method_10512(class_3481.field_22414).add(BwtBlocks.ropeBlock);
        method_10512(class_3481.field_15463).add(BwtBlocks.stoneDetectorRailBlock, BwtBlocks.obsidianDetectorRailBlock);
        method_10512(class_3481.field_24076).add(BwtBlocks.obsidianPressurePlateBlock);
        method_10512(class_3481.field_15469).add(BwtBlocks.companionSlabBlock).add(BwtBlocks.wickerSlabBlock);

        // Make planters behave like their corresponding blocks
        method_10512(class_3481.field_29822).add(BwtBlocks.soilPlanterBlock, BwtBlocks.grassPlanterBlock);
        method_10512(class_3481.field_23119).add(BwtBlocks.soulSandPlanterBlock);
        method_10512(class_3481.field_23063).add(BwtBlocks.soulSandPlanterBlock);
        method_10512(BwtBlockTags.CROPS_CAN_PLANT_ON).add(class_2246.field_10362, BwtBlocks.soilPlanterBlock);
        method_10512(BwtBlockTags.SOUL_SAND_PLANTS_CAN_PLANT_ON).add(class_2246.field_10114, BwtBlocks.soulSandPlanterBlock);
        method_10512(BwtBlockTags.DOES_NOT_TRIGGER_BUDDY).add(
                class_2246.field_10091,
                class_2246.field_10523,
                class_2246.field_10301,
                class_2246.field_10450,
                class_2246.field_10377,
                BwtBlocks.buddyBlock,
                BwtBlocks.detectorLogicBlock
        );

        method_10512(BwtBlockTags.BLOCK_DISPENSER_INHALE_VOID)
                .add(class_2246.field_10316);
        method_10512(BwtBlockTags.BLOCK_DISPENSER_INHALE_NOOP)
                .add(class_2246.field_10369)
                .add(class_2246.field_10465)
                .add(class_2246.field_10379)
                .add(class_2246.field_10008)
                .add(class_2246.field_10027)
                .forceAddTag(class_3481.field_17754)
                .forceAddTag(class_3481.field_21952);
        method_10512(BwtBlockTags.DETECTABLE_SMALL_CROPS)
                .add(class_2246.field_10293)
                .add(class_2246.field_10609)
                .add(class_2246.field_10247);
        method_10512(BwtBlockTags.TRANSFERS_ROTATION_UPWARD_OVERRIDE)
                .forceAddTag(class_3481.field_15459)
                .forceAddTag(class_3481.field_15504)
                .forceAddTag(class_3481.field_15486)
                .add(class_2246.field_10114)
                .add(class_2246.field_37576)
                .add(class_2246.field_21211);
        method_10512(BwtBlockTags.NETHER_GROTH_CAN_EAT)
                .add(
                        class_2246.field_10559,
                        class_2246.field_10251,
                        class_2246.field_22121,
                        class_2246.field_22114,
                        class_2246.field_22123,
                        class_2246.field_22124,
                        class_2246.field_23078,
                        class_2246.field_23079,
                        class_2246.field_22125,
                        class_2246.field_22116,
                        class_2246.field_22117
                );
        method_10512(class_3481.field_25588).add(BwtBlocks.hibachiBlock);
        method_10512(class_3481.field_25589).add(BwtBlocks.hibachiBlock);
        method_10512(class_3481.field_25590).add(BwtBlocks.hibachiBlock);
        method_10512(class_3481.field_21952).add(BwtBlocks.stokedFireBlock);
        method_10512(class_3481.field_15481).add(BwtBlocks.companionCubeBlock);
        method_10512(BwtBlockTags.WOOL_SLABS).add(BwtBlocks.companionSlabBlock);

        addTools();
        addMaterialInheritedBlockTags();
        addVases();
        addWoolSlabs();
        addSawTags();
        addDirtSlabCompatibilityTags();
        addBloodWoodTags();
        addModCompatibilityTags();
    }

    private void addBloodWoodTags() {
        method_10512(BwtBlockTags.BLOOD_WOOD_LOGS).add(
                BwtBlocks.bloodWoodBlocks.logBlock,
                BwtBlocks.bloodWoodBlocks.woodBlock,
                BwtBlocks.bloodWoodBlocks.strippedLogBlock,
                BwtBlocks.bloodWoodBlocks.strippedWoodBlock
        );
        method_10512(BwtBlockTags.BLOOD_WOOD_PLANTABLE_ON).add(
                class_2246.field_10114,
                class_2246.field_22090,
                BwtBlocks.soulSandPlanterBlock
        );
        method_10512(class_3481.field_15475).forceAddTag(BwtBlockTags.BLOOD_WOOD_LOGS);
        method_10512(class_3481.field_15503).add(BwtBlocks.bloodWoodBlocks.leavesBlock);
        method_10512(class_3481.field_15462).add(BwtBlocks.bloodWoodBlocks.saplingBlock);
        method_10512(class_3481.field_15471).add(BwtBlocks.bloodWoodBlocks.planksBlock);
        method_10512(class_3481.field_15499).add(BwtBlocks.bloodWoodBlocks.buttonBlock);
        method_10512(class_3481.field_17619).add(BwtBlocks.bloodWoodBlocks.fenceBlock);
        method_10512(class_3481.field_25147).add(BwtBlocks.bloodWoodBlocks.fenceGateBlock);
        method_10512(class_3481.field_15477).add(BwtBlocks.bloodWoodBlocks.pressurePlateBlock);
        method_10512(class_3481.field_15468).add(BwtBlocks.bloodWoodBlocks.slabBlock);
        method_10512(class_3481.field_15502).add(BwtBlocks.bloodWoodBlocks.stairsBlock);
        method_10512(class_3481.field_15494).add(BwtBlocks.bloodWoodBlocks.doorBlock);
        method_10512(class_3481.field_15491).add(BwtBlocks.bloodWoodBlocks.trapdoorBlock);
    }

    private void addTools() {
        Stream.of(
                BwtBlocks.sidingBlocks.stream(),
                BwtBlocks.mouldingBlocks.stream(),
                BwtBlocks.cornerBlocks.stream(),
                BwtBlocks.columnBlocks.stream(),
                BwtBlocks.pedestalBlocks.stream(),
                BwtBlocks.tableBlocks.stream()
        )
                .reduce(Stream::concat).orElseGet(Stream::empty)
                .forEach(materialInheritedBlock -> method_10512(materialInheritedBlock.isWood() ? class_3481.field_33713 : class_3481.field_33715).add(materialInheritedBlock));

        method_10512(BwtBlockTags.MATTOCK_MINEABLE).forceAddTag(class_3481.field_33715).forceAddTag(class_3481.field_33716);
        method_10512(BwtBlockTags.BATTLEAXE_MINEABLE).forceAddTag(class_3481.field_33713).forceAddTag(class_3481.field_44469);
        method_10512(class_3481.field_33715)
                .add(BwtBlocks.anchorBlock)
                .add(BwtBlocks.blockDispenserBlock)
                .add(BwtBlocks.buddyBlock)
                .add(BwtBlocks.cauldronBlock)
                .add(BwtBlocks.concentratedHellfireBlock)
                .add(BwtBlocks.crucibleBlock)
                .add(BwtBlocks.detectorBlock)
                .add(BwtBlocks.handCrankBlock)
                .add(BwtBlocks.hibachiBlock)
//                .add(BwtBlocks.infernalEnchanterBlock)
                .add(BwtBlocks.kilnBlock)
                .add(BwtBlocks.lensBlock)
                .add(BwtBlocks.lightBlockBlock)
                .add(BwtBlocks.millStoneBlock)
                .add(BwtBlocks.obsidianDetectorRailBlock)
                .add(BwtBlocks.obsidianPressurePlateBlock)
//                .add(BwtBlocks.pedestalBlock)
                .add(BwtBlocks.planterBlock)
                .add(BwtBlocks.ropeBlock)
                .add(BwtBlocks.soapBlock)
                .add(BwtBlocks.soilPlanterBlock)
                .add(BwtBlocks.soulForgeBlock)
                .add(BwtBlocks.soulSandPlanterBlock)
                .add(BwtBlocks.grassPlanterBlock)
                .add(BwtBlocks.stoneDetectorRailBlock)
                .add(BwtBlocks.turntableBlock)
                .add(BwtBlocks.urnBlock);

        method_10512(class_3481.field_33716)
                .add(BwtBlocks.dungBlock)
                .add(BwtBlocks.unfiredDecoratedPotBlock)
                .add(BwtBlocks.unfiredDecoratedPotBlockWithSherds)
                .add(BwtBlocks.unfiredCrucibleBlock)
                .add(BwtBlocks.unfiredPlanterBlock)
                .add(BwtBlocks.unfiredVaseBlock)
                .add(BwtBlocks.unfiredUrnBlock)
                .add(BwtBlocks.unfiredFlowerPotBlock)
                .add(BwtBlocks.dirtSlabBlock)
                .add(BwtBlocks.dirtPathSlabBlock)
                .add(BwtBlocks.grassSlabBlock)
                .add(BwtBlocks.myceliumSlabBlock)
                .add(BwtBlocks.podzolSlabBlock);

        method_10512(class_3481.field_33713)
                .add(BwtBlocks.axleBlock)
                .add(BwtBlocks.axlePowerSourceBlock)
                .add(BwtBlocks.bellowsBlock)
                .add(BwtBlocks.bloodWoodBlocks.logBlock)
                .add(BwtBlocks.bloodWoodBlocks.strippedLogBlock)
                .add(BwtBlocks.bloodWoodBlocks.woodBlock)
                .add(BwtBlocks.bloodWoodBlocks.strippedWoodBlock)
                .add(BwtBlocks.bloodWoodBlocks.planksBlock)
                .add(BwtBlocks.bloodWoodBlocks.buttonBlock)
                .add(BwtBlocks.bloodWoodBlocks.fenceBlock)
                .add(BwtBlocks.bloodWoodBlocks.fenceGateBlock)
                .add(BwtBlocks.bloodWoodBlocks.pressurePlateBlock)
                .add(BwtBlocks.bloodWoodBlocks.slabBlock)
                .add(BwtBlocks.bloodWoodBlocks.stairsBlock)
                .add(BwtBlocks.bloodWoodBlocks.doorBlock)
                .add(BwtBlocks.bloodWoodBlocks.trapdoorBlock)
                .add(BwtBlocks.gearBoxBlock)
                .add(BwtBlocks.redstoneClutchBlock)
                .add(BwtBlocks.grateBlock)
                .add(BwtBlocks.hopperBlock)
                .add(BwtBlocks.platformBlock)
                .add(BwtBlocks.pulleyBlock)
                .add(BwtBlocks.ropeBlock)
                .add(BwtBlocks.ropeCoilBlock)
                .add(BwtBlocks.sawBlock)
                .add(BwtBlocks.slatsBlock)
                .add(BwtBlocks.soapBlock)
                .add(BwtBlocks.screwPumpBlock)
//                .add(BwtBlocks.tableBlock)
                .add(BwtBlocks.wickerBlock)
                .add(BwtBlocks.wickerSlabBlock)
                .add(BwtBlocks.wickerPaneBlock);

        method_10512(class_3481.field_33714)
                .add(BwtBlocks.bloodWoodBlocks.leavesBlock)
                .add(BwtBlocks.paddingBlock);

        // Where do these go?
//        .add(BwtBlocks.miningChargeBlock)
//        .add(BwtBlocks.netherGrothBlock)
//        .add(BwtBlocks.stakeBlock)

        method_10512(class_3481.field_44469).add(BwtBlocks.ropeBlock, BwtBlocks.hempCropBlock);
    }

    protected void addMaterialInheritedBlockTags() {
        FabricTagBuilder woodenSidingBuilder = method_10512(BwtBlockTags.WOODEN_SIDING_BLOCKS);
        FabricTagBuilder woodenMouldingBuilder = method_10512(BwtBlockTags.WOODEN_MOULDING_BLOCKS);
        FabricTagBuilder woodenCornerBuilder = method_10512(BwtBlockTags.WOODEN_CORNER_BLOCKS);
        FabricTagBuilder sidingBuilder = method_10512(BwtBlockTags.SIDING_BLOCKS);
        FabricTagBuilder mouldingBuilder = method_10512(BwtBlockTags.MOULDING_BLOCKS);
        FabricTagBuilder cornerBuilder = method_10512(BwtBlockTags.CORNER_BLOCKS);
        FabricTagBuilder woodenColumnBuilder = method_10512(BwtBlockTags.WOODEN_COLUMN_BLOCKS);
        FabricTagBuilder woodenPedestalBuilder = method_10512(BwtBlockTags.WOODEN_PEDESTAL_BLOCKS);
        FabricTagBuilder woodenTableBuilder = method_10512(BwtBlockTags.WOODEN_TABLE_BLOCKS);
        FabricTagBuilder columnBuilder = method_10512(BwtBlockTags.COLUMN_BLOCKS);
        FabricTagBuilder pedestalBuilder = method_10512(BwtBlockTags.PEDESTAL_BLOCKS);
        FabricTagBuilder tableBuilder = method_10512(BwtBlockTags.TABLE_BLOCKS);
        BwtBlocks.sidingBlocks.stream().filter(MaterialInheritedBlock::isWood).forEach(woodenSidingBuilder::add);
        BwtBlocks.mouldingBlocks.stream().filter(MaterialInheritedBlock::isWood).forEach(woodenMouldingBuilder::add);
        BwtBlocks.cornerBlocks.stream().filter(MaterialInheritedBlock::isWood).forEach(woodenCornerBuilder::add);
        BwtBlocks.columnBlocks.stream().filter(MaterialInheritedBlock::isWood).forEach(woodenColumnBuilder::add);
        BwtBlocks.pedestalBlocks.stream().filter(MaterialInheritedBlock::isWood).forEach(woodenPedestalBuilder::add);
        BwtBlocks.tableBlocks.stream().filter(MaterialInheritedBlock::isWood).forEach(woodenTableBuilder::add);
        sidingBuilder.method_26792(BwtBlockTags.WOODEN_SIDING_BLOCKS);
        mouldingBuilder.method_26792(BwtBlockTags.WOODEN_MOULDING_BLOCKS);
        cornerBuilder.method_26792(BwtBlockTags.WOODEN_CORNER_BLOCKS);
        columnBuilder.method_26792(BwtBlockTags.WOODEN_COLUMN_BLOCKS);
        pedestalBuilder.method_26792(BwtBlockTags.WOODEN_PEDESTAL_BLOCKS);
        tableBuilder.method_26792(BwtBlockTags.WOODEN_TABLE_BLOCKS);
        BwtBlocks.sidingBlocks.stream().filter(Predicate.not(MaterialInheritedBlock::isWood)).forEach(sidingBuilder::add);
        BwtBlocks.mouldingBlocks.stream().filter(Predicate.not(MaterialInheritedBlock::isWood)).forEach(mouldingBuilder::add);
        BwtBlocks.cornerBlocks.stream().filter(Predicate.not(MaterialInheritedBlock::isWood)).forEach(cornerBuilder::add);
        BwtBlocks.columnBlocks.stream().filter(Predicate.not(MaterialInheritedBlock::isWood)).forEach(columnBuilder::add);
        BwtBlocks.pedestalBlocks.stream().filter(Predicate.not(MaterialInheritedBlock::isWood)).forEach(pedestalBuilder::add);
        BwtBlocks.tableBlocks.stream().filter(Predicate.not(MaterialInheritedBlock::isWood)).forEach(tableBuilder::add);
    }

    private void addVases() {
        FabricTagBuilder vasesBuilder = method_10512(BwtBlockTags.VASES);
        DyeUtils.streamColorItemsSorted(BwtBlocks.vaseBlocks).forEach(vasesBuilder::add);
    }

    private void addWoolSlabs() {
        FabricTagBuilder woolSlabsBuilder = method_10512(BwtBlockTags.WOOL_SLABS);
        DyeUtils.streamColorItemsSorted(BwtBlocks.woolSlabBlocks).forEach(woolSlabsBuilder::add);
        method_10512(class_3481.field_15469).forceAddTag(BwtBlockTags.WOOL_SLABS);
    }

    protected void addSawTags() {
        method_10512(BwtBlockTags.SURVIVES_SAW_BLOCK)
                .add(BwtBlocks.companionSlabBlock)
                .add(class_2246.field_46287)
                .add(class_2246.field_46286)
                .add(class_2246.field_46285)
                .add(class_2246.field_46284)
                .add(class_2246.field_37575)
                .forceAddTag(class_3481.field_21952)
                .forceAddTag(class_3481.field_15462);

        method_10512(BwtBlockTags.SAW_BREAKS_DROPS_LOOT)
                .forceAddTag(class_3481.field_20339)
                .forceAddTag(class_3481.field_15503)
                .forceAddTag(class_3481.field_15494)
                .forceAddTag(class_3481.field_15491)
                .forceAddTag(class_3481.field_15499)
                .forceAddTag(class_3481.field_15477)
                .forceAddTag(class_3481.field_41282)
                .forceAddTag(class_3481.field_15501)
                .forceAddTag(class_3481.field_26984)
                .forceAddTag(class_3481.field_15483)
                .forceAddTag(class_3481.field_15483)
                .add(class_2246.field_10211)
                .add(class_2246.field_16328)
                .add(class_2246.field_20422)
                .add(class_2246.field_10341)
                .add(class_2246.field_28682)
                .add(class_2246.field_28683)
                .add(class_2246.field_10504)
                .add(class_2246.field_10029)
                .add(class_2246.field_10183)
                .add(class_2246.field_17350)
                .add(class_2246.field_10609)
                .add(class_2246.field_10147)
                .add(class_2246.field_10034)
                .add(class_2246.field_40276)
                .add(class_2246.field_10021)
                .add(class_2246.field_10343)
                .add(class_2246.field_10302)
                .add(class_2246.field_17563)
                .add(class_2246.field_9980)
                .add(class_2246.field_22121)
                .add(class_2246.field_28675)
                .add(class_2246.field_28676)
                .add(class_2246.field_10112)
                .add(class_2246.field_10009)
                .add(class_2246.field_10223)
                .add(class_2246.field_9993)
                .add(class_2246.field_10463)
                .add(class_2246.field_10313)
                .add(class_2246.field_16330)
                .add(class_2246.field_10588)
                .add(class_2246.field_37546)
                .add(class_2246.field_46283)
                .add(class_2246.field_10247)
                .add(class_2246.field_43228)
                .add(class_2246.field_43229)
                .add(class_2246.field_46282)
                .add(class_2246.field_10377)
                .add(class_2246.field_10450)
                .add(class_2246.field_10523)
                .add(class_2246.field_10301)
                .add(class_2246.field_10091)
                .add(class_2246.field_10476)
                .add(class_2246.field_10376)
                .add(class_2246.field_10479)
                .add(class_2246.field_28684)
                .add(class_2246.field_23860)
                .add(class_2246.field_22092)
                .add(class_2246.field_22093)
                .add(class_2246.field_28677)
                .add(class_2246.field_10424)
                .add(class_2246.field_10214)
                .add(class_2246.field_10238)
                .add(class_2246.field_10336)
                .add(class_2246.field_42734)
                .add(class_2246.field_42749)
                .add(class_2246.field_10380)
                .add(class_2246.field_10589)
                .add(class_2246.field_10195)
                .add(class_2246.field_23078)
                .add(class_2246.field_23079)
                .add(class_2246.field_10099)
                .add(class_2246.field_22114)
                .add(class_2246.field_22123)
                .add(class_2246.field_22124)
                .add(class_2246.field_10293)
                .add(BwtBlocks.axleBlock)
                .add(BwtBlocks.gearBoxBlock)
                .add(BwtBlocks.redstoneClutchBlock)
                .add(BwtBlocks.sawBlock)
                .add(BwtBlocks.grateBlock)
                .add(BwtBlocks.slatsBlock)
                .add(BwtBlocks.wickerPaneBlock)
                .add(BwtBlocks.hempCropBlock)
                .add(BwtBlocks.companionSlabBlock);
    }

    protected void addDirtSlabCompatibilityTags() {
        method_10512(BwtBlockTags.CAN_CONVERT_TO_PODZOL)
                .add(class_2246.field_10566)
                .add(class_2246.field_10219)
                .add(class_2246.field_10253)
                .add(class_2246.field_10402)
                .add(class_2246.field_28685)
                .add(class_2246.field_28681)
                .add(class_2246.field_37576)
                .add(class_2246.field_37547);
        method_10512(BwtBlockTags.CAN_CONVERT_TO_PODZOL_SLAB)
                .add(BwtBlocks.dirtSlabBlock)
                .add(BwtBlocks.grassSlabBlock)
                .add(BwtBlocks.myceliumSlabBlock);
    }

    protected void addModCompatibilityTags() {
        method_10512(CompatibilityTags.UNAFFECTED_BY_RICH_SOIL).add(BwtBlocks.hempCropBlock);
    }
}
