package com.bwt.generation;

import com.bwt.blocks.*;
import com.bwt.blocks.abstract_cooking_pot.AbstractCookingPotBlock;
import com.bwt.blocks.dirt_slab.DirtSlabBlock;
import com.bwt.blocks.lens.LensBeamBlock;
import com.bwt.blocks.turntable.TurntableBlock;
import com.bwt.blocks.unfired_pottery.UnfiredPotteryBlock;
import com.bwt.items.BwtItems;
import com.bwt.utils.DyeUtils;
import com.bwt.utils.Id;
import com.google.common.collect.ImmutableList;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1767;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.data.client.*;
import java.util.List;
import java.util.Optional;

public class ModelGenerator extends FabricModelProvider {
    public ModelGenerator(FabricDataOutput generator) {
        super(generator);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        generateDirtAndGrassSlab(blockStateModelGenerator);
        generateCompanionBlocks(blockStateModelGenerator);
        generateBloodWoodBlocks(blockStateModelGenerator);
        generateStokedFireBlock(blockStateModelGenerator);
        blockStateModelGenerator.method_25623(BwtBlocks.sawBlock, class_4941.method_25842(BwtBlocks.sawBlock));
        BwtBlocks.sidingBlocks.forEach(sidingBlock -> generateSidingBlock(blockStateModelGenerator, sidingBlock));
        BwtBlocks.mouldingBlocks.forEach(mouldingBlock -> generateMouldingBlock(blockStateModelGenerator, mouldingBlock));
        BwtBlocks.cornerBlocks.forEach(cornerBlock -> generateCornerBlock(blockStateModelGenerator, cornerBlock));
        BwtBlocks.columnBlocks.forEach(columnBlock -> generateColumnBlock(blockStateModelGenerator, columnBlock));
        BwtBlocks.pedestalBlocks.forEach(pedestalBlock -> generatePedestalBlock(blockStateModelGenerator, pedestalBlock));
        BwtBlocks.tableBlocks.forEach(tableBlock -> generateTableBlock(blockStateModelGenerator, tableBlock));
        BwtBlocks.vaseBlocks.values().forEach(vaseBlock -> generateVaseBlock(blockStateModelGenerator, vaseBlock));
        BwtBlocks.woolSlabBlocks.forEach((dyeColor, woolSlab) -> generateWoolSlab(blockStateModelGenerator, dyeColor, woolSlab));
        blockStateModelGenerator.method_25688(BwtBlocks.stoneDetectorRailBlock);
        blockStateModelGenerator.method_25688(BwtBlocks.obsidianDetectorRailBlock);
        blockStateModelGenerator.method_25600(BwtBlocks.slatsBlock);
        blockStateModelGenerator.method_25600(BwtBlocks.grateBlock);
        blockStateModelGenerator.method_25600(BwtBlocks.wickerPaneBlock);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        BwtBlocks.cauldronBlock,
                        class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(BwtBlocks.cauldronBlock))
                ).method_25775(class_4926.method_25783(AbstractCookingPotBlock.TIP_DIRECTION)
                        .method_25793(class_2350.field_11036, class_4935.method_25824())
                        .method_25793(class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891))
                        .method_25793(class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22893))
                        .method_25793(class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                        .method_25793(class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22893).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                )
        );
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        BwtBlocks.crucibleBlock,
                        class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(BwtBlocks.crucibleBlock))
                ).method_25775(class_4926.method_25783(AbstractCookingPotBlock.TIP_DIRECTION)
                        .method_25793(class_2350.field_11036, class_4935.method_25824())
                        .method_25793(class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891))
                        .method_25793(class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22893))
                        .method_25793(class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                        .method_25793(class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22893).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                )
        );
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        BwtBlocks.pulleyBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4943.field_22977.method_25846(
                                        BwtBlocks.pulleyBlock,
                                        class_4946.field_23040.get(BwtBlocks.pulleyBlock).method_25921().method_25868(class_4945.field_23015, class_4944.method_25866(BwtBlocks.pulleyBlock, "_side")),
                                        blockStateModelGenerator.field_22831
                                )
                        )
                )
        );
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769(BwtBlocks.turntableBlock)
                .method_25775(class_4926.method_25783(TurntableBlock.TICK_SETTING)
                        .method_25793(0, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25843(BwtBlocks.turntableBlock, "_0")))
                        .method_25793(1, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25843(BwtBlocks.turntableBlock, "_1")))
                        .method_25793(2, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25843(BwtBlocks.turntableBlock, "_2")))
                        .method_25793(3, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25843(BwtBlocks.turntableBlock, "_3")))
                )
        );
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        BwtBlocks.platformBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4941.method_25842(BwtBlocks.platformBlock)
                        )
                )
        );
        class_2960 bellowsId = class_4941.method_25842(BwtBlocks.bellowsBlock);
        class_2960 bellowsCompressedId = bellowsId.method_48331("_compressed");
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769(BwtBlocks.bellowsBlock)
                .method_25775(class_4926.method_25783(BellowsBlock.MECH_POWERED)
                        .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, bellowsCompressedId))
                        .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, bellowsId))
                )
                .method_25775(class_4910.method_25599())
        );
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.soulForgeBlock, class_4941.method_25842(BwtBlocks.soulForgeBlock))
                .method_25775(class_4910.method_25599())
        );
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.screwPumpBlock, class_4941.method_25842(BwtBlocks.screwPumpBlock))
                .method_25775(class_4910.method_25599())
        );

        blockStateModelGenerator.method_25540(BwtBlocks.unfiredDecoratedPotBlockWithSherds);
        for (UnfiredPotteryBlock unfiredPotteryBlock : new UnfiredPotteryBlock[]{BwtBlocks.unfiredDecoratedPotBlock, BwtBlocks.unfiredDecoratedPotBlockWithSherds, BwtBlocks.unfiredCrucibleBlock, BwtBlocks.unfiredPlanterBlock, BwtBlocks.unfiredVaseBlock, BwtBlocks.unfiredUrnBlock, BwtBlocks.unfiredFlowerPotBlock}) {
            blockStateModelGenerator.field_22830.accept(class_4925.method_25769(unfiredPotteryBlock)
                    .method_25775(class_4926.method_25783(UnfiredPotteryBlock.COOKING)
                            .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(unfiredPotteryBlock)))
                            .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(unfiredPotteryBlock).method_48331("_cooking")))
                    )
            );
        }
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769(BwtBlocks.urnBlock)
                .method_25775(class_4926.method_25783(UrnBlock.CONNECTED_UP)
                        .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(BwtBlocks.urnBlock)))
                        .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(BwtBlocks.urnBlock).method_48331("_connected_up")))
                )
        );
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.planterBlock, class_4941.method_25842(BwtBlocks.planterBlock)));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.soilPlanterBlock, class_4941.method_25842(BwtBlocks.soilPlanterBlock)));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.soulSandPlanterBlock, class_4941.method_25842(BwtBlocks.soulSandPlanterBlock)));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.grassPlanterBlock, class_4941.method_25842(BwtBlocks.grassPlanterBlock)));
        class_2960 buddyBlockModelId = class_4946.method_25918(block -> class_4944.method_25908(block).method_25868(class_4945.field_23015, class_4944.method_25866(block, "_side")), class_4943.field_22978)
                .method_25923(BwtBlocks.buddyBlock, blockStateModelGenerator.field_22831);
        class_2960 buddyBlockPoweredModelId = class_4946.method_25918(block -> new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866(block, "_side_powered")).method_25868(class_4945.field_23016, class_4944.method_25866(block, "_front_powered")).method_25868(class_4945.field_23015, class_4944.method_25866(block, "_side_powered")), class_4943.field_22978)
                .method_25922(BwtBlocks.buddyBlock, "_powered", blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(BwtBlocks.buddyBlock, class_4935.method_25824().method_25828(class_4936.field_22887, buddyBlockModelId))
                        .method_25775(class_4910.method_25565(BuddyBlock.POWERED, buddyBlockPoweredModelId, buddyBlockModelId))
                        .method_25775(class_4910.method_25640())
        );
        class_4946.method_25918(block -> class_4944.method_25908(block).method_25868(class_4945.field_23015, class_4944.method_25866(block, "_side")), class_4943.field_22978)
                .method_25923(BwtBlocks.soapBlock, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.method_25623(BwtBlocks.soapBlock, class_4941.method_25842(BwtBlocks.soapBlock));
        blockStateModelGenerator.method_25622(BwtBlocks.ropeCoilBlock, class_4946.field_23038);
        blockStateModelGenerator.method_25622(BwtBlocks.paddingBlock, class_4946.field_23036);
        blockStateModelGenerator.method_25622(BwtBlocks.wickerBlock, class_4946.field_23036);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25634(BwtBlocks.dungBlock, class_4941.method_25842(BwtBlocks.dungBlock)));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25668(
                BwtBlocks.wickerSlabBlock,
                class_4941.method_25842(BwtBlocks.wickerSlabBlock),
                class_4941.method_25843(BwtBlocks.wickerSlabBlock, "_top"),
                class_4941.method_25842(BwtBlocks.wickerBlock)
        ));
        generateMiningChargeBlock(blockStateModelGenerator);
        class_4946.method_25918(class_4944::method_25906, class_4943.field_22956)
                .method_25923(BwtBlocks.lensBlock, blockStateModelGenerator.field_22831);
        generateDebugLensBeam(blockStateModelGenerator);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644(BwtBlocks.lensBeamGlassBlock, class_4941.method_25842(class_2246.field_10033)));
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        BwtBlocks.aqueductBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4943.field_22977.method_25846(
                                        BwtBlocks.aqueductBlock,
                                        class_4946.field_23040.get(BwtBlocks.aqueductBlock).method_25921(),
                                        blockStateModelGenerator.field_22831
                                )
                        )
                )
        );

        blockStateModelGenerator.method_25623(BwtBlocks.aqueductBlock, class_4941.method_25842(BwtBlocks.aqueductBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.anchorBlock, class_4941.method_25842(BwtBlocks.anchorBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.axleBlock, class_4941.method_25842(BwtBlocks.axleBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.blockDispenserBlock, class_4941.method_25842(BwtBlocks.blockDispenserBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.cauldronBlock, class_4941.method_25842(BwtBlocks.cauldronBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.crucibleBlock, class_4941.method_25842(BwtBlocks.crucibleBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.detectorBlock, class_4941.method_25842(BwtBlocks.detectorBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.gearBoxBlock, class_4941.method_25842(BwtBlocks.gearBoxBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.screwPumpBlock, class_4941.method_25842(BwtBlocks.screwPumpBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.redstoneClutchBlock, class_4941.method_25842(BwtBlocks.redstoneClutchBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.handCrankBlock, class_4941.method_25842(BwtBlocks.handCrankBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.hibachiBlock, class_4941.method_25842(BwtBlocks.hibachiBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.hopperBlock, class_4941.method_25842(BwtBlocks.hopperBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.lensBlock, class_4941.method_25842(BwtBlocks.lensBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.lightBlockBlock, class_4941.method_25842(BwtBlocks.lightBlockBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.millStoneBlock, class_4941.method_25842(BwtBlocks.millStoneBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.obsidianPressurePlateBlock, class_4941.method_25842(BwtBlocks.obsidianPressurePlateBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.pulleyBlock, class_4941.method_25842(BwtBlocks.pulleyBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.turntableBlock, class_4941.method_25843(BwtBlocks.turntableBlock, "_0"));
        blockStateModelGenerator.method_25623(BwtBlocks.bellowsBlock, class_4941.method_25842(BwtBlocks.bellowsBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.unfiredDecoratedPotBlock, class_4941.method_25842(BwtBlocks.unfiredDecoratedPotBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.unfiredCrucibleBlock, class_4941.method_25842(BwtBlocks.unfiredCrucibleBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.unfiredPlanterBlock, class_4941.method_25842(BwtBlocks.unfiredPlanterBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.unfiredVaseBlock, class_4941.method_25842(BwtBlocks.unfiredVaseBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.unfiredUrnBlock, class_4941.method_25842(BwtBlocks.unfiredUrnBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.unfiredFlowerPotBlock, class_4941.method_25842(BwtBlocks.unfiredFlowerPotBlock));
        blockStateModelGenerator.method_25623(BwtBlocks.vineTrapBlock, class_4941.method_25842(BwtBlocks.vineTrapBlock));
        blockStateModelGenerator.method_25537(BwtBlocks.urnBlock.method_8389());
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(BwtItems.armorPlateItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.beltItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.breedingHarnessItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.broadheadItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.broadheadArrowItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.canvasItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.coalDustItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.concentratedHellfireItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.cementBucketItem, class_4943.field_22938);
        itemModelGenerator.method_25732(BwtItems.cookedWolfChopItem, class_1802.field_8261, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.donutItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.dungItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.dynamiteItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.fabricItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.filamentItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.flourItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.foulFoodItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.friedEggItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.gearItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.groundNetherrackItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.glueItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.haftItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.hempItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.hempFiberItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.hempSeedsItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.hellfireDustItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.kibbleItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.nethercoalItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.paddingItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.poachedEggItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.potashItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.rawEggItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.redstoneEyeItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.netheriteMattockItem, class_4943.field_22939);
        itemModelGenerator.method_25733(BwtItems.netheriteBattleAxeItem, class_4943.field_22939);
        itemModelGenerator.method_25733(BwtItems.ropeItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.rottedArrowItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.sawDustItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.sailItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.scouredLeatherItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.screwItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.soapItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.soulDustItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.soulUrnItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.strapItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.tallowItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.tannedLeatherItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.waterWheelItem, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.windmillItem, class_4943.field_22938);
        itemModelGenerator.method_25732(BwtItems.wolfChopItem, class_1802.field_8389, class_4943.field_22938);
        itemModelGenerator.method_25733(BwtItems.woodBladeItem, class_4943.field_22938);
    }

    private void generateBloodWoodBlocks(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25676(BwtBlocks.bloodWoodBlocks.logBlock).method_25730(BwtBlocks.bloodWoodBlocks.logBlock).method_25728(BwtBlocks.bloodWoodBlocks.woodBlock);
        blockStateModelGenerator.method_25676(BwtBlocks.bloodWoodBlocks.strippedLogBlock).method_25730(BwtBlocks.bloodWoodBlocks.strippedLogBlock).method_25728(BwtBlocks.bloodWoodBlocks.strippedWoodBlock);
        blockStateModelGenerator.method_25622(BwtBlocks.bloodWoodBlocks.leavesBlock, class_4946.field_23049);
        blockStateModelGenerator.method_25545(BwtBlocks.bloodWoodBlocks.saplingBlock, BwtBlocks.bloodWoodBlocks.pottedSaplingBlock, class_4910.class_4913.field_22840);
        blockStateModelGenerator.method_25650(BwtBlocks.bloodWoodBlocks.blockFamily.method_33469()).method_33522(BwtBlocks.bloodWoodBlocks.blockFamily);
    }

    private void generateCompanionBlocks(class_4910 blockStateModelGenerator) {
        class_2960 companionCubeModelId = class_4946.field_23042.method_25923(BwtBlocks.companionCubeBlock, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        BwtBlocks.companionCubeBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4941.method_25842(BwtBlocks.companionCubeBlock)
                        )
                ).method_25775(class_4910.method_25640())
        );
        class_2960 companionSlabBottom = class_4946.method_25918(
                block -> new class_4944()
                        .method_25868(class_4945.field_23014, class_4944.method_25866(BwtBlocks.companionCubeBlock, "_top"))
                        .method_25868(class_4945.field_23015, class_4944.method_25866(BwtBlocks.companionSlabBlock, "_top"))
                        .method_25868(class_4945.field_23018, class_4944.method_25866(BwtBlocks.companionCubeBlock, "_side"))
                , class_4943.field_22909
        ).method_25923(BwtBlocks.companionSlabBlock, blockStateModelGenerator.field_22831);
        class_2960 companionSlabTop = class_4946.method_25918(
                block -> new class_4944()
                        .method_25868(class_4945.field_23014, class_4944.method_25866(BwtBlocks.companionSlabBlock, "_top"))
                        .method_25868(class_4945.field_23015, class_4944.method_25866(BwtBlocks.companionCubeBlock, "_top"))
                        .method_25868(class_4945.field_23018, class_4944.method_25866(BwtBlocks.companionCubeBlock, "_side"))
                , class_4943.field_22910
        ).method_25923(BwtBlocks.companionSlabBlock, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25668(BwtBlocks.companionSlabBlock, companionSlabBottom, companionSlabTop, companionCubeModelId));
        blockStateModelGenerator.method_25623(BwtBlocks.companionSlabBlock, companionSlabBottom);
    }

    private void generateStokedFireBlock(class_4910 blockStateModelGenerator) {
        class_4942 tallFireFloorTemplate = new class_4942(Optional.of(Id.of("block/template_tall_fire_floor")), Optional.empty(), class_4945.field_23001);
        class_4942 shortFireFloorTemplate = new class_4942(Optional.of(Id.of("block/template_short_fire_floor")), Optional.empty(), class_4945.field_23001);
        class_4942 tallFireSideTemplate = new class_4942(Optional.of(Id.of("block/template_tall_fire_side")), Optional.empty(), class_4945.field_23001);
        class_4942 shortFireSideTemplate = new class_4942(Optional.of(Id.of("block/template_short_fire_side")), Optional.empty(), class_4945.field_23001);
        class_4942 tallFireSideAltTemplate = new class_4942(Optional.of(Id.of("block/template_tall_fire_side_alt")), Optional.empty(), class_4945.field_23001);
        class_4942 shortFireSideAltTemplate = new class_4942(Optional.of(Id.of("block/template_short_fire_side_alt")), Optional.empty(), class_4945.field_23001);
        class_4944 short0 = new class_4944().method_25868(class_4945.field_23001, class_4944.method_25866(BwtBlocks.stokedFireBlock, "_short_0"));
        class_4944 short1 = new class_4944().method_25868(class_4945.field_23001, class_4944.method_25866(BwtBlocks.stokedFireBlock, "_short_1"));
        List<class_2960> tallFloorIdentifiers = ImmutableList.of(
                tallFireFloorTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_tall_floor0"), class_4944.method_25902(BwtBlocks.stokedFireBlock), blockStateModelGenerator.field_22831),
                tallFireFloorTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_tall_floor1"), class_4944.method_25903(BwtBlocks.stokedFireBlock), blockStateModelGenerator.field_22831)
        );
        List<class_2960> shortFloorIdentifiers = ImmutableList.of(
                tallFireFloorTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_short_floor0"), short0, blockStateModelGenerator.field_22831),
                tallFireFloorTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_short_floor1"), short1, blockStateModelGenerator.field_22831)
        );
        List<class_2960> tallSideIdentifiers = ImmutableList.of(
                tallFireSideTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_tall_side0"), class_4944.method_25902(BwtBlocks.stokedFireBlock), blockStateModelGenerator.field_22831),
                tallFireSideTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_tall_side1"), class_4944.method_25903(BwtBlocks.stokedFireBlock), blockStateModelGenerator.field_22831),
                tallFireSideAltTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_tall_side_alt0"), class_4944.method_25902(BwtBlocks.stokedFireBlock), blockStateModelGenerator.field_22831),
                tallFireSideAltTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_tall_side_alt1"), class_4944.method_25903(BwtBlocks.stokedFireBlock), blockStateModelGenerator.field_22831)
        );
        List<class_2960> shortSideIdentifiers = ImmutableList.of(
                tallFireSideTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_short_side0"), short0, blockStateModelGenerator.field_22831),
                tallFireSideTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_short_side1"), short1, blockStateModelGenerator.field_22831),
                tallFireSideAltTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_short_side_alt0"), short0, blockStateModelGenerator.field_22831),
                tallFireSideAltTemplate.method_25852(class_4941.method_25843(BwtBlocks.stokedFireBlock, "_short_side_alt1"), short1, blockStateModelGenerator.field_22831)
        );
        class_4918 whenShort = class_4918.method_25744().method_25751(StokedFireBlock.TWO_HIGH, false);
        class_4918 whenTall = class_4918.method_25744().method_25751(StokedFireBlock.TWO_HIGH, true);
        blockStateModelGenerator.field_22830.accept(class_4922.method_25758(BwtBlocks.stokedFireBlock)
                .method_25761(whenShort, class_4910.method_25583(shortFloorIdentifiers, blockStateVariant -> blockStateVariant))
                .method_25761(whenTall, class_4910.method_25583(tallFloorIdentifiers, blockStateVariant -> blockStateVariant))
                .method_25761(whenShort, class_4910.method_25583(shortSideIdentifiers, blockStateVariant -> blockStateVariant))
                .method_25761(whenTall, class_4910.method_25583(tallSideIdentifiers, blockStateVariant -> blockStateVariant))
                .method_25761(whenShort, class_4910.method_25583(shortSideIdentifiers, blockStateVariant -> blockStateVariant.method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)))
                .method_25761(whenTall, class_4910.method_25583(tallSideIdentifiers, blockStateVariant -> blockStateVariant.method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)))
                .method_25761(whenShort, class_4910.method_25583(shortSideIdentifiers, blockStateVariant -> blockStateVariant.method_25828(class_4936.field_22886, class_4936.class_4937.field_22892)))
                .method_25761(whenTall, class_4910.method_25583(tallSideIdentifiers, blockStateVariant -> blockStateVariant.method_25828(class_4936.field_22886, class_4936.class_4937.field_22892)))
                .method_25761(whenShort, class_4910.method_25583(shortSideIdentifiers, blockStateVariant -> blockStateVariant.method_25828(class_4936.field_22886, class_4936.class_4937.field_22893)))
                .method_25761(whenTall, class_4910.method_25583(tallSideIdentifiers, blockStateVariant -> blockStateVariant.method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))));
    }

    private void generateMiningChargeBlock(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(BwtBlocks.miningChargeBlock, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(BwtBlocks.miningChargeBlock)))
                        .method_25775(class_4926
                                .method_25784(class_2741.field_12555, class_2741.field_12481)
                                .method_25797(class_2738.field_12473, class_2350.field_11043, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22892)
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                                .method_25797(class_2738.field_12473, class_2350.field_11034, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22892)
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                                .method_25797(class_2738.field_12473, class_2350.field_11035, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22892))
                                .method_25797(class_2738.field_12473, class_2350.field_11039, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22892)
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                                .method_25797(class_2738.field_12475, class_2350.field_11043, class_4935.method_25824())
                                .method_25797(class_2738.field_12475, class_2350.field_11034, class_4935.method_25824()
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                                .method_25797(class_2738.field_12475, class_2350.field_11035, class_4935.method_25824()
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                                .method_25797(class_2738.field_12475, class_2350.field_11039, class_4935.method_25824()
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                                .method_25797(class_2738.field_12471, class_2350.field_11043, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22891))
                                .method_25797(class_2738.field_12471, class_2350.field_11034, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22891)
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                                .method_25797(class_2738.field_12471, class_2350.field_11035, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22891)
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                                .method_25797(class_2738.field_12471, class_2350.field_11039, class_4935.method_25824()
                                        .method_25828(class_4936.field_22885, class_4936.class_4937.field_22891)
                                        .method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                        )
        );
    }

    public static void generateDebugLensBeam(class_4910 blockStateModelGenerator) {
        LensBeamBlock beam = BwtBlocks.lensBeamBlock;
        class_2960 identifier = class_4941.method_25842(beam);
        blockStateModelGenerator.field_22830.accept(
                class_4922
                        .method_25758(beam)
                        .method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.NORTH, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.EAST, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.SOUTH, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22886, class_4936.class_4937.field_22892)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.WEST, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.DOWN, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.UP, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22885, class_4936.class_4937.field_22893)
                        )
        );
    }

    public static void generateScrewPump(class_4910 blockStateModelGenerator) {
        ScrewPumpBlock screwPump = BwtBlocks.screwPumpBlock;
        class_2960 identifier = class_4941.method_25842(screwPump);
        blockStateModelGenerator.field_22830.accept(
                class_4922
                        .method_25758(screwPump)
                        .method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.NORTH, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.EAST, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.SOUTH, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22886, class_4936.class_4937.field_22892)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.WEST, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.DOWN, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22885, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(LensBeamBlock.UP, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier).method_25828(class_4936.field_22885, class_4936.class_4937.field_22893)
                        )
        );
    }

    public static void generatePaneBlock(class_4910 blockStateModelGenerator, class_2248 pane) {
        class_2960 identifier = class_4941.method_25843(pane, "_post_ends");
        class_2960 identifier2 = class_4941.method_25843(pane, "_post");
        class_2960 identifier3 = class_4941.method_25843(pane, "_cap");
        class_2960 identifier4 = class_4941.method_25843(pane, "_cap_alt");
        class_2960 identifier5 = class_4941.method_25843(pane, "_side");
        class_2960 identifier6 = class_4941.method_25843(pane, "_side_alt");
        blockStateModelGenerator.field_22830.accept(
                class_4922
                        .method_25758(pane)
                        .method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, identifier))
                        .method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12489, false).method_25751(class_2741.field_12487, false).method_25751(class_2741.field_12540, false).method_25751(class_2741.field_12527, false),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier2)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12489, true).method_25751(class_2741.field_12487, false).method_25751(class_2741.field_12540, false).method_25751(class_2741.field_12527, false),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier3)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12489, false).method_25751(class_2741.field_12487, true).method_25751(class_2741.field_12540, false).method_25751(class_2741.field_12527, false),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier3).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12489, false).method_25751(class_2741.field_12487, false).method_25751(class_2741.field_12540, true).method_25751(class_2741.field_12527, false),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier4)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12489, false).method_25751(class_2741.field_12487, false).method_25751(class_2741.field_12540, false).method_25751(class_2741.field_12527, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier4).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12489, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier5)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12487, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier5).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12540, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier6)
                        ).method_25760(
                                class_4918.method_25744().method_25751(class_2741.field_12527, true),
                                class_4935.method_25824().method_25828(class_4936.field_22887, identifier6).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891)
                        )
        );
        blockStateModelGenerator.method_25600(pane);
    }

    public static void generateSidingBlock(class_4910 blockStateModelGenerator, SidingBlock sidingBlock) {
        class_4946 texturedModel = class_4946.field_23036.get(sidingBlock.fullBlock);
        class_4942 model = new class_4942(Optional.of(Id.of("block/siding")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        model.method_25846(sidingBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        sidingBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4941.method_25842(sidingBlock)
                        ).method_25828(class_4936.field_22888, true)
                ).method_25775(class_4910.method_25640())
        );
        blockStateModelGenerator.method_25623(sidingBlock, class_4941.method_25842(sidingBlock));
    }

    public static void generateMouldingBlock(class_4910 blockStateModelGenerator, MouldingBlock mouldingBlock) {
        class_4946 texturedModel = class_4946.field_23036.get(mouldingBlock.fullBlock);
        class_4942 horizontalModel = new class_4942(Optional.of(Id.of("block/moulding")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        class_4942 verticalModel = new class_4942(Optional.of(Id.of("block/moulding_vertical")), Optional.of("_vertical"), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        class_2960 horizontalId = horizontalModel.method_25846(mouldingBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 verticalId = verticalModel.method_25846(mouldingBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4925.method_25769(mouldingBlock).method_25775(createMouldingOrientationMap(horizontalId, verticalId)));
        blockStateModelGenerator.method_25623(mouldingBlock, horizontalId);
    }

    public static void generateCornerBlock(class_4910 blockStateModelGenerator, CornerBlock cornerBlock) {
        class_4946 texturedModel = class_4946.field_23036.get(cornerBlock.fullBlock);
        class_4942 model = new class_4942(Optional.of(Id.of("block/corner")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        model.method_25846(cornerBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        cornerBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4941.method_25842(cornerBlock)
                        ).method_25828(class_4936.field_22888, true)
                ).method_25775(createCornerOrientationMap())
        );
        blockStateModelGenerator.method_25623(cornerBlock, class_4941.method_25842(cornerBlock));
    }

    public static void generateColumnBlock(class_4910 blockStateModelGenerator, ColumnBlock columnBlock) {
        class_4946 texturedModel = class_4946.field_23036.get(columnBlock.fullBlock);
        class_4942 model = new class_4942(Optional.of(Id.of("block/column")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        model.method_25846(columnBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770(columnBlock, class_4935.method_25824().method_25828(class_4936.field_22887, class_4941.method_25842(columnBlock)).method_25828(class_4936.field_22888, true)));
        blockStateModelGenerator.method_25623(columnBlock, class_4941.method_25842(columnBlock));
    }

    public static void generatePedestalBlock(class_4910 blockStateModelGenerator, PedestalBlock pedestalBlock) {
        class_4946 texturedModel = class_4946.field_23036.get(pedestalBlock.fullBlock);
        class_4942 model = new class_4942(Optional.of(Id.of("block/pedestal")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        model.method_25846(pedestalBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25770(
                        pedestalBlock,
                        class_4935.method_25824().method_25828(
                                class_4936.field_22887,
                                class_4941.method_25842(pedestalBlock)
                        ).method_25828(class_4936.field_22888, true)
                ).method_25775(class_4926.method_25783(PedestalBlock.VERTICAL_DIRECTION)
                        .method_25793(class_2350.field_11033, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892))
                        .method_25793(class_2350.field_11036, class_4935.method_25824())
                )
        );
        blockStateModelGenerator.method_25623(pedestalBlock, class_4941.method_25842(pedestalBlock));
    }

    public static void generateTableBlock(class_4910 blockStateModelGenerator, TableBlock tableBlock) {
        class_4946 texturedModel = class_4946.field_23036.get(tableBlock.fullBlock);
        class_4942 tableModel = new class_4942(Optional.of(Id.of("block/table")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        class_4942 tableNoSupportModel = new class_4942(Optional.of(Id.of("block/table_no_support")), Optional.empty(), class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
        class_2960 tableModelId = tableModel.method_25852(class_4941.method_25842(tableBlock), texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 noSupportModelId = tableNoSupportModel.method_25852(class_4941.method_25843(tableBlock, "_no_support"), texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25769(tableBlock)
                        .method_25775(class_4926.method_25783(TableBlock.SUPPORT)
                                .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, tableModelId))
                                .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, noSupportModelId))
                        )
        );
    }

    public void generateVaseBlock(class_4910 blockStateModelGenerator, VaseBlock vaseBlock) {
        class_2960 modelId = new class_4942(
                Optional.of(Id.of("block/vase")),
                Optional.empty(),
                class_4945.field_23012,
                class_4945.field_23015,
                class_4945.field_23018,
                class_4945.field_23014
        ).method_25852(
                class_4941.method_25842(vaseBlock),
                class_4944.method_25898(vaseBlock).method_25868(class_4945.field_23012, class_4944.method_25866(vaseBlock, "_side")
        ), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770(vaseBlock, class_4935.method_25824().method_25828(class_4936.field_22887, modelId)));
    }

    public void generateWoolSlab(class_4910 blockStateModelGenerator, class_1767 dyeColor, class_2482 woolSlabBlock) {
        class_2248 woolBlock = DyeUtils.WOOL_COLORS.get(dyeColor);
        class_2960 identifier = class_4941.method_25842(woolBlock);
        class_4946 texturedModel = class_4946.field_23036.get(woolBlock);
        class_2960 identifier2 = class_4943.field_22909.method_25846(woolSlabBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        class_2960 identifier3 = class_4943.field_22910.method_25846(woolSlabBlock, texturedModel.method_25921(), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25668(woolSlabBlock, identifier2, identifier3, identifier));
    }

    public static class_4926 createUpDefaultRotationStates() {
        return class_4926.method_25783(class_2741.field_12525)
                .method_25793(class_2350.field_11033, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892))
                .method_25793(class_2350.field_11036, class_4935.method_25824())
                .method_25793(class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891))
                .method_25793(class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22893))
                .method_25793(class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                .method_25793(class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891));
    }

    public static class_4926 createMouldingOrientationMap(class_2960 horizontalId, class_2960 verticalId) {
        return class_4926.method_25783(MouldingBlock.ORIENTATION)
                // horizontal, bottom - west, north, east, south
                .method_25793(0, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(1, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                .method_25793(2, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true))
                .method_25793(3, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                // vertical - west, north, east, south
                .method_25793(4, class_4935.method_25824().method_25828(class_4936.field_22887, verticalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(5, class_4935.method_25824().method_25828(class_4936.field_22887, verticalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                .method_25793(6, class_4935.method_25824().method_25828(class_4936.field_22887, verticalId).method_25828(class_4936.field_22888, true))
                .method_25793(7, class_4935.method_25824().method_25828(class_4936.field_22887, verticalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                // horizontal, top - west, north, east, south
                .method_25793(8, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22885, class_4936.class_4937.field_22892))
                .method_25793(9, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22885, class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                .method_25793(10, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22885, class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(11, class_4935.method_25824().method_25828(class_4936.field_22887, horizontalId).method_25828(class_4936.field_22888, true).method_25828(class_4936.field_22885, class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893));
    }

    public static class_4926 createCornerOrientationMap() {
        return class_4926.method_25783(CornerBlock.ORIENTATION)
                // bottom - south-west, north-west, north-east, south-east
                .method_25793(0, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                .method_25793(1, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(2, class_4935.method_25824().method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))
                .method_25793(3, class_4935.method_25824())
                // top - south-west, north-west, north-east, south-east
                .method_25793(4, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892))
                .method_25793(5, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
                .method_25793(6, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
                .method_25793(7, class_4935.method_25824().method_25828(class_4936.field_22885, class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893));
    }

    public void generateDirtAndGrassSlab(class_4910 blockStateModelGenerator) {
        //Dirt Slab
        class_4946 dirtTexturedModel = class_4946.field_23036.get(class_2246.field_10566);
        class_2960 dirtTexture = dirtTexturedModel.method_25921().method_25867(class_4945.field_23010);
        class_2960 dirtSlab = class_4946.method_25918(
                block -> new class_4944()
                        .method_25868(class_4945.field_23014, dirtTexture)
                        .method_25868(class_4945.field_23015, dirtTexture)
                        .method_25868(class_4945.field_23018, dirtTexture),
                class_4943.field_22909
        ).method_25923(BwtBlocks.dirtSlabBlock, blockStateModelGenerator.field_22831);
        class_2960 snowyDirtSlab = Id.of("block/snowy_dirt_slab");
        class_2960 dirtPathSlab = Id.of("block/dirt_path_slab");
        class_2960 grassSlab = Id.of("block/grass_slab");
        class_2960 snowyGrassSlab = Id.of("block/snowy_grass_slab");
        class_2960 myceliumSlab = Id.of("block/mycelium_slab");
        class_2960 snowyMyceliumSlab = Id.of("block/snowy_mycelium_slab");
        class_2960 podzolSlab = Id.of("block/podzol_slab");
        class_2960 snowyPodzolSlab = Id.of("block/snowy_podzol_slab");

        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25769(BwtBlocks.dirtSlabBlock)
                        .method_25775(
                                class_4926.method_25783(DirtSlabBlock.SNOWY)
                                        .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, snowyDirtSlab))
                                        .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, dirtSlab))
                        )

        );

        //Grass Slab
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25769(BwtBlocks.grassSlabBlock)
                        .method_25775(
                                class_4926.method_25783(DirtSlabBlock.SNOWY)
                                        .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, snowyGrassSlab))
                                        .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, grassSlab))
                        )
        );
        //Mycelium Slab
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25769(BwtBlocks.myceliumSlabBlock)
                        .method_25775(
                                class_4926.method_25783(DirtSlabBlock.SNOWY)
                                        .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, snowyMyceliumSlab))
                                        .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, myceliumSlab))
                        )
        );
        //Podzol Slab
        blockStateModelGenerator.field_22830.accept(
                class_4925.method_25769(BwtBlocks.podzolSlabBlock)
                        .method_25775(
                                class_4926.method_25783(DirtSlabBlock.SNOWY)
                                        .method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, snowyPodzolSlab))
                                        .method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, podzolSlab))
                        )
        );
        //Dirt Path Slab
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770(BwtBlocks.dirtPathSlabBlock, class_4935.method_25824().method_25828(class_4936.field_22887, dirtPathSlab)));
    }

}
