package com.bwt.generation;

import com.bwt.items.BwtItems;
import com.bwt.utils.Id;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2246;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class VanillaRecipeGenerator extends FabricRecipeProvider {
    public VanillaRecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    @Override
    public void method_10419(class_8790 exporter) {
        // The detector rail recipe needs to be entirely replaced with no option of re-insertion,
        // since we need it to use the wooden plate. So it goes in the MC namespace
        class_2447.method_10436(class_7800.field_40636, class_2246.field_10025, 6)
                .method_10439("i i")
                .method_10439("ipi")
                .method_10439("iri")
                .method_10434('i', class_1802.field_8620)
                .method_10433('p', class_3489.field_15540)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(class_2246.field_10167), method_10426(class_2246.field_10167))
                .method_17972(exporter, class_7923.field_41178.method_10221(class_1802.field_8211));

        // Bread is a separate recipe that doesn't overwrite anything, so it goes in BWT namespace
        // There's a DisabledRecipe for the vanilla bread recipe that can be toggled independently of this
        class_2454.method_17802(
                class_1856.method_8091(BwtItems.flourItem),
                class_7800.field_40640,
                class_1802.field_8229,
                0.35f,
                200
        )
                .method_10469(class_2446.method_32807(BwtItems.flourItem), class_2446.method_10426(BwtItems.flourItem))
                .method_17972(exporter, Id.of(class_7923.field_41178.method_10221(class_1802.field_8229).method_12832()));

        // Hopper recipe is getting overridden here via a disabled recipe + BWT recipe
        // so a modpack maker could re-enable the vanilla one and still keep the BWT one
        class_2447.method_10436(class_7800.field_40636, class_2246.field_10312, 2)
                .method_10434('C', class_2246.field_10034)
                .method_10434('N', class_1802.field_22020)
                .method_10439("N N")
                .method_10439("NCN")
                .method_10439(" N ")
                .method_10429(class_2446.method_32807(class_1802.field_22020), class_2446.method_10426(class_1802.field_22020))
                .method_17972(exporter, Id.of(class_7923.field_41178.method_10221(class_1802.field_8239).method_12832()));
    }

    // Don't enforce the ID into any specific namespace
    @Override
    protected class_2960 getRecipeIdentifier(class_2960 identifier) {
        return identifier;
    }
}
