package com.bwt.items;

import com.bwt.blocks.AxlePowerSourceBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.entities.HorizontalMechPowerSourceEntity;
import net.minecraft.class_1269;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5712;

public class HorizontalMechPowerSourceItem extends class_1792 {
    protected HorizontalMechPowerSourceEntity.Factory entityFactory;

    public HorizontalMechPowerSourceItem(HorizontalMechPowerSourceEntity.Factory entityFactory, class_1792.class_1793 settings) {
        super(settings);
        this.entityFactory = entityFactory;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_2338 blockPos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockPos);
        if (!blockState.method_27852(BwtBlocks.axleBlock)) {
            return class_1269.field_5814;
        }

        class_2350.class_2351 axleAxis = blockState.method_11654(AxlePowerSourceBlock.field_11459);
        if (axleAxis.method_10178()) {
            return class_1269.field_5814;
        }

        class_243 middleOfAxle = blockPos.method_46558();
        class_243 playerPos = context.method_8036().method_19538();
        class_243 difference = playerPos.method_1020(middleOfAxle);
        class_2350 placementDirection = class_2350.method_10169(
                axleAxis,
                axleAxis.method_10172(difference.method_10216(), difference.method_10214(), difference.method_10215()) > 0
                        ? class_2350.class_2352.field_11056
                        : class_2350.class_2352.field_11060
        );

        HorizontalMechPowerSourceEntity mechPowerSourceEntity = entityFactory.create(world, middleOfAxle, placementDirection);

        if (!mechPowerSourceEntity.tryToSpawn(context.method_8036())) {
            return class_1269.field_5814;
        }
        if (context.method_8036() instanceof class_3222 serverPlayerEntity) {
            class_174.field_1182.method_9124(serverPlayerEntity, mechPowerSourceEntity);
            world.method_33596(serverPlayerEntity, class_5712.field_28738, blockPos);
        }
        context.method_8041().method_7934(1);
        return class_1269.field_5812;
    }
}
