package com.bwt.mixin;

import com.bwt.blocks.mining_charge.ICaughtFireBlock;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.block.*;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2680;
import net.minecraft.class_4770;
import net.minecraft.class_5819;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_2358.class)
public abstract class FireBlockMixin extends class_4770 {
    public FireBlockMixin(class_2251 settings, float damage) {
        super(settings, damage);
    }

    @Inject(
            method = "trySpreadingFire",
            at = @At(
                    value = "JUMP",
                    opcode = Opcodes.IFEQ,  // Targets the jump that exits the if block
                    shift = At.Shift.BEFORE
            ),
            slice = @Slice(
                    from = @At(value = "INVOKE", target = "Ljava/util/Random;nextInt(I)I"),
                    to = @At(value = "RETURN")
            ),
            locals = LocalCapture.CAPTURE_FAILSOFT
    )
    public void onCaughtFire(class_1937 world, class_2338 pos, int spreadFactor, class_5819 random, int currentAge, CallbackInfo ci, @Local class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block instanceof ICaughtFireBlock caught) {
            caught.onCaughtFire(blockState, world, pos, null, null);
        }
    }
}
