package com.bwt.mixin;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.mining_charge.MiningChargeExplosion;
import com.bwt.tags.BwtItemTags;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1927;

@Mixin(class_1297.class)
public abstract class MiningChargeExplosionImmunityMixin {
    @Inject(method = "isImmuneToExplosion", at = @At("HEAD"), cancellable = true)
    public void bwt$isImmuneToExplosion(class_1927 explosion, CallbackInfoReturnable<Boolean> cir) {
        if (!(explosion instanceof MiningChargeExplosion)) {
            return;
        }
        if (!((class_1297) ((Object) this) instanceof class_1542 itemEntity)) {
            return;
        }
        if (itemEntity.method_6983().method_31573(BwtItemTags.MINING_CHARGE_IMMUNE)) {
            cir.setReturnValue(true);
            return;
        }
    }
}
