package com.bwt.mixin.animals;

import com.bwt.entities.GoToAndPickUpBreedingItemGoal;
import com.bwt.entities.PickUpBreedingItemWhileSittingGoal;
import com.bwt.entities.WolfIsFedAccess;
import com.bwt.items.BwtItems;
import com.bwt.mixin.accessors.MobEntityAccessorMixin;
import com.bwt.sounds.BwtSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4174;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1493.class)
public abstract class WolfEntityMixin extends class_1321 implements MobEntityAccessorMixin, WolfIsFedAccess {
    protected WolfEntityMixin(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Unique
    private static final class_2940<Boolean> IS_FED = class_2945.method_12791(WolfEntityMixin.class, class_2943.field_13323);


    @Inject(method = "initDataTracker", at = @At("TAIL"))
    public void initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(IS_FED, false);
    }

    @Inject(method = "writeCustomDataToNbt", at = @At("TAIL"))
    public void bwt$writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("IsFed", this.bwt$isFed());
    }

    @Inject(method = "readCustomDataFromNbt", at = @At("TAIL"))
    public void bwt$readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("IsFed")) {
            this.bwt$setIsFed(nbt.method_10577("IsFed"));
        }
    }

    @Inject(method = "initGoals", at = @At("TAIL"))
    public void addGoal(CallbackInfo ci) {
        this.getGoalSelector().method_6277(1, new PickUpBreedingItemWhileSittingGoal(
                this,
                1.7,
                wolf -> !wolf.method_5841().method_12789(IS_FED) || wolf.method_6032() < wolf.method_6063(),
                this::bwt$feed
        ));
        this.getGoalSelector().method_6277(7, new GoToAndPickUpBreedingItemGoal(
                this,
                8,
                1.8,
                1,
                wolf -> !wolf.method_5841().method_12789(IS_FED) || wolf.method_6032() < wolf.method_6063(),
                this::bwt$feed
        ));
    }

    @Inject(method = "interactMob", at = @At("HEAD"), cancellable = true)
    public void interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemStack = player.method_5998(hand);
        if (!this.method_6109() && this.method_6181() && this.method_6481(itemStack) && !bwt$isFed()) {
            if (this.method_37908().method_8608()) {
                cir.setReturnValue(class_1269.field_21466);
                return;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.bwt$feed(itemStack);
            cir.setReturnValue(class_1269.method_29236(this.method_37908().method_8608()));
        }
    }

    @Inject(method = "isBreedingItem", at = @At("HEAD"), cancellable = true)
    public void isBreedingItem(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.method_31574(BwtItems.kibbleItem)) {
            cir.setReturnValue(true);
            return;
        }
        if (stack.method_31574(class_1802.field_8511) || stack.method_31574(BwtItems.wolfChopItem) || stack.method_31574(BwtItems.cookedWolfChopItem)) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method = "tick", at = @At("TAIL"))
    public void tick(CallbackInfo ci) {
        class_1937 world = method_37908();
        class_5819 random = world.method_8409();
        if (world.field_9236) {
            return;
        }
        if (method_6109() || !bwt$isFed()) {
            return;
        }
        // A wolf produces dung on average every 20 minutes if in the light
        // This check represents once every 10 minutes, to be further filtered by the darkness check
        if (random.method_43048(24000) >= 2) {
            return;
        }
        if (!this.bwt$isInTheDark() && !random.method_43056()) {
            return;
        }
        if (attemptProduceDung()) {
            this.bwt$setIsFed(false);
        }
    }

    @Unique
    public boolean attemptProduceDung() {
        class_1937 world = method_37908();
        class_5819 random = method_59922();
        
        double dungVectorX = Math.sin(Math.toRadians(method_5791()));
        double dungVectorZ = -Math.cos(Math.toRadians(method_5791()));

        double dungPosX = method_23317() + dungVectorX;
        double dungPosY = method_23318() + 0.25D;
        double dungPosZ = method_23321() + dungVectorZ;
        class_2338 dungBlockPos = class_2338.method_49637(dungPosX, dungPosY, dungPosZ);

        if (!isPathToBlockOpenToDung(dungBlockPos))
        {
            return false;
        }

        class_1542 itemEntity = new class_1542(world, dungPosX, dungPosY, dungPosZ, new class_1799(BwtItems.dungItem));
        float velocityFactor = 0.05F;

        itemEntity.method_18800(
                dungVectorX * 10.0f * velocityFactor,
                (float)random.method_43059() * velocityFactor + 0.2F,
                dungVectorZ * 10.0f * velocityFactor
        );
        itemEntity.method_6982(10);
        world.method_8649(itemEntity);
        world.method_45445(this, method_24515(), BwtSoundEvents.WOLF_DUNG_PRODUCTION, method_5634(), 0.2f, 1.25f);
        world.method_45445(this, method_24515(), BwtSoundEvents.WOLF_DUNG_EFFORT, method_5634(), method_6107(), (random.method_43057() - random.method_43057()) * 0.2F + 1.0F);
        
        for (int counter = 0; counter < 5; counter++) {
            double smokeX = method_23317() + (dungVectorX * 0.5f) + (random.method_43058() * 0.25F);
            double smokeY = method_23318() + random.method_43058() * 0.5F + 0.25F;
            double smokeZ = method_23321() + (dungVectorZ * 0.5f) + (random.method_43058() * 0.25F);
            world.method_8406(class_2398.field_11251, smokeX, smokeY, smokeZ, 0D, 0D, 0D);
        }

        return true;
    }

    @Unique
    protected boolean isPathToBlockOpenToDung(class_2338 dungBlockPos) {
        if (!bwt$isBlockOpenToDung(dungBlockPos.method_10263(), dungBlockPos.method_10264(), dungBlockPos.method_10260())) {
            return false;
        }

        int wolfX = class_3532.method_15357(method_23317());
        int wolfZ = class_3532.method_15357(method_23321());

        int deltaX = dungBlockPos.method_10263() - wolfX;
        int deltaZ = dungBlockPos.method_10260() - wolfZ;

        if (deltaX != 0 && deltaZ != 0) {
            // we're producing dung on a diagonal. Test to make sure that we're not warping dung through blocked off corners
            return bwt$isBlockOpenToDung(wolfX, dungBlockPos.method_10264(), dungBlockPos.method_10260()) || bwt$isBlockOpenToDung(dungBlockPos.method_10263(), dungBlockPos.method_10264(), wolfZ);
        }
        return true;
    }

    @Unique
    protected boolean bwt$isBlockOpenToDung(int x, int y, int z) {
        class_1937 world = method_37908();
        class_2680 blockState = world.method_8320(new class_2338(x, y, z));
        class_3610 fluidState = world.method_8316(new class_2338(x, y, z));

        return !fluidState.method_15769() || blockState.method_26164(class_3481.field_21952) || blockState.method_45474();
    }

    @Override
    public boolean bwt$isFed() {
        return method_5841().method_12789(IS_FED);
    }

    @Unique
    public void bwt$setIsFed(boolean value) {
        method_5841().method_12778(IS_FED, value);
    }

    @Unique
    public void bwt$feed(int hungerValue) {
        bwt$setIsFed(bwt$isFed() || hungerValue > 0);
    }

    @Unique
    public void bwt$feed(class_1799 itemStack) {
        int nutrition = itemStack.method_31574(BwtItems.kibbleItem) ? 2 : itemStack.method_57825(class_9334.field_50075, new class_4174.class_4175().method_19242()).comp_2491();
        method_6025(nutrition * 2);
        bwt$feed(nutrition);
    }

    @Unique
    public boolean bwt$isInTheDark() {
        return method_37908().method_22339(method_24515()) < 5;
    }
}
