package com.bwt.models;

import com.bwt.entities.BroadheadArrowEntity;
import com.bwt.entities.DynamiteEntity;
import com.bwt.utils.Id;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import net.minecraft.client.render.entity.*;

@Environment(value= EnvType.CLIENT)
public class DynamiteEntityRenderer extends class_897<DynamiteEntity> {
    public static final class_2960 TEXTURE = Id.of("textures/item/dynamite.png");
    private final class_918 itemRenderer;
    private final float scale;
    private final boolean lit;

    public DynamiteEntityRenderer(class_5617.class_5618 ctx, float scale, boolean lit) {
        super(ctx);
        this.itemRenderer = ctx.method_32168();
        this.scale = scale;
        this.lit = lit;
    }

    public DynamiteEntityRenderer(class_5617.class_5618 context) {
        this(context, 1.0f, false);
    }

    @Override
    protected int getBlockLight(DynamiteEntity entity, class_2338 pos) {
        return this.lit ? 15 : super.method_24087(entity, pos);
    }

    @Override
    public void render(DynamiteEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (entity.field_6012 < 2 && this.field_4676.field_4686.method_19331().method_5858(entity) < 12.25) {
            return;
        }
        matrices.method_22903();
        matrices.method_22905(this.scale, this.scale, this.scale);
        matrices.method_22907(this.field_4676.method_24197());
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        int overlay = (entity.getFuse() / 5 % 2 == 0) ? class_4608.method_23625(class_4608.method_23210(1.0f), 10) : class_4608.field_21444;
        this.itemRenderer.method_23178(entity.method_7495(), class_811.field_4318, light, overlay, matrices, vertexConsumers, entity.method_37908(), entity.method_5628());
        matrices.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    @Override
    public class_2960 getTexture(DynamiteEntity entity) {
        return TEXTURE;
    }
}