package com.bwt.models;

import com.bwt.entities.HorizontalMechPowerSourceEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;

public abstract class HorizontalMechPowerSourceEntityRenderer<T extends HorizontalMechPowerSourceEntity> extends class_897<T> {
    protected HorizontalMechPowerSourceEntityModel<T> model;

    protected HorizontalMechPowerSourceEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Nullable
    protected class_1921 getRenderLayer(T entity) {
        class_2960 identifier = this.method_3931(entity);
        return this.model.method_23500(identifier);
    }

    @Override
    public void render(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumers, light);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(getRenderLayer(entity));
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40715.rotationDegrees(entity.method_36454()));
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_17821(tickDelta, entity.getPrevRotation(), entity.getRotation())));
        float p = (float)entity.getDamageWobbleTicks() - tickDelta;
        float q = Math.max(entity.getDamageWobbleStrength() - tickDelta, 0);
        if (p > 0.0f) {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374(p) * p * q / 10.0f * (float)entity.getDamageWobbleSide()));
        }
        this.model.render(entity, matrices, vertexConsumer, light, class_4608.method_23624(0.0f, false), -1);
        matrices.method_22909();
        matrices.method_22909();
    }
}
