package com.bwt.models;

import com.bwt.entities.WaterWheelEntity;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import java.util.ArrayList;
import java.util.List;

public class WaterWheelEntityModel extends HorizontalMechPowerSourceEntityModel<WaterWheelEntity> {
    protected static final int numBlades = 8;
    protected static final float strutDistanceFromCenter = 30.0f;
    private static final int strutLength = (int)( ( WaterWheelEntity.height * 8.0f ) - (strutDistanceFromCenter / 2.0f));
    private static final int bladeWidth = 2;

    private static final float bladeOffsetFromCenter = 2.5f;
    private static final int bladeLength = (int)( ( WaterWheelEntity.height * 8.0f ) - bladeOffsetFromCenter) + 1;
    private static final int strutWidth = 2;
    private static final int bladeDepth = 14;
    private static final int strutDepth = 12;

    private final List<class_630> blades = new ArrayList<>();
    private final List<class_630> struts = new ArrayList<>();

    public WaterWheelEntityModel(class_630 modelPart) {
        super();
        for (int bladeIdx = 0; bladeIdx < numBlades; bladeIdx++) {
            blades.add(modelPart.method_32086("blade" + bladeIdx));
            struts.add(modelPart.method_32086("strut" + bladeIdx));
        }
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        float localPi = 3.141593F;
        for (int i = 0; i < numBlades; i++) {
            modelPartData.method_32117("blade" + i,
                class_5606.method_32108()
                    .method_32101(0, 0)
                    .method_32097(bladeOffsetFromCenter, -(float) bladeWidth / 2.0f, -(float) bladeDepth / 2.0f,
                            bladeLength, bladeWidth, bladeDepth),
                class_5603.method_32092(0F, 0F, localPi * (float) i / 4.0F));
        }
        for (int i = 0; i < numBlades; i++ ) {
            float rotation = localPi * 0.25f * i;

            modelPartData.method_32117("strut" + i,
                class_5606.method_32108()
                    .method_32101(0, 15)
                    .method_32097(0, -(float) strutWidth / 2.0f, -(float) strutDepth / 2.0f,
                            strutLength, strutWidth, strutDepth),
                class_5603.method_32091(
                        ((float) (strutDistanceFromCenter * Math.cos(rotation))),
                        ((float) (strutDistanceFromCenter * Math.sin(rotation))),
                        0f,
                        0f,
                        0f,
                        (localPi * 0.625f) + (rotation)
                )
            );
        }
        return class_5607.method_32110(modelData, 64, 32);

    }

    @Override
    public void render(WaterWheelEntity entity, class_4587 matrixStack, class_4588 vertexConsumer, int light, int uv, int color) {
        blades.forEach(blade -> blade.method_22699(matrixStack, vertexConsumer, light, uv, color));
        struts.forEach(blade -> blade.method_22699(matrixStack, vertexConsumer, light, uv, color));
    }
}
