package com.bwt.models;

import com.bwt.entities.WindmillEntity;
import net.minecraft.class_1767;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class WindmillEntityModel extends HorizontalMechPowerSourceEntityModel<WindmillEntity> {

    private static final float bladeOffsetFromCenter = 15.0f;
    private static final int bladeLength = (int)( ( WindmillEntity.height * 8.0f ) - bladeOffsetFromCenter) - 3;
    private static final int bladeWidth = 16;

    private static final float shaftOffsetFromCenter = 2.5f;
    private static final int shaftLength = (int)( ( WindmillEntity.height * 8.0f ) - shaftOffsetFromCenter) - 2;
    private static final int shaftWidth = 4;

    private final List<class_630> sails;
    private final List<class_630> shafts;


    public WindmillEntityModel(class_630 modelPart) {
        super();
        shafts = IntStream.range(0, WindmillEntity.NUM_SAILS).mapToObj(i -> modelPart.method_32086("shaft" + i)).collect(Collectors.toList());
        sails = IntStream.range(0, WindmillEntity.NUM_SAILS).mapToObj(i -> modelPart.method_32086("sail" + i)).collect(Collectors.toList());
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        float localPi = 3.141593F;
        for (int i = 0; i < WindmillEntity.NUM_SAILS; i++) {
            modelPartData.method_32117("shaft" + i,
                class_5606.method_32108()
                    .method_32101(0, 0)
                    .method_32097(
                            shaftOffsetFromCenter,
                            -(float) shaftWidth / 2.0f,
                            -(float) shaftWidth / 2.0f,
                            shaftLength,
                            shaftWidth,
                            shaftWidth
                    ),
                class_5603.method_32092(0F, 0F, 2 * localPi * (i / (float)WindmillEntity.NUM_SAILS))
            );
        }
        for (int i = 0; i < WindmillEntity.NUM_SAILS; i++) {
            modelPartData.method_32117("sail" + i,
                class_5606.method_32108()
                    .method_32101(0, 15)
                    .method_32097(
                            bladeOffsetFromCenter,
                            1.75f,
                            1.0F,
                            bladeLength,
                            bladeWidth,
                            1
                    ),
                class_5603.method_32092(-localPi / 12.0F, 0F, 2 * localPi * (i / (float)WindmillEntity.NUM_SAILS))
            );
        }
        return class_5607.method_32110(modelData, 64, 32);
    }

    @Override
    public void render(WindmillEntity entity, class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        shafts.forEach(shaft -> shaft.method_22698(matrices, vertices, light, overlay));
        for (int i = 0; i < WindmillEntity.NUM_SAILS; i++) {
            class_630 sail = sails.get(i);
            class_1767 sailColor = entity.getSailColor(i);
            sail.method_22699(matrices, vertices, light, overlay, class_5253.class_5254.method_27763(color, sailColor.method_7787()));
        }
    }
}
