package com.bwt.recipes;

import com.bwt.utils.Id;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record BlockIngredient(Optional<class_6862<class_2248>> optionalBlockTagKey, Optional<class_2248> optionalBlock) implements CustomIngredient {
    public static final Serializer SERIALIZER = new Serializer();

    public static BlockIngredient fromBlock(class_2248 block) {
        return new BlockIngredient(Optional.empty(), Optional.of(block));
    }

    public static BlockIngredient fromTag(class_6862<class_2248> tagKey) {
        return new BlockIngredient(Optional.of(tagKey), Optional.empty());
    }

    @Override
    public boolean test(class_1799 stack) {
        if (stack.method_7909() instanceof class_1747 blockItem) {
            return test(blockItem.method_7711());
        }
        return false;
    }

    public boolean test(class_2248 block) {
        return optionalBlockTagKey.filter(blockTagKey -> block.method_9564().method_26164(blockTagKey)).isPresent()
                || optionalBlock.filter(block::equals).isPresent();
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        return List.of();
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer implements CustomIngredientSerializer<BlockIngredient> {
        private static final class_2960 ID = Id.of("block_ingredient");
        public static final MapCodec<BlockIngredient> CODEC = createCodec();
        public static final class_9139<class_9129, BlockIngredient> PACKET_CODEC = class_9139.method_56437(
                Serializer::write, Serializer::read
        );

        public static MapCodec<BlockIngredient> createCodec() {
            return RecordCodecBuilder.mapCodec(instance ->
                    instance.group(
                            class_6862.method_40093(class_7924.field_41254).optionalFieldOf("blockTag").forGetter(blockIngredient -> blockIngredient.optionalBlockTagKey),
                            class_7923.field_41175.method_39673().optionalFieldOf("block").forGetter(blockIngredient -> blockIngredient.optionalBlock)
                    ).apply(instance, BlockIngredient::new)
            );
        }

        @Override
        public class_2960 getIdentifier() {
            return ID;
        }


        @Override
        public class_9139<class_9129, BlockIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        @Override
        public MapCodec<BlockIngredient> getCodec(boolean allowEmpty) {
            return CODEC;
        }

        public static BlockIngredient read(class_9129 buf) {
            class_2960 blockTagKeyId = buf.method_10810();
            Optional<class_6862<class_2248>> blockTagKey = blockTagKeyId.method_12836().isBlank() ? Optional.empty() : Optional.of(class_6862.method_40092(class_7924.field_41254, blockTagKeyId));
            class_2960 blockId = buf.method_10810();
            class_2248 block = class_7923.field_41175.method_10223(blockId);
            return new BlockIngredient(blockTagKey, block.equals(class_2246.field_10124) ? Optional.empty() : Optional.of(block));
        }

        public static void write(class_9129 buf, BlockIngredient ingredient) {
            buf.method_10812(ingredient.optionalBlockTagKey.map(class_6862::comp_327).orElse(Id.of("", "")));
            buf.method_10812(ingredient.optionalBlock.map(class_7923.field_41175::method_10221).orElse(Id.of("", "")));
        }
    }
}
