package com.bwt.recipes.cooking_pots;

import com.bwt.recipes.IngredientWithCount;
import com.bwt.blocks.abstract_cooking_pot.AbstractCookingPotBlockEntity;
import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.utils.Id;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1747;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Collectors;

public abstract class AbstractCookingPotRecipe implements class_1860<CookingPotRecipeInput> {
    protected final AbstractCookingPotRecipeType type;
    protected final String group;
    protected final CookingPotRecipeCategory category;
    final class_2371<IngredientWithCount> ingredients;
    protected final class_2371<class_1799> results;

    public AbstractCookingPotRecipe(AbstractCookingPotRecipeType type, String group, CookingPotRecipeCategory category, List<IngredientWithCount> ingredients, List<class_1799> results) {
        this.type = type;
        this.group = group;
        this.category = category;
        this.ingredients = class_2371.method_10212(IngredientWithCount.EMPTY, ingredients.toArray(new IngredientWithCount[0]));
        this.results = class_2371.method_10212(class_1799.field_8037, results.toArray(new class_1799[0]));
    }

    @Override
    public boolean matches(CookingPotRecipeInput input, class_1937 world) {
        return ingredients.stream().allMatch(input::matches);
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_2371<class_1856> method_8117() {
        class_2371<class_1856> defaultedList = class_2371.method_10211();
        defaultedList.addAll(this.ingredients.stream().map(IngredientWithCount::toVanilla).toList());
        return defaultedList;
    }

    public class_2371<IngredientWithCount> getIngredientsWithCount() {
        return ingredients;
    }

    public List<class_1799> getResults() {
        return results.stream().map(class_1799::method_7972).collect(Collectors.toList());
    }

    @Override
    public String method_8112() {
        return this.group;
    }

    @Override
    public class_3956<?> method_17716() {
        return this.type;
    }

    public CookingPotRecipeCategory getCategory() {
        return this.category;
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public boolean method_49188() {
        return false;
    }


    @Override
    public class_1799 craft(CookingPotRecipeInput input, class_7225.class_7874 lookup) {
        return method_8110(lookup);
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return results.get(0);
    }

    public static class Serializer implements class_1865<AbstractCookingPotRecipe> {
        private final RecipeFactory<AbstractCookingPotRecipe> recipeFactory;
        public final MapCodec<AbstractCookingPotRecipe> CODEC;
        public final class_9139<class_9129, AbstractCookingPotRecipe> PACKET_CODEC;

        public Serializer(RecipeFactory<AbstractCookingPotRecipe> recipeFactory) {
            this.recipeFactory = recipeFactory;
            this.CODEC = RecordCodecBuilder.mapCodec(
                    instance->instance.group(
                            Codec.STRING.fieldOf("group")
                                    .forGetter(recipe -> recipe.group),
                            CookingPotRecipeCategory.CODEC.fieldOf("category")
                                    .orElse(CookingPotRecipeCategory.MISC)
                                    .forGetter(recipe -> recipe.category),
                            IngredientWithCount.Serializer.DISALLOW_EMPTY_CODEC.codec()
                                    .listOf()
                                    .fieldOf("ingredients")
                                    .forGetter(recipe -> recipe.ingredients),
                            class_1799.field_24671
                                    .listOf()
                                    .fieldOf("results")
                                    .forGetter(AbstractCookingPotRecipe::getResults)
                    ).apply(instance, recipeFactory::create)
            );
            this.PACKET_CODEC = class_9139.method_56437(
                    this::write, this::read
            );
        }

        @Override
        public MapCodec<AbstractCookingPotRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, AbstractCookingPotRecipe> method_56104() {
            return PACKET_CODEC;
        }

        protected AbstractCookingPotRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            CookingPotRecipeCategory category = buf.method_10818(CookingPotRecipeCategory.class);
            int ingredientsSize = buf.method_10816();
            class_2371<IngredientWithCount> ingredients = class_2371.method_10213(ingredientsSize, IngredientWithCount.EMPTY);
            ingredients.replaceAll(ignored -> IngredientWithCount.Serializer.read(buf));
            List<class_1799> results = class_1799.field_48350.decode(buf);
            return this.recipeFactory.create(group, category, ingredients, results);
        }

        protected void write(class_9129 buf, AbstractCookingPotRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817(recipe.category);
            buf.method_10804(recipe.ingredients.size());
            for (IngredientWithCount ingredient : recipe.ingredients) {
                IngredientWithCount.Serializer.write(buf, ingredient);
            }
            class_1799.field_48350.encode(buf, recipe.getResults());
        }
    }

    public interface RecipeFactory<T extends AbstractCookingPotRecipe> {
        T create(String group, CookingPotRecipeCategory category, List<IngredientWithCount> ingredients, List<class_1799> results);
    }

    public abstract static class JsonBuilder<T extends AbstractCookingPotRecipe>
            implements class_5797 {
        protected class_7800 category;
        protected CookingPotRecipeCategory cookingCategory;
        protected class_2371<IngredientWithCount> ingredients = class_2371.method_10211();
        protected class_2371<class_1799> results = class_2371.method_10211();
        protected final Map<String, class_175<?>> criteria = new LinkedHashMap<>();

        @Nullable
        protected String group;
        protected abstract RecipeFactory<T> getRecipeFactory();

        public JsonBuilder<T> category(class_7800 category) {
            this.category = category;
            return this;
        }

        public JsonBuilder<T> cookingCategory(CookingPotRecipeCategory cookingCategory) {
            this.cookingCategory = cookingCategory;
            return this;
        }

        public JsonBuilder<T> ingredients(IngredientWithCount... ingredients) {
            for (IngredientWithCount ingredient : ingredients) {
                this.ingredient(ingredient);
            }
            return this;
        }

        public JsonBuilder<T> ingredient(IngredientWithCount ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public JsonBuilder<T> ingredient(class_1799 itemStack) {
            this.method_33530(class_2446.method_32807(itemStack.method_7909()), class_2446.method_10426(itemStack.method_7909()));
            return this.ingredient(IngredientWithCount.fromStack(itemStack));
        }

        public JsonBuilder<T> ingredient(class_1792 item, int count) {
            return this.ingredient(new class_1799(item, count));
        }

        public JsonBuilder<T> ingredient(class_1792 item) {
            return this.ingredient(item, 1);
        }

        public JsonBuilder<T> ingredient(class_6862<class_1792> itemTag, int count) {
            this.method_33530("has_" + itemTag.comp_327().method_12832(), class_2446.method_10420(itemTag));
            return this.ingredient(IngredientWithCount.fromTag(itemTag, count));
        }

        public JsonBuilder<T> ingredient(class_6862<class_1792> itemTag) {
            return this.ingredient(itemTag, 1);
        }


        public JsonBuilder<T> results(class_1799... itemStacks) {
            this.results.addAll(Arrays.asList(itemStacks));
            return this;
        }

        public JsonBuilder<T> result(class_1799 itemStack) {
            this.results.add(itemStack);
            return this;
        }

        public JsonBuilder<T> result(class_1792 item, int count) {
            this.results.add(new class_1799(item, count));
            return this;
        }

        public JsonBuilder<T> result(class_1792 item) {
            return this.result(item, 1);
        }

        @Override
        public JsonBuilder<T> method_33530(String string, class_175<?> advancementCriterion) {
            this.criteria.put(string, advancementCriterion);
            return this;
        }

        @Override
        public JsonBuilder<T> method_33529(@Nullable String string) {
            this.group = string;
            return this;
        }

        protected boolean isDefaultRecipe;
        public JsonBuilder<T> markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }
        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        @Override
        public class_1792 method_36441() {
            return results.get(0).method_7909();
        }

        @Override
        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        @Override
        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.validate(recipeId);
            this.addToDefaults(recipeId);

            if (cookingCategory == null) {
                cookingCategory(getCookingPotRecipeCategory(results));
            }

            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeId)).method_703(class_170.class_171.method_753(recipeId)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach(advancementBuilder::method_705);
            AbstractCookingPotRecipe cookingPotRecipe = this.getRecipeFactory().create(
                    Objects.requireNonNullElse(this.group, ""),
                    this.cookingCategory,
                    this.ingredients,
                    this.results
            );
            exporter.method_53819(recipeId, cookingPotRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_46203() + "/")));
        }

        private static CookingPotRecipeCategory getCookingPotRecipeCategory(class_2371<class_1799> results) {
            if (results.stream().anyMatch(result -> result.method_7909() instanceof class_1747)) {
                return CookingPotRecipeCategory.BLOCKS;
            }
            return CookingPotRecipeCategory.MISC;
        }

        private void validate(class_2960 recipeId) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + recipeId);
            }
        }

    }


    public enum CookingPotRecipeCategory implements class_3542 {
        FOOD("food"),
        BLOCKS("blocks"),
        MISC("misc"),
        RECLAIM("reclaim");

        public static final class_3542.class_7292<CookingPotRecipeCategory> CODEC = class_3542.method_28140(CookingPotRecipeCategory::values);
        private final String id;

        private CookingPotRecipeCategory(final String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }
    }

}