package com.bwt.recipes.cooking_pots;

import com.bwt.recipes.IngredientWithCount;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_9695;

public record CookingPotRecipeInput(List<class_1799> items) implements class_9695 {
    @Override
    public class_1799 method_59984(int slot) {
        return items.get(slot);
    }

    @Override
    public int method_59983() {
        return items.size();
    }

    public boolean matches(IngredientWithCount ingredient) {
        return items.stream()
                .filter(stack -> ingredient.ingredient().method_8093(stack))
                .map(class_1799::method_7947)
                .reduce(Integer::sum)
                .orElse(0) >= ingredient.count();
    }
}
