package com.bwt.recipes.mill_stone;

import com.bwt.blocks.BwtBlocks;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.blocks.mill_stone.MillStoneBlockEntity;
import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.utils.Id;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class MillStoneRecipe implements class_1860<MillStoneRecipeInput> {
    protected final String group;
    protected final class_7710 category;
    final class_2371<IngredientWithCount> ingredients;
    protected final class_2371<class_1799> results;

    public MillStoneRecipe(String group, class_7710 category, List<IngredientWithCount> ingredients, List<class_1799> results) {
        this.group = group;
        this.category = category;
        this.ingredients = class_2371.method_10212(IngredientWithCount.EMPTY, ingredients.toArray(new IngredientWithCount[0]));
        this.results = class_2371.method_10212(class_1799.field_8037, results.toArray(new class_1799[0]));
    }

    @Override
    public class_1799 method_17447() {
        return new class_1799(BwtBlocks.millStoneBlock);
    }

    @Override
    public class_1865<?> method_8119() {
        return BwtRecipes.MILL_STONE_RECIPE_SERIALIZER;
    }

    @Override
    public boolean matches(MillStoneRecipeInput input, class_1937 world) {
        for (IngredientWithCount ingredient : ingredients) {
            Optional<Integer> matchingCount = input.items().stream()
                    .filter(stack -> ingredient.ingredient().method_8093(stack))
                    .map(class_1799::method_7947)
                    .reduce(Integer::sum);
            if (matchingCount.orElse(0) < ingredient.count()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_2371<class_1856> method_8117() {
        class_2371<class_1856> defaultedList = class_2371.method_10211();
        defaultedList.addAll(this.ingredients.stream().map(IngredientWithCount::toVanilla).toList());
        return defaultedList;
    }

    public class_2371<IngredientWithCount> getIngredientsWithCount() {
        return ingredients;
    }

    public List<class_1799> getResults() {
        return results.stream().map(class_1799::method_7972).collect(Collectors.toList());
    }

    @Override
    public String method_8112() {
        return this.group;
    }

    @Override
    public class_3956<?> method_17716() {
        return BwtRecipes.MILL_STONE_RECIPE_TYPE;
    }

    public class_7710 getCategory() {
        return this.category;
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public boolean method_49188() {
        return false;
    }

    @Override
    public class_1799 craft(MillStoneRecipeInput input, class_7225.class_7874 lookup) {
        return method_8110(lookup);
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 wrapperLookup) {
        return results.get(0);
    }

    public static class Serializer implements class_1865<MillStoneRecipe> {
        protected static final MapCodec<MillStoneRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance->instance.group(
                        Codec.STRING.optionalFieldOf("group", "")
                                .forGetter(recipe -> recipe.group),
                        class_7710.field_40252.fieldOf("category")
                                .orElse(class_7710.field_40251)
                                .forGetter(recipe -> recipe.category),
                        IngredientWithCount.Serializer.DISALLOW_EMPTY_CODEC.codec()
                                .listOf()
                                .fieldOf("ingredients")
                                .forGetter(recipe -> recipe.ingredients),
                        class_1799.field_24671
                                .listOf()
                                .fieldOf("results")
                                .forGetter(MillStoneRecipe::getResults)
                ).apply(instance, MillStoneRecipe::new)
        );
        public static final class_9139<class_9129, MillStoneRecipe> PACKET_CODEC = class_9139.method_56437(
                Serializer::write, Serializer::read
        );

        public Serializer() {
        }

        @Override
        public MapCodec<MillStoneRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, MillStoneRecipe> method_56104() {
            return PACKET_CODEC;
        }

        public static MillStoneRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = buf.method_10818(class_7710.class);
            int ingredientsSize = buf.method_10816();
            class_2371<IngredientWithCount> ingredients = class_2371.method_10213(ingredientsSize, IngredientWithCount.EMPTY);
            ingredients.replaceAll(ignored -> IngredientWithCount.Serializer.read(buf));
            List<class_1799> results = class_1799.field_48350.decode(buf);
            return new MillStoneRecipe(group, category, ingredients, results);
        }

        public static void write(class_9129 buf, MillStoneRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817(recipe.category);
            buf.method_10804(recipe.ingredients.size());
            for (IngredientWithCount ingredient : recipe.ingredients) {
                IngredientWithCount.Serializer.write(buf, ingredient);
            }
            class_1799.field_48350.encode(buf, recipe.getResults());
        }
    }

    public static class JsonBuilder implements class_5797 {
        protected class_7710 category = class_7710.field_40251;
        protected class_2371<IngredientWithCount> ingredients = class_2371.method_10211();
        protected class_2371<class_1799> results = class_2371.method_10211();
        protected final Map<String, class_175<?>> criteria = new LinkedHashMap<>();
        @Nullable
        protected String group;

        public static JsonBuilder create() {
            return new JsonBuilder();
        }

        public JsonBuilder category(class_7710 category) {
            this.category = category;
            return this;
        }

        public JsonBuilder ingredients(IngredientWithCount... ingredients) {
            for (IngredientWithCount ingredient : ingredients) {
                this.ingredient(ingredient);
            }
            return this;
        }

        public JsonBuilder ingredient(IngredientWithCount ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public JsonBuilder ingredient(class_1799 itemStack) {
            this.method_33530(class_2446.method_32807(itemStack.method_7909()), class_2446.method_10426(itemStack.method_7909()));
            return this.ingredient(IngredientWithCount.fromStack(itemStack));
        }

        public JsonBuilder ingredient(class_1792 item, int count) {
            return this.ingredient(new class_1799(item, count));
        }

        public JsonBuilder ingredient(class_1792 item) {
            return this.ingredient(item, 1);
        }

        public JsonBuilder results(class_1799... itemStacks) {
            this.results.addAll(Arrays.asList(itemStacks));
            return this;
        }

        public JsonBuilder result(class_1799 itemStack) {
            this.results.add(itemStack);
            return this;
        }

        public JsonBuilder result(class_1792 item, int count) {
            this.results.add(new class_1799(item, count));
            return this;
        }

        public JsonBuilder result(class_1792 item) {
            return this.result(item, 1);
        }

        @Override
        public JsonBuilder method_33530(String string, class_175<?> advancementCriterion) {
            this.criteria.put(string, advancementCriterion);
            return this;
        }

        @Override
        public JsonBuilder method_33529(@Nullable String string) {
            this.group = string;
            return this;
        }

        protected boolean isDefaultRecipe;
        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }
        public void addToDefaults(class_2960 recipeId) {
            if(this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        @Override
        public class_1792 method_36441() {
            return results.get(0).method_7909();
        }

        @Override
        public void method_10431(class_8790 exporter) {
            this.method_36443(exporter,
                    class_2446.method_33716(results.get(0).method_7909())
                    + "_from_milling_"
                    + class_2446.method_33716(this.ingredients.get(0).getMatchingStacks().get(0).method_7909())
            );
        }

        @Override
        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        @Override
        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.validate(recipeId);
            this.addToDefaults(recipeId);
            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeId)).method_703(class_170.class_171.method_753(recipeId)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach(advancementBuilder::method_705);
            MillStoneRecipe millStoneRecipe = new MillStoneRecipe(
                    Objects.requireNonNullElse(this.group, ""),
                    this.category,
                    this.ingredients,
                    this.results
            );
            exporter.method_53819(recipeId, millStoneRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_15434() + "/")));
        }

        private void validate(class_2960 recipeId) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + recipeId);
            }
        }
    }
}
