package com.bwt.recipes.soul_bottling;

import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.items.BwtItems;
import com.bwt.recipes.BlockIngredient;
import com.bwt.recipes.BwtRecipes;
import com.bwt.utils.Id;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record SoulBottlingRecipe(String group, class_7710 category, BlockIngredient bottle, int soulCount, class_1799 result) implements class_1860<SoulBottlingRecipeInput> {
    @Override
    public class_1799 method_17447() {
        return new class_1799(BwtItems.soulUrnItem);
    }

    @Override
    public class_1865<?> method_8119() {
        return BwtRecipes.SOUL_BOTTLING_RECIPE_SERIALIZER;
    }

    @Override
    public boolean matches(SoulBottlingRecipeInput input, class_1937 world) {
        return bottle.test(input.block());
    }

    @Override
    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public class_2371<class_1856> method_8117() {
        class_2371<class_1856> defaultedList = class_2371.method_10211();
        defaultedList.add(bottle.toVanilla());
        return defaultedList;
    }

    @Override
    public String method_8112() {
        return this.group;
    }

    @Override
    public class_3956<?> method_17716() {
        return BwtRecipes.SOUL_BOTTLING_RECIPE_TYPE;
    }

    @Override
    public boolean method_8118() {
        return class_1860.super.method_8118();
    }

    @Override
    public boolean method_49188() {
        return false;
    }

    @Override
    public class_1799 craft(SoulBottlingRecipeInput input, class_7225.class_7874 lookup) {
        return method_8110(lookup);
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 wrapperLookup) {
        return result;
    }

    public class_1799 getResult() {
        return result.method_7972();
    }

    public static class Serializer implements class_1865<SoulBottlingRecipe> {
        protected static final MapCodec<SoulBottlingRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance->instance.group(
                        Codec.STRING.optionalFieldOf("group", "")
                                .forGetter(SoulBottlingRecipe::group),
                        class_7710.field_40252.fieldOf("category")
                                .orElse(class_7710.field_40251)
                                .forGetter(SoulBottlingRecipe::category),
                        BlockIngredient.Serializer.CODEC
                                .fieldOf("bottle")
                                .forGetter(SoulBottlingRecipe::bottle),
                        Codec.INT.fieldOf("soulCount")
                                .forGetter(SoulBottlingRecipe::soulCount),
                        class_1799.field_49266
                                .fieldOf("result")
                                .forGetter(SoulBottlingRecipe::result)
                ).apply(instance, SoulBottlingRecipe::new)
        );
        public static final class_9139<class_9129, SoulBottlingRecipe> PACKET_CODEC = class_9139.method_56437(
                SoulBottlingRecipe.Serializer::write, SoulBottlingRecipe.Serializer::read
        );

        public Serializer() {
        }

        @Override
        public MapCodec<SoulBottlingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SoulBottlingRecipe> method_56104() {
            return PACKET_CODEC;
        }

        public static SoulBottlingRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = buf.method_10818(class_7710.class);
            BlockIngredient bottle = BlockIngredient.Serializer.PACKET_CODEC.decode(buf);
            int soulCount = buf.method_10816();
            class_1799 result = class_1799.field_48349.decode(buf);
            return new SoulBottlingRecipe(group, category, bottle, soulCount, result);
        }

        public static void write(class_9129 buf, SoulBottlingRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817(recipe.category);
            BlockIngredient.Serializer.PACKET_CODEC.encode(buf, recipe.bottle);
            buf.method_10804(recipe.soulCount);
            class_1799.field_48349.encode(buf, recipe.getResult());
        }
    }

    public static class JsonBuilder implements class_5797 {
        protected class_7710 category = class_7710.field_40251;
        protected BlockIngredient bottle;
        protected int soulCount;
        protected class_1799 result = class_1799.field_8037;
        @Nullable
        protected String group;

        public static SoulBottlingRecipe.JsonBuilder create() {
            return new SoulBottlingRecipe.JsonBuilder();
        }

        protected boolean isDefaultRecipe;
        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }
        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        public SoulBottlingRecipe.JsonBuilder category(class_7710 category) {
            this.category = category;
            return this;
        }

        public SoulBottlingRecipe.JsonBuilder bottle(BlockIngredient bottle) {
            this.bottle = bottle;
            return this;
        }

        public SoulBottlingRecipe.JsonBuilder bottle(class_2248 bottle) {
            return this.bottle(BlockIngredient.fromBlock(bottle));
        }

        public SoulBottlingRecipe.JsonBuilder soulCount(int soulCount) {
            this.soulCount = soulCount;
            return this;
        }

        public SoulBottlingRecipe.JsonBuilder result(class_1799 itemStack) {
            this.result = itemStack;
            return this;
        }

        public SoulBottlingRecipe.JsonBuilder result(class_1792 item, int count) {
            return this.result(new class_1799(item, count));
        }

        public SoulBottlingRecipe.JsonBuilder result(class_1792 item) {
            return this.result(item, 1);
        }

        @Override
        public SoulBottlingRecipe.JsonBuilder method_33530(String string, class_175<?> advancementCriterion) {
            return this;
        }

        @Override
        public SoulBottlingRecipe.JsonBuilder method_33529(@Nullable String string) {
            this.group = string;
            return this;
        }

        @Override
        public class_1792 method_36441() {
            return result.method_7909();
        }

        @Override
        public void method_10431(class_8790 exporter) {
            this.method_17972(
                    exporter,
                    Id.of(class_2446.method_33716(this.result.method_7909()) + "_from_soul_bottling")
            );
        }

        @Override
        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        @Override
        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            addToDefaults(recipeId);

            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeId)).method_703(class_170.class_171.method_753(recipeId)).method_704(class_8782.class_8797.field_1257);
            SoulBottlingRecipe soulBottlingRecipe = new SoulBottlingRecipe(
                    Objects.requireNonNullElse(this.group, ""),
                    this.category,
                    this.bottle,
                    this.soulCount,
                    this.result
            );
            exporter.method_53819(recipeId, soulBottlingRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_15434() + "/")));
        }
    }
}
