package com.bwt.recipes.soul_forge;

import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.mixin.accessors.ShapelessRecipeJsonBuilderAccessorMixin;
import com.bwt.recipes.BwtRecipes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class SoulForgeShapelessRecipe extends class_1867 implements SoulForgeRecipe {

    public SoulForgeShapelessRecipe(String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients) {
        super(group, category, result, ingredients);
    }

    @Override
    public class_1865<?> method_8119() {
        return BwtRecipes.SOUL_FORGE_SHAPELESS_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return BwtRecipes.SOUL_FORGE_RECIPE_TYPE;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= this.method_8117().size();
    }

    public class_1799 getResult() {
        return method_8110(null);
    }

    public static class Serializer implements class_1865<SoulForgeShapelessRecipe> {
        private static final MapCodec<SoulForgeShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance -> instance.group(
                        Codec.STRING.optionalFieldOf("group", "")
                                .forGetter(class_1867::method_8112),
                        class_7710.field_40252.fieldOf("category")
                                .orElse(class_7710.field_40251)
                                .forGetter(class_1867::method_45441),
                        class_1799.field_51397.fieldOf("result")
                                .forGetter(SoulForgeShapelessRecipe::getResult),
                        class_1856.field_46096
                                .listOf()
                                .fieldOf("ingredients")
                                .flatXmap(ingredients -> {
                                    class_1856[] ingredients2 = ingredients.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
                                    if (ingredients2.length == 0) {
                                        return DataResult.error(() -> "No ingredients for shapeless recipe");
                                    }
                                    if (ingredients2.length > 16) {
                                        return DataResult.error(() -> "Too many ingredients for shapeless recipe");
                                    }
                                    return DataResult.success(class_2371.method_10212(class_1856.field_9017, ingredients2));
                                }, DataResult::success)
                                .forGetter(class_1867::method_8117)
                ).apply(instance, SoulForgeShapelessRecipe::new));
        public static final class_9139<class_9129, SoulForgeShapelessRecipe> PACKET_CODEC = class_9139.method_56437(
                SoulForgeShapelessRecipe.Serializer::write,
                SoulForgeShapelessRecipe.Serializer::read
        );

        @Override
        public MapCodec<SoulForgeShapelessRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SoulForgeShapelessRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static SoulForgeShapelessRecipe read(class_9129 buf) {
            String string = buf.method_19772();
            class_7710 craftingRecipeCategory = buf.method_10818(class_7710.class);
            int i = buf.method_10816();
            class_2371<class_1856> defaultedList = class_2371.method_10213(i, class_1856.field_9017);
            defaultedList.replaceAll(empty -> class_1856.field_48355.decode(buf));
            class_1799 itemStack = class_1799.field_48349.decode(buf);
            return new SoulForgeShapelessRecipe(string, craftingRecipeCategory, itemStack, defaultedList);
        }

        private static void write(class_9129 buf, SoulForgeShapelessRecipe recipe) {
            buf.method_10814(recipe.method_8112());
            buf.method_10817(recipe.method_45441());
            buf.method_10804(recipe.method_8117().size());
            for (class_1856 ingredient : recipe.method_8117()) {
                class_1856.field_48355.encode(buf, ingredient);
            }
            class_1799.field_48349.encode(buf, recipe.getResult());
        }
    }

    public static class JsonBuilder extends class_2450 {
        public JsonBuilder(class_7800 category, class_1935 output, int count) {
            super(category, output, count);
        }

        public static JsonBuilder method_10447(class_7800 category, class_1935 output) {
            return JsonBuilder.method_10448(category, output, 1);
        }

        public static JsonBuilder method_10448(class_7800 category, class_1935 output, int count) {
            return new JsonBuilder(category, output, count);
        }

        protected boolean isDefaultRecipe;
        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }
        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        @Override
        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            addToDefaults(recipeId);

            ShapelessRecipeJsonBuilderAccessorMixin accessor = (ShapelessRecipeJsonBuilderAccessorMixin) this;

            accessor.accessValidate(recipeId);
            class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847(recipeId)).method_703(class_170.class_171.method_753(recipeId)).method_704(class_8782.class_8797.field_1257);
            accessor.getAdvancementBuilder().forEach(builder::method_705);
            SoulForgeShapelessRecipe shapelessRecipe = new SoulForgeShapelessRecipe(Objects.requireNonNullElse(accessor.getGroup(), ""), class_5797.method_55308(accessor.getCategory()), new class_1799(accessor.getOutput(), accessor.getCount()), accessor.getInputs());
            exporter.method_53819(recipeId, shapelessRecipe, builder.method_695(recipeId.method_45138("recipes/" + accessor.getCategory().method_46203() + "/")));
        }
    }
}

