package com.bwt.utils;

import com.bwt.blocks.StokedFireBlock;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_2680;

public class FireData {
    public interface FireAmountFunction {
        FireAmountFunction NONE = (world, pos, state) -> new FireData();

        FireData getFireData(class_1937 world, class_2338 pos, class_2680 state);
    }

    public static final HashMap<Class<? extends class_2248>, FireAmountFunction> FIRE_AMOUNT_FUNCTIONS = new HashMap<>();

    static {
        FIRE_AMOUNT_FUNCTIONS.put(class_2358.class, (world, pos, state) -> new FireData(1, 0));
        FIRE_AMOUNT_FUNCTIONS.put(StokedFireBlock.class, (world, pos, state) -> new FireData(0, 1));
    }

    int unstokedCount;
    int stokedCount;

    public FireData(int unstokedCount, int stokedCount) {
        this.unstokedCount = unstokedCount;
        this.stokedCount = stokedCount;
    }

    public FireData(int unstokedCount) {
        this(unstokedCount, 0);
    }

    public FireData() {
        this(0);
    }

    public void add(FireData otherData) {
        this.unstokedCount += otherData.unstokedCount;
        this.stokedCount += otherData.stokedCount;
    }

    public boolean anyFirePresent() {
        return unstokedCount > 0 || stokedCount > 0;
    }

    public int getUnstokedCount() {
        return unstokedCount;
    }

    public int getStokedCount() {
        return stokedCount;
    }

}