package com.bwt.utils;

import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class OrderedRecipeMatcher {
    public static Optional<? extends class_8786<? extends class_3955>> getFirstRecipeOfMultipleTypes(
            class_1937 world,
            class_9694 input,
            List<class_3956<? extends class_3955>> recipeTypes
    ) {
        class_1863 recipeManager = world.method_8433();
        for (class_3956<? extends class_3955> recipeType: recipeTypes) {
            Optional<? extends class_8786<? extends class_3955>> optionalResult = recipeManager.method_8132(recipeType, input, world);
            if (optionalResult.isPresent()) {
                return optionalResult;
            }
        }
        return Optional.empty();
    }

    public static class_2371<class_1799> getRemainingStacks(
            class_1937 world,
            class_9694 input,
            List<class_3956<? extends class_3955>> recipeTypes
    ) {
        Optional<? extends class_8786<? extends class_3955>> optional = getFirstRecipeOfMultipleTypes(world, input, recipeTypes);
        if (optional.isPresent()) {
            return optional.get().comp_1933().method_8111(input);
        } else {
            class_2371<class_1799> defaultedList = class_2371.method_10213(input.method_59983(), class_1799.field_8037);

            for (int i = 0; i < defaultedList.size(); i++) {
                defaultedList.set(i, input.method_59984(i));
            }

            return defaultedList;
        }
    }

    public static <I extends class_9695, R extends class_1860<I>> void getFirstRecipe(List<class_8786<R>> matches, class_2371<class_1799> inventoryItems, Predicate<R> predicateConsumer) {
        // For each inventory item, in order
        for (class_1799 inventoryStack : inventoryItems) {
            // Filter down to recipes that contain that item in its ingredients.
            // If there are multiple that match the first ingredient, get the one with the most ingredients
            Iterator<class_8786<R>> matchIterator = matches.stream()
                    .filter(match -> match.comp_1933().method_8117().stream().anyMatch(ingredient -> ingredient.method_8093(inventoryStack)))
                    .sorted(Comparator.comparing((class_8786<R> match) -> match.comp_1933().method_8117().size()).reversed())
                    .iterator();
            while (matchIterator.hasNext()) {
                R match = matchIterator.next().comp_1933();
                if (predicateConsumer.test(match)) {
                    return;
                }
            }
        }
    }
}
