/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks;

import com.bwt.blocks.BwtBlocks;
import com.bwt.tags.BwtBlockTags;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.BlockPosAndState;
import com.bwt.utils.RadiusAroundBlockStream;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

public class NetherGrothBlock
extends class_2248 {
    public static final class_2758 AGE = class_2741.field_12550;
    public static final int MAX_AGE = 7;
    public static final class_265 FLAT_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public NetherGrothBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected boolean method_9526(class_2680 state) {
        return true;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE});
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        int maxY = age + 1;
        return class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)maxY, (double)16.0);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return FLAT_SHAPE;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 stateBelow = world.method_8320(pos.method_10074());
        return stateBelow.method_26234((class_1922)world, pos.method_10074());
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10515)) {
            world.method_8501(pos.method_10074(), BwtBlocks.grothedNetherrackBlock.method_9564());
        }
    }

    public int getAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE);
    }

    public final boolean isMature(class_2680 state) {
        return this.getAge(state) >= 7;
    }

    protected boolean method_9542(class_2680 state) {
        return !this.isMature(state);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean isOnNetherrack;
        if (!world.method_8597().comp_644()) {
            return;
        }
        int height = (Integer)state.method_11654((class_2769)AGE);
        class_2680 stateBelow = world.method_8320(pos.method_10074());
        boolean bl = isOnNetherrack = stateBelow.method_27852(BwtBlocks.grothedNetherrackBlock) || stateBelow.method_27852(class_2246.field_10515);
        if (height < 7) {
            boolean canGrow;
            boolean bl2 = canGrow = isOnNetherrack || this.getMaxHeightOfNeighbors((class_1937)world, pos) > height + 1;
            if (canGrow) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(++height)));
            }
        }
        if (height < 1) {
            return;
        }
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        class_2338 targetPos = pos.method_10093(direction);
        for (class_2338 potentialOpenSpace : new class_2338[]{targetPos, targetPos.method_10074(), targetPos.method_10084()}) {
            class_2338 belowPotentialOpenSpace;
            class_2680 belowTargetState;
            class_2680 targetState = world.method_8320(potentialOpenSpace);
            if (this.isBlockOpenToSpread(targetState) && (belowTargetState = world.method_8320(belowPotentialOpenSpace = potentialOpenSpace.method_10074())).method_26206((class_1922)world, belowPotentialOpenSpace, class_2350.field_11036)) {
                this.spreadToBlock((class_1937)world, potentialOpenSpace, targetState);
            }
            if (!isOnNetherrack) break;
        }
    }

    private void spreadToBlock(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_27852(class_2246.field_10036)) {
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.method_8409().method_43057() - world.method_8409().method_43057()) * 0.8f);
        } else if (state.method_26164(BwtBlockTags.NETHER_GROTH_CAN_EAT)) {
            world.method_8396(null, pos, class_3417.field_20614, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.7f);
        }
        if (world.method_8652(pos, this.method_9564(), 3)) {
            world.method_8396(null, pos, class_3417.field_14566, class_3419.field_15245, 0.5f, 2.6f + (world.method_8409().method_43057() - world.method_8409().method_43057()) * 0.8f);
        }
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10515)) {
            world.method_8501(pos.method_10074(), BwtBlocks.grothedNetherrackBlock.method_9564());
        }
    }

    private boolean isBlockOpenToSpread(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10036) || state.method_26164(BwtBlockTags.NETHER_GROTH_CAN_EAT);
    }

    private int getMaxHeightOfNeighbors(class_1937 world, class_2338 pos) {
        return class_2350.class_2353.field_11062.method_29716().map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1937)world).method_8320(arg_0)).filter(neighborState -> neighborState.method_27852((class_2248)this)).mapToInt(neighborState -> (Integer)neighborState.method_11654((class_2769)AGE)).max().orElse(-1);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world.field_9236) {
            return;
        }
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (age < 7) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1657 player;
            class_1309 livingEntity = (class_1309)entity;
            if (entity instanceof class_1657 && this.wearingPlateBoots(player = (class_1657)entity)) {
                return;
            }
            if (livingEntity.method_5643(world.method_48963().method_48831(), 2.0f)) {
                entity.method_18800(entity.method_18798().field_1352, 0.84, entity.method_18798().field_1350);
                entity.field_6037 = true;
                world.method_8396(null, pos, class_3417.field_14958, class_3419.field_15245, 1.0f, 1.0f);
            }
        } else if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            if (itemEntity.method_6977()) {
                return;
            }
            class_1799 stack = itemEntity.method_6983();
            if (stack.method_57353().method_57832(class_9334.field_50075) || stack.method_31573(BwtItemTags.NETHER_GROTH_CAN_EAT)) {
                itemEntity.method_5650(class_1297.class_5529.field_26999);
                world.method_8396(null, pos, class_3417.field_20614, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (world.method_8320(pos.method_10074()).method_27852(BwtBlocks.grothedNetherrackBlock)) {
            world.method_8652(pos.method_10074(), class_2246.field_10515.method_9564(), 3);
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        int height = (Integer)state.method_11654((class_2769)AGE);
        if (height == 7) {
            this.releaseSpores(world, pos);
        }
        super.method_9585(world, pos, state);
    }

    private void releaseSpores(class_1936 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)world;
        world.method_8396(null, pos, class_3417.field_15057, class_3419.field_15245, 2.0f, world.method_8409().method_43057() * 0.4f + 1.5f);
        server.method_14199((class_2394)class_2398.field_11236, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10, 0.5, 0.5, 0.5, 0.1);
        RadiusAroundBlockStream.neighboringBlocksInRadius(pos, 3).map(neighborPos -> BlockPosAndState.of(world, neighborPos)).filter(neighbor -> this.isBlockOpenToSpread(neighbor.state())).map(neighbor -> BlockPosAndState.of(world, neighbor.pos().method_10074())).filter(neighborSupportingBlock -> neighborSupportingBlock.state().method_26206((class_1922)world, neighborSupportingBlock.pos(), class_2350.field_11036)).filter(neighborSupportingBlock -> world.method_8409().method_43048(2) == 0).forEach(neighborSupportingBlock -> world.method_8652(neighborSupportingBlock.pos().method_10084(), this.method_9564(), 3));
        if (world.method_8608()) {
            return;
        }
        class_238 box = new class_238((double)pos.method_10263() - 5.0, (double)pos.method_10264() - 5.0, (double)pos.method_10260() - 5.0, (double)pos.method_10263() + 5.0, (double)pos.method_10264() + 5.0, (double)pos.method_10260() + 5.0);
        server.method_8390(class_1309.class, box, e -> true).stream().filter(target -> {
            class_1657 player;
            return !(target instanceof class_1657) || !this.wearingFullNetherite(player = (class_1657)target);
        }).forEach(target -> {
            target.method_6092(new class_1293(class_1294.field_5899, 300, 0));
            target.method_5643(server.method_48963().method_48831(), 15.0f);
        });
    }

    private boolean wearingPlateBoots(class_1657 player) {
        class_1799 boots = player.method_31548().method_7372(0);
        return boots.method_31574(class_1802.field_22030);
    }

    private boolean wearingFullNetherite(class_1657 player) {
        class_1661 inventory = player.method_31548();
        return IntStream.range(0, 3).mapToObj(arg_0 -> ((class_1661)inventory).method_7372(arg_0)).map(class_1799::method_7909).map(item -> {
            class_1738 armorItem;
            return Optional.ofNullable(item instanceof class_1738 ? (armorItem = (class_1738)item) : null);
        }).map(optionalArmor -> optionalArmor.map(class_1738::method_7686)).allMatch(optionalMaterial -> optionalMaterial.isPresent() && class_1740.field_21977.method_55838((class_6880)optionalMaterial.get()));
    }
}

