/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.abstract_cooking_pot;

import com.bwt.blocks.abstract_cooking_pot.AbstractCookingPotBlock;
import com.bwt.blocks.abstract_cooking_pot.AbstractCookingPotData;
import com.bwt.items.BwtItems;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipe;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipeType;
import com.bwt.recipes.cooking_pots.CookingPotRecipeInput;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.BlockPosAndState;
import com.bwt.utils.FireDataCluster;
import com.bwt.utils.OrderedRecipeMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCookingPotBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<AbstractCookingPotData>,
class_1263 {
    protected static final int INVENTORY_SIZE = 27;
    public static final int timeToCompleteCook = 1950;
    public static final int stackSizeToDrop = 8;
    public int slotsOccupied;
    protected int cookProgressTime;
    protected boolean isStoked;
    public final Inventory inventory = new Inventory(27);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of((class_1263)this.inventory, null);
    public AbstractCookingPotRecipeType unstokedRecipeType;
    public AbstractCookingPotRecipeType stokedRecipeType;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return AbstractCookingPotBlockEntity.this.cookProgressTime;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                AbstractCookingPotBlockEntity.this.cookProgressTime = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public AbstractCookingPotBlockEntity(class_2591<? extends AbstractCookingPotBlockEntity> blockEntityType, AbstractCookingPotRecipeType unstokedRecipeType, AbstractCookingPotRecipeType stokedRecipeType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        this.unstokedRecipeType = unstokedRecipeType;
        this.stokedRecipeType = stokedRecipeType;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", 10), registryLookup);
        this.cookProgressTime = nbt.method_10550("cookProgressTicks");
        this.isStoked = nbt.method_10577("isStoked");
        this.slotsOccupied = nbt.method_10550("slotsOccupied");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660(registryLookup));
        nbt.method_10569("cookProgressTicks", this.cookProgressTime);
        nbt.method_10556("isStoked", this.isStoked);
        nbt.method_10569("slotsOccupied", this.slotsOccupied);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = this.method_38244(registryLookup);
        nbtCompound.method_10569("slotsOccupied", this.slotsOccupied);
        return nbtCompound;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AbstractCookingPotBlockEntity blockEntity) {
        FireDataCluster fireDataCluster = FireDataCluster.fromWorld(world, pos);
        boolean isStoked = fireDataCluster.isStoked();
        if (isStoked != blockEntity.isStoked) {
            blockEntity.isStoked = isStoked;
            blockEntity.method_5431();
        }
        if (state.method_11654((class_2769)AbstractCookingPotBlock.TIP_DIRECTION) == class_2350.field_11036) {
            blockEntity.cookItems(world, pos, fireDataCluster);
        } else {
            blockEntity.dumpItems(world, pos, state);
        }
    }

    protected void cookItems(class_1937 world, class_2338 pos, FireDataCluster fireDataCluster) {
        CookingPotRecipeInput recipeInput;
        AbstractCookingPotRecipeType recipeTypeToGet;
        int stokedExplosivesCount;
        if (!fireDataCluster.anyFirePresent()) {
            if (this.cookProgressTime != 0) {
                this.cookProgressTime = 0;
                this.method_5431();
            }
            return;
        }
        if (this.inventory.method_43256(itemStack -> itemStack.method_31574((class_1792)BwtItems.dungItem)) && this.inventory.method_43256(itemStack -> itemStack.method_57353().method_57829(class_9334.field_50075) != null)) {
            this.spoilFood();
        }
        if (fireDataCluster.getStokedFactor() > 0 && (stokedExplosivesCount = this.inventory.method_54454().stream().filter(itemStack -> itemStack.method_31573(BwtItemTags.STOKED_EXPLOSIVES)).map(class_1799::method_7947).reduce(Integer::sum).orElse(0).intValue()) > 0) {
            AbstractCookingPotBlockEntity.explode(world, pos, stokedExplosivesCount);
            return;
        }
        class_1863 recipeManager = world.method_8433();
        List matches = recipeManager.method_17877((class_3956)(recipeTypeToGet = fireDataCluster.isStoked() ? this.stokedRecipeType : this.unstokedRecipeType), (class_9695)(recipeInput = new CookingPotRecipeInput((List<class_1799>)this.inventory.method_54454())), world);
        if (matches.isEmpty()) {
            if (this.cookProgressTime != 0) {
                this.cookProgressTime = 0;
                this.method_5431();
            }
            return;
        }
        this.cookProgressTime += fireDataCluster.getDominantFireTypeFactor();
        if (this.cookProgressTime < 1950) {
            return;
        }
        this.cookProgressTime = 0;
        this.method_5431();
        OrderedRecipeMatcher.getFirstRecipe(matches, (class_2371<class_1799>)this.inventory.method_54454(), this::cookRecipe);
    }

    private void dumpItems(class_1937 world, class_2338 pos, class_2680 state) {
        Optional<class_1799> firstItemToDump = this.inventory.method_54454().stream().filter(itemStack -> !itemStack.method_7960()).findFirst();
        if (firstItemToDump.isEmpty()) {
            return;
        }
        class_1799 itemStack2 = firstItemToDump.get();
        if (itemStack2.method_7960()) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)AbstractCookingPotBlock.TIP_DIRECTION);
        BlockPosAndState dumpPosAndState = BlockPosAndState.of((class_1936)world, pos.method_10093(facing));
        if (!dumpPosAndState.state().method_45474() && !dumpPosAndState.state().method_26220((class_1922)world, dumpPosAndState.pos()).method_1110()) {
            return;
        }
        this.ejectStack(world, itemStack2, facing, dumpPosAndState);
    }

    private void ejectStack(class_1937 world, class_1799 itemStack, class_2350 facing, BlockPosAndState dumpPosAndState) {
        int stackSizeToDump = Math.min(itemStack.method_7947(), 8);
        class_243 entityPos = dumpPosAndState.pos().method_46558().method_1023(0.0, 0.25, 0.0);
        class_1542 itemEntity = new class_1542(world, entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, itemStack.method_46651(stackSizeToDump));
        class_243 itemVelocity = class_243.method_24954((class_2382)facing.method_10163()).method_1021(0.1);
        itemEntity.method_18799(itemVelocity);
        itemEntity.method_6982(10);
        itemStack.method_7934(stackSizeToDump);
        this.method_5431();
        world.method_8649((class_1297)itemEntity);
    }

    private static void explode(class_1937 world, class_2338 pos, int stokedExplosivesCount) {
        world.method_22352(pos, true);
        float explosionStrength = Math.min(Math.max((float)stokedExplosivesCount / 6.4f, 2.0f), 10.0f);
        world.method_8537(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), explosionStrength, true, class_1937.class_7867.field_40889);
    }

    public int method_5439() {
        return this.inventory.method_5439();
    }

    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public boolean cookRecipe(AbstractCookingPotRecipe recipe) {
        try (Transaction transaction = Transaction.openOuter();){
            ArrayList<class_1799> remaindersAndResults = new ArrayList<class_1799>(recipe.getResults());
            for (IngredientWithCount ingredientWithCount : recipe.getIngredientsWithCount()) {
                long countToSpend = ingredientWithCount.count();
                while (countToSpend > 0L) {
                    class_1792 remainder;
                    ItemVariant itemVariant = (ItemVariant)StorageUtil.findStoredResource((Storage)this.inventoryWrapper, ingredientWithCount::test);
                    if (itemVariant == null) continue;
                    if (itemVariant.getItem().method_7857() && (remainder = itemVariant.getItem().method_7858()) != null) {
                        remaindersAndResults.add(new class_1799((class_1935)remainder, (int)countToSpend));
                    }
                    long taken = this.inventoryWrapper.extract((Object)itemVariant, countToSpend, (TransactionContext)transaction);
                    countToSpend -= taken;
                    if (taken != 0L) continue;
                    transaction.abort();
                    boolean bl = false;
                    return bl;
                }
            }
            for (class_1799 result : remaindersAndResults) {
                long inserted = StorageUtil.insertStacking((List)this.inventoryWrapper.getSlots(), (Object)ItemVariant.of((class_1799)result), (long)result.method_7947(), (TransactionContext)transaction);
                if (inserted >= (long)result.method_7947()) continue;
                transaction.abort();
                boolean bl = false;
                return bl;
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public void spoilFood() {
        try (Transaction transaction = Transaction.openOuter();){
            for (SingleSlotStorage slot : this.inventoryWrapper.getSlots()) {
                ItemVariant resource = (ItemVariant)slot.getResource();
                if (resource.toStack().method_57353().method_57829(class_9334.field_50075) == null) continue;
                long count = slot.extract((Object)resource, (long)resource.getItem().method_7882(), (TransactionContext)transaction);
                slot.insert((Object)ItemVariant.of((class_1935)BwtItems.foulFoodItem), count, (TransactionContext)transaction);
            }
            transaction.commit();
        }
    }

    public static void onEntityCollided(class_1297 entity, AbstractCookingPotBlockEntity blockEntity) {
        class_1542 itemEntity;
        class_1799 itemStack;
        if (entity instanceof class_1542 && !(itemStack = (itemEntity = (class_1542)entity).method_6983()).method_7960()) {
            int count = itemStack.method_7947();
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = StorageUtil.insertStacking((List)blockEntity.inventoryWrapper.getSlots(), (Object)ItemVariant.of((class_1799)itemStack), (long)count, (TransactionContext)transaction);
                itemEntity.method_6979(itemEntity.method_6983().method_46651((int)((long)count - inserted)));
                transaction.commit();
                blockEntity.inventory.method_5431();
            }
        }
    }

    public void method_5431() {
        this.slotsOccupied = (int)this.inventory.field_5828.stream().filter(stack -> !stack.method_7960()).count();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        super.method_5431();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public AbstractCookingPotData getScreenOpeningData(class_3222 player) {
        return new AbstractCookingPotData(this.isStoked);
    }

    public class Inventory
    extends class_1277 {
        public Inventory(int size) {
            super(size);
        }

        public void method_5431() {
            AbstractCookingPotBlockEntity.this.method_5431();
        }
    }
}

