/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.block_dispenser;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.block_dispenser.BlockDispenserBlockEntity;
import com.bwt.blocks.block_dispenser.BlockDispenserPlacementContext;
import com.bwt.blocks.block_dispenser.behavior.dispense.BlockDispenserBehavior;
import com.bwt.blocks.block_dispenser.behavior.dispense.BoatDispenserBehavior;
import com.bwt.blocks.block_dispenser.behavior.dispense.DefaultItemDispenserBehavior;
import com.bwt.blocks.block_dispenser.behavior.dispense.ItemClumpDispenserBehavior;
import com.bwt.blocks.block_dispenser.behavior.dispense.MinecartDispenserBehavior;
import com.bwt.blocks.block_dispenser.behavior.inhale.BlockInhaleBehavior;
import com.bwt.blocks.block_dispenser.behavior.inhale.EntityInhaleBehavior;
import com.bwt.blocks.mining_charge.MiningChargeBlock;
import com.bwt.blocks.unfired_pottery.UnfiredDecoratedPotBlockEntity;
import com.bwt.entities.MiningChargeEntity;
import com.bwt.items.BwtItems;
import com.bwt.mixin.accessors.DecoratedPotPatternsAccessorMixin;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.block_dispenser_clump.BlockDispenserClumpRecipe;
import com.bwt.recipes.block_dispenser_clump.BlockDispenserClumpRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.tags.BwtBlockTags;
import com.bwt.tags.BwtEntityTags;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_238;
import net.minecraft.class_2426;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2965;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class BlockDispenserBlock
extends class_2315 {
    public static final int tickRate = 4;
    private static final Map<Class<? extends class_2248>, class_2357> BLOCK_BEHAVIORS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue((Object)BlockDispenserBehavior.DEFAULT));
    private static final Map<class_1792, class_2357> ITEM_BEHAVIORS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue((Object)new DefaultItemDispenserBehavior()));
    private static final Map<Class<? extends class_2248>, BlockInhaleBehavior> BLOCK_INHALE_BEHAVIORS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue((Object)BlockInhaleBehavior.DEFAULT));
    private static final Map<class_1299<? extends class_1297>, EntityInhaleBehavior> ENTITY_INHALE_BEHAVIORS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue((Object)EntityInhaleBehavior.NOOP));

    public BlockDispenserBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    protected void inheritItemBehavior(class_1792 ... items) {
        for (class_1792 item : items) {
            ITEM_BEHAVIORS.put(item, BlockDispenserBlock.invertStackResult((class_2357)class_2315.field_10919.get(item)));
        }
    }

    protected static class_2357 invertStackResult(class_2357 behavior) {
        return (pointer, stack) -> {
            int originalCount = stack.method_7947();
            class_1799 overwriteStack = behavior.dispense(pointer, stack);
            int newCount = overwriteStack.method_7947();
            stack.method_7939(originalCount);
            return overwriteStack.method_46651(originalCount - newCount);
        };
    }

    public void registerItemDispenseBehaviors() {
        this.inheritItemBehavior(class_1802.field_8694, class_1802.field_8107, class_1802.field_8236, class_1802.field_8087, class_1802.field_8803, class_1802.field_8436, class_1802.field_8150);
        BoatDispenserBehavior boatDispenserBehavior = new BoatDispenserBehavior();
        Stream.of(class_1802.field_8533, class_1802.field_8486, class_1802.field_8442, class_1802.field_8730, class_1802.field_8138, class_1802.field_8094, class_1802.field_42706, class_1802.field_37531, class_1802.field_40224, class_1802.field_38216, class_1802.field_38217, class_1802.field_38218, class_1802.field_38212, class_1802.field_38214, class_1802.field_38213, class_1802.field_42707, class_1802.field_38215, class_1802.field_40225).forEach(item -> BlockDispenserBlock.registerItemDispenseBehavior((class_1935)item, (class_2357)boatDispenserBehavior));
        MinecartDispenserBehavior minecartDispenserBehavior = new MinecartDispenserBehavior();
        Stream.of(class_1802.field_8045, class_1802.field_8388, class_1802.field_8220, class_1802.field_8220, class_1802.field_8063, class_1802.field_8836, class_1802.field_8069).forEach(item -> BlockDispenserBlock.registerItemDispenseBehavior((class_1935)item, (class_2357)minecartDispenserBehavior));
        BlockDispenserBlock.registerVanillaAndBDProjectileBehaviors(BwtItems.dynamiteItem, BwtItems.broadheadArrowItem, BwtItems.rottedArrowItem, BwtItems.soulUrnItem);
        class_2347 miningChargeBehavior = new class_2347(this){

            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_3218 world = pointer.comp_1967();
                class_2338 blockPos = pointer.comp_1968().method_10093((class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918));
                class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2680 placementState = BwtBlocks.miningChargeBlock.getDispenserPlacmentState(new BlockDispenserPlacementContext((class_1937)pointer.comp_1967(), blockPos, direction, stack, direction));
                MiningChargeEntity miningChargeEntity = new MiningChargeEntity((class_1937)world, blockPos.method_46558().method_1023(0.0, 0.5, 0.0), placementState, null);
                world.method_8649((class_1297)miningChargeEntity);
                world.method_43128(null, miningChargeEntity.method_23317(), miningChargeEntity.method_23318(), miningChargeEntity.method_23321(), BwtSoundEvents.MINING_CHARGE_PRIME, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596(null, (class_6880)class_5712.field_28738, blockPos);
                stack.method_7934(1);
                return stack;
            }
        };
        BlockDispenserBlock.registerBlockDispenseBehavior(MiningChargeBlock.class, BlockDispenserBlock.invertStackResult((class_2357)miningChargeBehavior));
        class_2315.method_10009((class_1935)BwtBlocks.miningChargeBlock, (class_2357)miningChargeBehavior);
        BlockDispenserBlock.registerBlockDispenseBehavior(class_2426.class, (class_2357)new BlockDispenserBehavior(this){

            @Override
            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_1799 result = super.method_10135(pointer, stack);
                if (this.method_27954()) {
                    class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
                    class_2338 blockPos = pointer.comp_1968().method_10093(direction);
                    pointer.comp_1967().method_42308(direction.method_10153(), pointer.comp_1969(), blockPos, pointer.comp_1968(), 2, 511);
                }
                return result;
            }
        });
        this.registerSherdBehaviors();
    }

    private void registerSherdBehaviors() {
        class_2347 sherdBehavior = new class_2347(this){

            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_2350 side;
                class_3218 world = pointer.comp_1967();
                class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2338 blockPos = pointer.comp_1968().method_10093(direction);
                class_2680 blockState = world.method_8320(blockPos);
                if (!blockState.method_27852((class_2248)BwtBlocks.unfiredDecoratedPotBlock) && !blockState.method_27852((class_2248)BwtBlocks.unfiredDecoratedPotBlockWithSherds)) {
                    return super.method_10135(pointer, stack);
                }
                if (blockState.method_27852((class_2248)BwtBlocks.unfiredDecoratedPotBlock)) {
                    blockState = BwtBlocks.unfiredDecoratedPotBlockWithSherds.method_9564();
                    world.method_30092(blockPos, blockState, 2, 0);
                }
                if ((side = direction.method_10153()).method_10166().method_10178()) {
                    return stack;
                }
                class_2586 blockEntity = world.method_8321(blockPos);
                if (!(blockEntity instanceof UnfiredDecoratedPotBlockEntity)) {
                    return stack;
                }
                UnfiredDecoratedPotBlockEntity unfiredDecoratedPotBlockEntity = (UnfiredDecoratedPotBlockEntity)blockEntity;
                if (!world.field_9236 && unfiredDecoratedPotBlockEntity.tryAddSherd(side, stack.method_7909())) {
                    stack.method_7934(1);
                }
                return stack;
            }
        };
        ArrayList<class_1792> sherds = new ArrayList<class_1792>(DecoratedPotPatternsAccessorMixin.getSHERD_TO_PATTERN().keySet());
        sherds.forEach(sherd -> class_2315.method_10009((class_1935)sherd, (class_2357)sherdBehavior));
        this.inheritItemBehavior((class_1792[])sherds.toArray(class_1792[]::new));
    }

    public static void registerEntityInhaleBehavior(class_1299<?> entityType, EntityInhaleBehavior behavior) {
        ENTITY_INHALE_BEHAVIORS.put(entityType, behavior);
    }

    public static void registerBlockInhaleBehavior(Class<? extends class_2248> blockClass, BlockInhaleBehavior behavior) {
        BLOCK_INHALE_BEHAVIORS.put(blockClass, behavior);
    }

    public static void registerItemDispenseBehavior(class_1935 item, class_2357 behavior) {
        ITEM_BEHAVIORS.put(item.method_8389(), behavior);
    }

    public static void registerBlockDispenseBehavior(Class<? extends class_2248> blockClass, class_2357 behavior) {
        BLOCK_BEHAVIORS.put(blockClass, behavior);
    }

    public static void registerVanillaAndBDProjectileBehaviors(class_1792 ... items) {
        for (class_1792 item : items) {
            class_2965 projectileBehavior = new class_2965(item);
            BlockDispenserBlock.registerItemDispenseBehavior((class_1935)item, BlockDispenserBlock.invertStackResult((class_2357)projectileBehavior));
            class_2315.method_10009((class_1935)item, (class_2357)projectileBehavior);
        }
    }

    public void registerBehaviors() {
        EntityInhaleBehavior.registerBehaviors();
        BlockInhaleBehavior.registerBehaviors();
        BlockDispenserBehavior.registerBehaviors();
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BlockDispenserBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10918, (Comparable)ctx.method_7715().method_10153())).method_11657((class_2769)field_10920, (Comparable)Boolean.valueOf(false));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (this.isReceivingPower(world, pos, (class_2350)state.method_11654((class_2769)field_10918))) {
            world.method_39279(pos, (class_2248)this, 4);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        if (((Boolean)state.method_11654((class_2769)field_10920)).booleanValue() != this.isReceivingPower(world, pos, (class_2350)state.method_11654((class_2769)field_10918))) {
            world.method_39279(pos, (class_2248)this, 4);
        }
    }

    protected class_1269 method_55766(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        world.method_35230(blockPos, BwtBlockEntities.blockDispenserBlockEntity).ifPresent(arg_0 -> ((class_1657)player).method_17355(arg_0));
        return class_1269.field_21466;
    }

    public boolean isReceivingPower(class_1937 world, class_2338 pos, class_2350 facing) {
        return Arrays.stream(class_2350.values()).filter(direction -> direction != facing).anyMatch(direction -> world.method_49807(pos.method_10093(direction), direction));
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean powered = this.isReceivingPower((class_1937)world, pos, (class_2350)state.method_11654((class_2769)field_10918));
        if (powered) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)field_10920, (Comparable)Boolean.valueOf(true)));
            this.dispenseBlockOrItem(world, state, pos);
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)field_10920, (Comparable)Boolean.valueOf(false)));
            this.consumeBlockOrEntity(world, state, pos);
        }
    }

    public void dispenseBlockOrItem(class_3218 world, class_2680 state, class_2338 pos) {
        BlockDispenserBlockEntity blockEntity = (BlockDispenserBlockEntity)world.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_2338 targetPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_10918));
        class_2680 targetState = world.method_8320(targetPos);
        class_1799 stackToPlace = blockEntity.getCurrentItemToDispense();
        if (stackToPlace.method_7960()) {
            return;
        }
        class_2342 blockPointer = new class_2342(world, pos, state, (class_2601)blockEntity);
        class_2357 dispenserBehavior = this.getDispenseBehaviorForItem((class_1937)world, targetState, blockEntity, stackToPlace);
        if (dispenserBehavior != class_2357.field_16902) {
            class_1799 takenOut = dispenserBehavior.dispense(blockPointer, stackToPlace);
            blockEntity.take(takenOut.method_7909(), takenOut.method_7947());
        }
        blockEntity.advanceSelectedSlot();
    }

    public void consumeBlockOrEntity(class_3218 world, class_2680 state, class_2338 pos) {
        BlockDispenserBlockEntity blockEntity = (BlockDispenserBlockEntity)world.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        class_2338 targetPos = pos.method_10093((class_2350)state.method_11654((class_2769)field_10918));
        class_2680 targetState = world.method_8320(targetPos);
        Optional<class_1297> optionalEntity = this.getInhaleableEntity((class_1937)world, targetPos);
        if (optionalEntity.isPresent()) {
            class_1297 entity = optionalEntity.get();
            this.inhaleEntity(blockEntity, entity);
            return;
        }
        class_2342 blockPointer = new class_2342(world, pos, state, (class_2601)blockEntity);
        BlockInhaleBehavior inhaleBehavior = this.getInhaleBehaviorForItem(targetState);
        if (inhaleBehavior == BlockInhaleBehavior.NOOP) {
            return;
        }
        class_1799 inhaledItems = inhaleBehavior.getInhaledItems(blockPointer);
        if (!blockEntity.hasRoomFor(inhaledItems)) {
            return;
        }
        inhaleBehavior.inhale(blockPointer);
        blockEntity.insert(inhaledItems.method_7972());
    }

    protected class_2357 getDispenseBehaviorForItem(class_1937 world, class_2680 targetState, BlockDispenserBlockEntity entity, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            if (!targetState.method_26164(class_3481.field_44471)) {
                return BlockDispenserBehavior.field_16902;
            }
            return BLOCK_BEHAVIORS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(blockItem.method_7711())).findAny().map(Map.Entry::getValue).orElse((class_2357)BlockDispenserBehavior.DEFAULT);
        }
        BlockDispenserClumpRecipeInput recipeInput = new BlockDispenserClumpRecipeInput((List<class_1799>)entity.getItems());
        Optional<BlockDispenserClumpRecipe> match = world.method_8433().method_8132(BwtRecipes.BLOCK_DISPENSER_CLUMP_RECIPE_TYPE, (class_9695)recipeInput, world).map(class_8786::comp_1933);
        if (match.isEmpty()) {
            return ITEM_BEHAVIORS.get(stack.method_7909());
        }
        BlockDispenserClumpRecipe recipe = match.get();
        if (recipe.canAfford(entity) && targetState.method_26164(class_3481.field_44471)) {
            return new ItemClumpDispenserBehavior(recipe, stack.method_7909());
        }
        return BlockDispenserBehavior.field_16902;
    }

    protected Optional<class_1297> getInhaleableEntity(class_1937 world, class_2338 targetPos) {
        ArrayList entities = Lists.newArrayList();
        world.method_47574(class_5575.method_31795(class_1297.class), new class_238(targetPos), class_1301.field_6155.and(entity -> entity.method_5864().method_20210(BwtEntityTags.BLOCK_DISPENSER_INHALE_ENTITIES) && ENTITY_INHALE_BEHAVIORS.getOrDefault(entity.method_5864(), EntityInhaleBehavior.NOOP).canInhale((class_1297)entity)), (List)entities);
        return entities.stream().findAny();
    }

    protected <T extends class_1297> void inhaleEntity(BlockDispenserBlockEntity blockEntity, T entity) {
        EntityInhaleBehavior entityInhaleBehavior = ENTITY_INHALE_BEHAVIORS.get(entity.method_5864());
        class_1799 inhaledItems = entityInhaleBehavior.getInhaledItems(entity).method_7972();
        if (!blockEntity.hasRoomFor(inhaledItems)) {
            return;
        }
        entityInhaleBehavior.inhale(entity);
        blockEntity.insert(inhaledItems);
        entityInhaleBehavior.getDroppedItems(entity).forEach(arg_0 -> entity.method_5775(arg_0));
    }

    protected BlockInhaleBehavior getInhaleBehaviorForItem(class_2680 targetState) {
        if (targetState.method_26164(BwtBlockTags.BLOCK_DISPENSER_INHALE_NOOP)) {
            return BlockInhaleBehavior.NOOP;
        }
        return BLOCK_INHALE_BEHAVIORS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(targetState.method_26204())).findAny().map(Map.Entry::getValue).orElse(BlockInhaleBehavior.DEFAULT);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)field_10918, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)field_10918)));
    }
}

