/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.blood_wood;

import com.bwt.blocks.BwtBlocks;
import com.bwt.tags.BwtBlockTags;
import com.bwt.utils.BlockPosAndState;
import com.bwt.utils.RadiusAroundBlockStream;
import java.util.Arrays;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class BloodWoodLogBlock
extends class_2465 {
    public static final class_2758 POS_NEG = class_2758.method_11867((String)"pos_neg", (int)0, (int)1);
    public static final class_2746 CAN_GROW = class_2746.method_11825((String)"can_grow");

    public BloodWoodLogBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)CAN_GROW, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POS_NEG, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{CAN_GROW, POS_NEG});
    }

    public boolean canGrow(class_2680 state) {
        return state.method_27852((class_2248)this) && (Boolean)state.method_11654((class_2769)CAN_GROW) != false;
    }

    protected boolean method_9542(class_2680 state) {
        return this.canGrow(state);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (this.canGrow(state)) {
            if (world.method_8597().comp_644()) {
                this.grow(world, pos, state, random);
            }
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CAN_GROW, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)field_11459);
        class_2350.class_2352 axisDirection = (Integer)state.method_11654((class_2769)POS_NEG) > 0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        return class_2350.method_10156((class_2350.class_2352)axisDirection, (class_2350.class_2351)axis);
    }

    public static void setFacing(class_1937 world, class_2338 pos, class_2680 state, class_2350 facing) {
        world.method_8501(pos, BloodWoodLogBlock.withFacing(state, facing));
    }

    public static class_2680 withFacing(class_2680 state, class_2350 facing) {
        return (class_2680)((class_2680)state.method_11657((class_2769)field_11459, (Comparable)facing.method_10166())).method_11657((class_2769)POS_NEG, (Comparable)Integer.valueOf(facing.method_10171() == class_2350.class_2352.field_11056 ? 1 : 0));
    }

    public static class_2350 randomHorizontalDirection(class_5819 random) {
        return class_2350.method_10143((int)random.method_39332(2, 5));
    }

    public void grow(class_3218 serverWorld, class_2338 pos, class_2680 state, class_5819 random) {
        if (this.countBloodWoodNeighboringOnBlockWithSoulSand((class_1937)serverWorld, pos) >= 2) {
            return;
        }
        class_2350 facing = BloodWoodLogBlock.getFacing(state);
        int randomFactor = random.method_43048(100);
        if (facing == class_2350.field_11036) {
            if (randomFactor < 25) {
                this.attemptToGrowIntoBlock((class_1937)serverWorld, pos.method_10084(), class_2350.field_11036);
            } else if (randomFactor < 90) {
                class_2350 targetFacing = BloodWoodLogBlock.randomHorizontalDirection(random);
                class_2338 targetPos = pos.method_10093(targetFacing);
                this.attemptToGrowIntoBlock((class_1937)serverWorld, targetPos, targetFacing);
                this.attemptToGrowIntoBlock((class_1937)serverWorld, pos.method_10084(), class_2350.field_11036);
            } else {
                for (int temp = 0; temp < 2; ++temp) {
                    class_2350 targetFacing = BloodWoodLogBlock.randomHorizontalDirection(random);
                    class_2338 targetPos = pos.method_10093(targetFacing);
                    this.attemptToGrowIntoBlock((class_1937)serverWorld, targetPos, targetFacing);
                }
            }
        } else if (randomFactor < 40) {
            this.attemptToGrowIntoBlock((class_1937)serverWorld, pos.method_10084(), facing);
            BloodWoodLogBlock.setFacing((class_1937)serverWorld, pos, state, class_2350.field_11036);
        } else if (randomFactor < 65) {
            this.attemptToGrowIntoBlock((class_1937)serverWorld, pos.method_10093(facing), facing);
        } else if (randomFactor < 90) {
            class_2350 targetFacing = BloodWoodLogBlock.randomHorizontalDirection(random);
            if (targetFacing == facing) {
                targetFacing = class_2350.field_11036;
            }
            class_2338 targetPos = pos.method_10093(targetFacing);
            class_2350 targetGrowthDirection = facing;
            if (targetFacing.method_10146() >= 2) {
                targetGrowthDirection = targetFacing;
            }
            this.attemptToGrowIntoBlock((class_1937)serverWorld, targetPos, targetGrowthDirection);
            if (!this.attemptToGrowIntoBlock((class_1937)serverWorld, pos.method_10093(facing), facing) && targetFacing.method_10146() == 1) {
                BloodWoodLogBlock.setFacing((class_1937)serverWorld, pos, state, class_2350.field_11036);
            }
        } else {
            class_2350[] growthDirections = new class_2350[2];
            for (int iTempCount = 0; iTempCount < 2; ++iTempCount) {
                growthDirections[iTempCount] = class_2350.field_11033;
                class_2350 targetFacing = BloodWoodLogBlock.randomHorizontalDirection(random);
                if (targetFacing == facing) {
                    targetFacing = class_2350.field_11036;
                }
                class_2338 targetPos = pos.method_10093(targetFacing);
                class_2350 iTargetGrowthDirection = facing;
                if (targetFacing.method_10146() >= 2) {
                    iTargetGrowthDirection = targetFacing;
                }
                if (!this.attemptToGrowIntoBlock((class_1937)serverWorld, targetPos, iTargetGrowthDirection)) continue;
                growthDirections[iTempCount] = targetFacing;
            }
            if (growthDirections[0] == class_2350.field_11036 && growthDirections[1].method_10166().method_10178() || growthDirections[1] == class_2350.field_11036 && growthDirections[0] == class_2350.field_11033) {
                BloodWoodLogBlock.setFacing((class_1937)serverWorld, pos, state, class_2350.field_11036);
            }
        }
    }

    public boolean attemptToGrowIntoBlock(class_1937 world, class_2338 pos, class_2350 growthDirection) {
        class_2680 state = world.method_8320(pos);
        if (!state.method_26164(class_3481.field_51989) && !state.method_27852(BwtBlocks.bloodWoodBlocks.leavesBlock) || this.countBloodWoodNeighboringOnBlockWithSoulSand(world, pos) >= 2) {
            return false;
        }
        world.method_8501(pos, (class_2680)BloodWoodLogBlock.withFacing(this.method_9564(), growthDirection).method_11657((class_2769)CAN_GROW, (Comparable)Boolean.valueOf(true)));
        this.growLeaves(world, pos);
        return true;
    }

    public void growLeaves(class_1937 world, class_2338 pos) {
        RadiusAroundBlockStream.neighboringBlocksInRadius(pos, 1).map(neighborPos -> BlockPosAndState.of((class_1936)world, neighborPos)).filter(neighbor -> neighbor.state().method_26164(class_3481.field_51989)).forEach(neighbor -> world.method_8501(neighbor.pos(), BwtBlocks.bloodWoodBlocks.leavesBlock.method_9564()));
    }

    public int countBloodWoodNeighboringOnBlockWithSoulSand(class_1937 world, class_2338 pos) {
        int neighborWoodCount = (int)Arrays.stream(class_2350.values()).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1937)world).method_8320(arg_0)).filter(blockState -> blockState.method_27852((class_2248)this)).count();
        if (world.method_8320(pos.method_10074()).method_26164(BwtBlockTags.BLOOD_WOOD_PLANTABLE_ON)) {
            ++neighborWoodCount;
        }
        return neighborWoodCount;
    }
}

