/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.detector;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.detector.DetectorBlock;
import com.bwt.tags.BwtBlockTags;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class DetectorLogicBlock
extends class_2189 {
    private static final int tickRate = 4;
    public static final class_2746 ENTITY_INTERSECT = class_2746.method_11825((String)"entity_intersect");
    public static final class_2746 BLOCK_INTERSECT = class_2746.method_11825((String)"block_intersect");

    public DetectorLogicBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ENTITY_INTERSECT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BLOCK_INTERSECT, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ENTITY_INTERSECT});
        builder.method_11667(new class_2769[]{BLOCK_INTERSECT});
    }

    public static boolean isEnabled(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)ENTITY_INTERSECT) != false || (Boolean)state.method_11654((class_2769)BLOCK_INTERSECT) != false;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        world.method_39279(pos, (class_2248)this, 4);
        return state;
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!world.method_8608() && !state.method_27852(oldState.method_26204())) {
            world.method_39279(pos, (class_2248)this, 4);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_27852((class_2248)this)) {
            this.notifyNeighborDetectors(newState, world, pos);
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        boolean updated = this.updateIntersectStates(state, world, pos, true, null);
        if (updated) {
            world.method_39279(pos, (class_2248)this, 4);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean blockIntersect = this.anyBlocksIntersecting(world.method_8320(pos.method_10074()));
        boolean entityIntersect = this.anyEntitiesIntersecting((class_1937)world, pos);
        if (entityIntersect) {
            world.method_39279(pos, (class_2248)this, 4);
        }
        if (!this.updateIntersectStates(state, (class_1937)world, pos, entityIntersect, blockIntersect)) {
            return;
        }
    }

    protected boolean anyBlocksIntersecting(class_2680 neighborState) {
        return neighborState.method_26164(BwtBlockTags.DETECTABLE_SMALL_CROPS) && neighborState.method_28500((class_2769)class_2302.field_10835).orElse(0) >= ((class_2302)neighborState.method_26204()).method_9827();
    }

    protected boolean anyEntitiesIntersecting(class_1937 world, class_2338 pos) {
        ArrayList list = Lists.newArrayList();
        world.method_47575(class_5575.method_31795(class_1297.class), new class_238(pos), class_1301.field_6155, (List)list, 1);
        return !list.isEmpty();
    }

    protected boolean updateIntersectStates(class_2680 state, class_1937 world, class_2338 pos, @Nullable Boolean entityIntersect, @Nullable Boolean blockIntersect) {
        if (!(entityIntersect != null && entityIntersect != state.method_11654((class_2769)ENTITY_INTERSECT) || blockIntersect != null && blockIntersect != state.method_11654((class_2769)BLOCK_INTERSECT))) {
            return false;
        }
        if (entityIntersect != null) {
            state = (class_2680)state.method_11657((class_2769)ENTITY_INTERSECT, (Comparable)entityIntersect);
        }
        if (blockIntersect != null) {
            state = (class_2680)state.method_11657((class_2769)BLOCK_INTERSECT, (Comparable)blockIntersect);
        }
        world.method_30092(pos, state, 3, 0);
        int detectorsUpdated = this.notifyNeighborDetectors(state, world, pos);
        if (detectorsUpdated == 0) {
            world.method_30092(pos, class_2246.field_10124.method_9564(), 3, 0);
            return false;
        }
        return true;
    }

    public static boolean anyNeighborDetectors(class_1936 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 targetPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(targetPos);
            if (!neighborState.method_27852(BwtBlocks.detectorBlock) || !((class_2350)neighborState.method_11654((class_2769)DetectorBlock.field_10927)).equals((Object)direction.method_10153())) continue;
            return true;
        }
        return false;
    }

    public int notifyNeighborDetectors(class_2680 state, class_1937 world, class_2338 pos) {
        int numDetectorsUpdated = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2338 targetPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(targetPos);
            if (!neighborState.method_27852(BwtBlocks.detectorBlock) || !((class_2350)neighborState.method_11654((class_2769)DetectorBlock.field_10927)).equals((Object)direction.method_10153())) continue;
            ++numDetectorsUpdated;
            world.method_42308(direction.method_10153(), state, targetPos, pos, 2, 512);
            world.method_41410(neighborState, targetPos, state.method_26204(), pos, false);
        }
        return numDetectorsUpdated;
    }
}

