/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.mech_hopper;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.MechPowerBlockBase;
import com.bwt.blocks.mech_hopper.MechHopperBlockEntity;
import com.bwt.tags.BwtItemTags;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class MechHopperBlock
extends class_2237
implements MechPowerBlockBase {
    public static final MapCodec<MechHopperBlock> CODEC = MechHopperBlock.method_54094(MechHopperBlock::new);
    protected static final class_265 OUTLINE_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0));
    public static final Map<class_1792, Predicate<class_1799>> filterMap = Maps.newLinkedHashMap();

    public MechHopperBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public static void addFilter(class_1792 item, Predicate<class_1799> predicate) {
        filterMap.put(item, predicate);
    }

    public static void addDefaultFilters() {
        MechHopperBlock.addFilter(class_1802.field_8121, new TagFilter(BwtItemTags.PASSES_LADDER_FILTER));
        MechHopperBlock.addFilter(class_1802.field_8076, new TagFilter(BwtItemTags.PASSES_IRON_BARS_FILTER));
        for (class_1792 trapdoor : new class_1792[]{class_1802.field_8190, class_1802.field_40226, class_1802.field_8774, class_1802.field_42702, class_1802.field_46991, class_1802.field_22002, class_1802.field_8844, class_1802.field_46992, class_1802.field_8241, class_1802.field_8321, class_1802.field_37529, class_1802.field_8376, class_1802.field_46994, class_1802.field_8495, class_1802.field_22003, class_1802.field_46995, class_1802.field_46996, class_1802.field_46998, class_1802.field_46997, class_1802.field_46993}) {
            MechHopperBlock.addFilter(trapdoor, new TagFilter(BwtItemTags.PASSES_TRAPDOOR_FILTER));
        }
        MechHopperBlock.addFilter(class_1802.field_8067, itemStack -> false);
        MechHopperBlock.addFilter(BwtBlocks.grateBlock.method_8389(), new TagFilter(BwtItemTags.PASSES_GRATE_FILTER));
        MechHopperBlock.addFilter(BwtBlocks.slatsBlock.method_8389(), new TagFilter(BwtItemTags.PASSES_SLATS_FILTER));
        MechHopperBlock.addFilter(BwtBlocks.wickerPaneBlock.method_8389(), new TagFilter(BwtItemTags.PASSES_WICKER_FILTER));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        MechPowerBlockBase.super.method_9515(builder);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MechHopperBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPE;
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        boolean isMechPowered = this.isReceivingMechPower(world, state, pos);
        if (isMechPowered && !this.isMechPowered(state)) {
            world.method_39279(pos, (class_2248)this, MechPowerBlockBase.getTurnOnTickRate());
        } else if (!isMechPowered && this.isMechPowered(state)) {
            world.method_39279(pos, (class_2248)this, MechPowerBlockBase.getTurnOffTickRate());
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        this.schedulePowerUpdate(state, world, pos);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        this.schedulePowerUpdate(state, world, pos);
    }

    public class_2680 getPowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        return (class_2680)state.method_11657((class_2769)MECH_POWERED, (Comparable)Boolean.valueOf(this.isReceivingMechPower(world, state, pos)));
    }

    public void updatePowerTransfer(class_1937 world, class_2680 blockState, class_2338 pos) {
        class_2680 updatedState = this.getPowerStates(blockState, world, pos);
        world.method_8501(pos, updatedState);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MechHopperBlockEntity) {
            MechHopperBlockEntity hopperBlockEntity = (MechHopperBlockEntity)blockEntity;
            hopperBlockEntity.mechPower = (Boolean)updatedState.method_11654((class_2769)MECH_POWERED) != false ? 1 : 0;
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updatePowerTransfer((class_1937)world, state, pos);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (world.field_9236) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MechHopperBlockEntity) {
            MechHopperBlockEntity hopperBlockEntity = (MechHopperBlockEntity)blockEntity;
            MechHopperBlockEntity.onEntityCollided(world, entity, hopperBlockEntity);
        }
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MechHopperBlockEntity) {
            MechHopperBlockEntity hopperBlockEntity = (MechHopperBlockEntity)blockEntity;
            player.method_17355((class_3908)hopperBlockEntity);
        }
        return class_1269.field_21466;
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> !direction.method_10166().method_10178();
    }

    @Nullable
    protected static <A extends class_2586> class_5558<A> validateTicker(class_1937 world, class_2591<A> givenType) {
        return world.field_9236 ? null : class_2237.method_31618(givenType, BwtBlockEntities.mechHopperBlockEntity, MechHopperBlockEntity::tick);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return MechHopperBlock.validateTicker(world, type);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public record TagFilter(class_6862<class_1792> tagKey) implements Predicate<class_1799>
    {
        @Override
        public boolean test(class_1799 itemStack) {
            return itemStack.method_31573(this.tagKey);
        }
    }
}

