/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.mech_hopper;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.mech_hopper.MechHopperBlock;
import com.bwt.blocks.mech_hopper.MechHopperScreenHandler;
import com.bwt.mixin.VanillaHopperInvoker;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.hopper_filter.HopperFilterRecipe;
import com.bwt.recipes.hopper_filter.HopperFilterRecipeInput;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipe;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.SimpleSingleStackInventory;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1267;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class MechHopperBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    public static final int INVENTORY_SIZE = 19;
    protected static final int STACK_SIZE_TO_EJECT = 8;
    protected static final int SOUL_STORAGE_LIMIT = 8;
    protected static final int PICKUP_COOLDOWN = 3;
    protected static final int ITEM_DROP_COOLDOWN = 3;
    protected int mechPower;
    protected int soulCount;
    protected int xpCount;
    protected int itemPickupCooldown;
    protected int itemDropCooldown;
    protected int xpPickupCooldown;
    protected int xpDropCooldown;
    public int slotsOccupied;
    protected boolean outputBlocked;
    public final FilterInventory filterInventory = new FilterInventory();
    public final HopperInventory hopperInventory = new HopperInventory(18);
    public final CombinedStorage<ItemVariant, InventoryStorage> inventoryWrapper = new CombinedStorage(List.of(InventoryStorage.of((class_1263)this.filterInventory, null), InventoryStorage.of((class_1263)this.hopperInventory, null)));
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> MechHopperBlockEntity.this.mechPower;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    MechHopperBlockEntity.this.mechPower = value > 0 ? 1 : 0;
                    break;
                }
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public MechHopperBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.mechHopperBlockEntity, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.filterInventory.readNbt(nbt.method_10562("Filter"), registryLookup);
        this.hopperInventory.method_7659(nbt.method_10554("Inventory", 10), registryLookup);
        this.mechPower = nbt.method_10550("mechPower");
        this.soulCount = nbt.method_10550("soulCount");
        this.xpCount = nbt.method_10550("xpCount");
        this.itemPickupCooldown = nbt.method_10550("itemPickupCooldown");
        this.itemDropCooldown = nbt.method_10550("itemDropCooldown");
        this.xpPickupCooldown = nbt.method_10550("xpPickupCooldown");
        this.xpDropCooldown = nbt.method_10550("xpDropCooldown");
        this.slotsOccupied = nbt.method_10550("slotsOccupied");
        this.outputBlocked = nbt.method_10577("outputBlocked");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Filter", this.filterInventory.toNbt(registryLookup));
        nbt.method_10566("Inventory", (class_2520)this.hopperInventory.method_7660(registryLookup));
        nbt.method_10569("mechPower", this.mechPower);
        nbt.method_10569("soulCount", this.soulCount);
        nbt.method_10569("xpCount", this.xpCount);
        nbt.method_10569("itemPickupCooldown", this.itemPickupCooldown);
        nbt.method_10569("itemDropCooldown", this.itemDropCooldown);
        nbt.method_10569("xpPickupCooldown", this.xpPickupCooldown);
        nbt.method_10569("xpDropCooldown", this.xpDropCooldown);
        nbt.method_10569("slotsOccupied", this.slotsOccupied);
        nbt.method_10556("outputBlocked", this.outputBlocked);
    }

    public void method_5431() {
        int oldSlotsOccupied = this.slotsOccupied;
        this.slotsOccupied = (int)this.hopperInventory.field_5828.stream().filter(stack -> !stack.method_7960()).count();
        int size = this.hopperInventory.method_5439();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            if (oldSlotsOccupied == size && this.slotsOccupied != size || this.slotsOccupied == size && oldSlotsOccupied != size) {
                this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
            }
        }
        super.method_5431();
    }

    public class_1792 getFilterItem() {
        return this.filterInventory.method_54079().method_7909();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, MechHopperBlockEntity blockEntity) {
        if (world.field_9236 || !state.method_27852(BwtBlocks.hopperBlock)) {
            return;
        }
        if (blockEntity.itemPickupCooldown > 0) {
            blockEntity.itemPickupCooldown = (blockEntity.itemPickupCooldown + 1) % 3;
        }
        if (blockEntity.mechPower > 0) {
            if (!blockEntity.outputBlocked) {
                ++blockEntity.itemDropCooldown;
                if (blockEntity.itemDropCooldown >= 3) {
                    blockEntity.attemptToEjectStack(world, pos);
                    blockEntity.itemDropCooldown = 0;
                }
            } else {
                blockEntity.itemDropCooldown = 0;
            }
        } else {
            blockEntity.itemDropCooldown = 0;
            blockEntity.xpDropCooldown = 0;
        }
        if (blockEntity.soulCount > 0) {
            if (blockEntity.getFilterItem().equals(class_1802.field_8067)) {
                MechHopperBlockEntity.bottleSouls(world, blockEntity);
            } else {
                blockEntity.soulCount = 0;
            }
        }
    }

    protected static void bottleSouls(class_1937 world, MechHopperBlockEntity blockEntity) {
        class_2680 blockBelowState = world.method_8320(blockEntity.method_11016().method_10074());
        SoulBottlingRecipeInput recipeInput = new SoulBottlingRecipeInput(blockBelowState.method_26204());
        Optional<SoulBottlingRecipe> optionalRecipe = world.method_8433().method_8132(BwtRecipes.SOUL_BOTTLING_RECIPE_TYPE, (class_9695)recipeInput, world).map(class_8786::comp_1933);
        if (blockEntity.mechPower <= 0) {
            if (blockEntity.soulCount >= 8) {
                MechHopperBlockEntity.soulOverloadExplode(world, blockEntity);
            }
            return;
        }
        if (optionalRecipe.isEmpty()) {
            blockEntity.soulCount = 0;
            return;
        }
        SoulBottlingRecipe recipe = optionalRecipe.get();
        if (blockEntity.soulCount < recipe.soulCount()) {
            return;
        }
        world.method_8650(blockEntity.method_11016().method_10074(), false);
        class_1264.method_5449((class_1937)world, (double)blockEntity.method_11016().method_10263(), (double)(blockEntity.method_11016().method_10264() - 1), (double)blockEntity.method_11016().method_10260(), (class_1799)recipe.getResult());
        blockEntity.soulCount = 0;
    }

    protected static void soulOverloadExplode(class_1937 world, MechHopperBlockEntity blockEntity) {
        world.method_22352(blockEntity.method_11016(), false);
        class_1264.method_5451((class_1937)world, (class_2338)blockEntity.method_11016(), (class_1263)blockEntity.hopperInventory);
        world.method_45447(null, blockEntity.method_11016(), (class_3414)class_3417.field_15152.comp_349(), class_3419.field_15245);
        if (!world.method_8407().equals((Object)class_1267.field_5801)) {
            class_1571 ghastEntity = new class_1571(class_1299.field_6107, world);
            ghastEntity.method_33574(blockEntity.method_11016().method_46558());
            world.method_8649((class_1297)ghastEntity);
        }
    }

    public void attemptToEjectStack(class_1937 world, class_2338 pos) {
        class_1263 inventoryBelow;
        List<Integer> occupiedIndices = IntStream.range(0, this.hopperInventory.method_5439()).filter(i -> !this.method_5438(i).method_7960()).boxed().toList();
        if (occupiedIndices.isEmpty()) {
            return;
        }
        int stackIndex = occupiedIndices.get(world.field_9229.method_39332(0, occupiedIndices.size() - 1));
        class_1799 invStack = this.method_5438(stackIndex);
        int stackCountToDrop = Math.min(8, invStack.method_7947());
        class_2338 belowPos = pos.method_10074();
        class_2680 blockBelowState = world.method_8320(belowPos);
        if (blockBelowState.method_26164(class_3481.field_51989) || blockBelowState.method_45474()) {
            class_1799 ejectStack = invStack.method_46651(stackCountToDrop);
            this.ejectStack(world, this.method_11016(), ejectStack);
            this.method_5434(stackIndex, stackCountToDrop);
        }
        if ((inventoryBelow = class_2614.method_11250((class_1937)world, (class_2338)belowPos)) == null) {
            return;
        }
        if (VanillaHopperInvoker.isInventoryFull(inventoryBelow, class_2350.field_11036)) {
            return;
        }
        stackCountToDrop = Math.min(stackCountToDrop, inventoryBelow.method_5444());
        for (int i2 = 0; i2 < this.hopperInventory.method_5439(); ++i2) {
            if (this.method_5438(i2).method_7960()) continue;
            class_1799 itemStack = this.method_5438(i2);
            class_1799 itemStack2 = class_2614.method_11260((class_1263)this, (class_1263)inventoryBelow, (class_1799)this.method_5434(i2, stackCountToDrop), (class_2350)class_2350.field_11036);
            if (itemStack2.method_7960()) {
                inventoryBelow.method_5431();
                return;
            }
            itemStack.method_7939(itemStack.method_7947() + itemStack2.method_7947());
            if (itemStack.method_7947() != 0) continue;
            this.method_5447(i2, class_1799.field_8037);
        }
    }

    protected void ejectStack(class_1937 world, class_2338 pos, class_1799 stack) {
        float xOffset = world.field_9229.method_43057() * 0.1f + 0.45f;
        float yOffset = -0.35f;
        float zOffset = world.field_9229.method_43057() * 0.1f + 0.45f;
        class_1542 itemEntity = new class_1542(world, (double)((float)pos.method_10263() + xOffset), (double)((float)pos.method_10264() + yOffset), (double)((float)pos.method_10260() + zOffset), stack);
        itemEntity.method_18800(0.0, (double)-0.01f, 0.0);
        itemEntity.method_6982(10);
        world.method_8649((class_1297)itemEntity);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MechHopperScreenHandler(syncId, playerInventory, this.filterInventory, (class_1263)this.hopperInventory, this.propertyDelegate);
    }

    public static void onEntityCollided(class_1937 world, class_1297 entity, MechHopperBlockEntity blockEntity) {
        if (blockEntity.itemPickupCooldown > 0) {
            return;
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            MechHopperBlockEntity.pickupItemEntity(world, itemEntity, blockEntity);
        }
    }

    protected static void pickupItemEntity(class_1937 world, class_1542 itemEntity, MechHopperBlockEntity blockEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (itemStack.method_7960()) {
            return;
        }
        class_1792 filterItem = blockEntity.getFilterItem();
        HopperFilterRecipeInput recipeInput = new HopperFilterRecipeInput(filterItem, itemStack);
        Optional<HopperFilterRecipe> optionalRecipe = world.method_8433().method_8132(BwtRecipes.HOPPER_FILTER_RECIPE_TYPE, (class_9695)recipeInput, world).map(class_8786::comp_1933);
        if (optionalRecipe.isPresent()) {
            MechHopperBlockEntity.processRecipe(world, itemEntity, blockEntity, optionalRecipe.get(), itemStack);
            return;
        }
        if (!MechHopperBlock.filterMap.getOrDefault(filterItem, s -> true).test(itemStack)) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int count = itemStack.method_7947();
            long inserted = StorageUtil.insertStacking((List)((InventoryStorage)blockEntity.inventoryWrapper.parts.get(1)).getSlots(), (Object)ItemVariant.of((class_1799)itemStack), (long)count, (TransactionContext)transaction);
            itemEntity.method_6979(itemEntity.method_6983().method_46651((int)((long)count - inserted)));
            ++blockEntity.itemPickupCooldown;
            transaction.commit();
            blockEntity.hopperInventory.method_5431();
        }
    }

    private static void processRecipe(class_1937 world, class_1542 itemEntity, MechHopperBlockEntity blockEntity, HopperFilterRecipe recipe, class_1799 itemStack) {
        int soulsInserted;
        int operationsSucceeded;
        int inputCount = itemStack.method_7947();
        class_1799 resultStack = recipe.result();
        class_1799 byproductStack = recipe.byproduct();
        if (!resultStack.method_7960()) {
            try (Transaction transaction = Transaction.openOuter();){
                operationsSucceeded = (int)StorageUtil.insertStacking((List)((InventoryStorage)blockEntity.inventoryWrapper.parts.get(1)).getSlots(), (Object)ItemVariant.of((class_1799)resultStack), (long)((long)inputCount * (long)resultStack.method_7947()), (TransactionContext)transaction) / resultStack.method_7947();
                ++blockEntity.itemPickupCooldown;
                transaction.commit();
                blockEntity.hopperInventory.method_5431();
            }
        } else {
            operationsSucceeded = itemStack.method_7947();
        }
        itemEntity.method_6979(itemStack.method_46651(inputCount - operationsSucceeded));
        if (!byproductStack.method_7960()) {
            int spawnCount;
            for (int itemCount = operationsSucceeded * byproductStack.method_7947(); itemCount > 0; itemCount -= spawnCount) {
                spawnCount = Math.min(itemCount, byproductStack.method_7909().method_7882());
                blockEntity.spawnNewItemOnTop(world, itemEntity.method_19538(), new class_1799((class_1935)byproductStack.method_7909(), spawnCount));
            }
        }
        if ((soulsInserted = operationsSucceeded * recipe.soulCount()) > 0) {
            int newSoulCount = blockEntity.soulCount + soulsInserted;
            if (newSoulCount > 8 && blockEntity.mechPower <= 0) {
                MechHopperBlockEntity.soulOverloadExplode(world, blockEntity);
                return;
            }
            blockEntity.soulCount = Math.min(newSoulCount, 8);
            blockEntity.method_5431();
            world.method_8396(null, blockEntity.field_11867, BwtSoundEvents.SOUL_CONVERSION, class_3419.field_15245, 1.0f, 1.5f);
        }
    }

    protected void spawnNewItemOnTop(class_1937 world, class_243 inputPos, class_1799 newItem) {
        class_1264.method_5449((class_1937)world, (double)inputPos.method_10216(), (double)inputPos.method_10214(), (double)inputPos.method_10215(), (class_1799)newItem);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = this.method_38244(registryLookup);
        nbtCompound.method_10569("slotsOccupied", this.slotsOccupied);
        nbtCompound.method_10566("Filter", this.filterInventory.toNbt(registryLookup));
        return nbtCompound;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public int method_5439() {
        return 19;
    }

    public boolean method_5442() {
        return this.hopperInventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        if (slot < 18) {
            return this.hopperInventory.method_5438(slot);
        }
        if (slot == 18) {
            return this.filterInventory.method_54079();
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.hopperInventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.hopperInventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.hopperInventory.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.hopperInventory.method_5443(player);
    }

    public void method_5448() {
        this.hopperInventory.method_5448();
    }

    public class FilterInventory
    extends SimpleSingleStackInventory {
        public FilterInventory() {
            super(1);
        }

        @Override
        public void method_5431() {
            MechHopperBlockEntity.this.method_5431();
        }

        @Override
        public class_2586 method_54080() {
            return MechHopperBlockEntity.this;
        }
    }

    public class HopperInventory
    extends class_1277 {
        public HopperInventory(int size) {
            super(size);
        }

        public void method_5431() {
            MechHopperBlockEntity.this.method_5431();
        }
    }
}

