/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.mill_stone;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.mill_stone.MillStoneBlock;
import com.bwt.blocks.mill_stone.MillStoneScreenHandler;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.mill_stone.MillStoneRecipe;
import com.bwt.recipes.mill_stone.MillStoneRecipeInput;
import com.bwt.utils.OrderedRecipeMatcher;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_9695;

public class MillStoneBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    protected int grindProgressTime;
    public static final int timeToGrind = 200;
    protected static final int INVENTORY_SIZE = 3;
    public final Inventory inventory = new Inventory(3);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of((class_1263)this.inventory, null);
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> MillStoneBlockEntity.this.grindProgressTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    MillStoneBlockEntity.this.grindProgressTime = value;
                    break;
                }
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public MillStoneBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.millStoneBlockEntity, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, MillStoneBlockEntity blockEntity) {
        if (!state.method_27852(BwtBlocks.millStoneBlock) || !((Boolean)state.method_11654((class_2769)MillStoneBlock.MECH_POWERED)).booleanValue()) {
            return;
        }
        MillStoneRecipeInput recipeInput = new MillStoneRecipeInput((List<class_1799>)blockEntity.inventory.method_54454());
        List matches = world.method_8433().method_17877(BwtRecipes.MILL_STONE_RECIPE_TYPE, (class_9695)recipeInput, world);
        if (matches.isEmpty()) {
            if (blockEntity.grindProgressTime != 0) {
                blockEntity.grindProgressTime = 0;
                blockEntity.method_5431();
            }
            return;
        }
        ++blockEntity.grindProgressTime;
        if (blockEntity.grindProgressTime < 200) {
            return;
        }
        blockEntity.grindProgressTime = 0;
        blockEntity.method_5431();
        OrderedRecipeMatcher.getFirstRecipe(matches, (class_2371<class_1799>)blockEntity.inventory.method_54454(), match -> blockEntity.completeRecipe((MillStoneRecipe)match, world, pos));
    }

    public boolean completeRecipe(MillStoneRecipe recipe, class_1937 world, class_2338 pos) {
        try (Transaction transaction = Transaction.openOuter();){
            for (IngredientWithCount ingredientWithCount : recipe.getIngredientsWithCount()) {
                long countToSpend = ingredientWithCount.count();
                while (countToSpend > 0L) {
                    ItemVariant itemVariant = (ItemVariant)StorageUtil.findStoredResource((Storage)this.inventoryWrapper, ingredientWithCount::test);
                    if (itemVariant == null) continue;
                    long taken = this.inventoryWrapper.extract((Object)itemVariant, countToSpend, (TransactionContext)transaction);
                    countToSpend -= taken;
                    if (taken != 0L) continue;
                    transaction.abort();
                    boolean bl = false;
                    return bl;
                }
            }
            for (class_1799 result : recipe.getResults()) {
                MillStoneBlockEntity.ejectItem(world, result, pos);
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public static void ejectItem(class_1937 world, class_1799 stack, class_2338 pos) {
        class_243 centerPos = pos.method_46558();
        class_243 horizontalUnitVector = new class_243(1.0, 0.0, 1.0);
        double angle = Math.toRadians(world.field_9229.method_39332(0, 359));
        double distToEdge = Math.min(0.5 / Math.abs(Math.cos(angle)), 0.5 / Math.abs(Math.sin(angle)));
        class_243 itemPos = horizontalUnitVector.method_1024((float)angle).method_1021(distToEdge + 0.01).method_1019(centerPos);
        class_243 itemVelocity = horizontalUnitVector.method_1024((float)angle).method_1021((double)world.field_9229.method_43057() * 0.0125 + (double)0.1f).method_1031(0.0, world.field_9229.method_43059() * 0.0125 + (double)0.05f, 0.0);
        class_1542 itemEntity = new class_1542(world, itemPos.method_10216(), itemPos.method_10214(), itemPos.method_10215(), stack);
        itemEntity.method_18799(itemVelocity);
        world.method_8649((class_1297)itemEntity);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", 10), registryLookup);
        this.grindProgressTime = nbt.method_10550("grindProgressTime");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660(registryLookup));
        nbt.method_10569("grindProgressTime", this.grindProgressTime);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new MillStoneScreenHandler(syncId, playerInventory, (class_1263)this.inventory, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public int method_5439() {
        return this.inventory.method_5439();
    }

    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public class Inventory
    extends class_1277 {
        public Inventory(int size) {
            super(size);
        }

        public void method_5431() {
            MillStoneBlockEntity.this.method_5431();
        }
    }
}

